/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.keybindings;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import net.java.sip.communicator.service.keybindings.KeybindingSet;

class KeybindingSetImpl
extends KeybindingSet {
    private LinkedHashMap<KeyStroke, String> bindings;
    private KeybindingSet.Category category;
    private File customFile;
    private boolean isInvalidated = false;

    KeybindingSetImpl(Map<KeyStroke, String> initial, KeybindingSet.Category category, File saveDst) {
        this.bindings = new LinkedHashMap<KeyStroke, String>(initial);
        this.category = category;
        this.customFile = saveDst;
    }

    public LinkedHashMap<KeyStroke, String> getBindings() {
        return new LinkedHashMap<KeyStroke, String>(this.bindings);
    }

    @Override
    public void setBindings(Map<KeyStroke, String> newBindings) {
        if (!this.bindings.equals(newBindings)) {
            this.bindings = new LinkedHashMap<KeyStroke, String>(newBindings);
            this.setChanged();
            this.notifyObservers(this);
        }
    }

    @Override
    public KeybindingSet.Category getCategory() {
        return this.category;
    }

    boolean isWritable() {
        return !this.isInvalidated && this.customFile != null;
    }

    File getCustomFile() {
        return this.customFile;
    }

    void invalidate() {
        this.isInvalidated = true;
    }
}

