/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.customcontrols;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.ImageObserver;
import javax.swing.BorderFactory;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTextButton;

public class SIPCommNotificationsButton
extends SIPCommTextButton {
    protected Image defaultImage;
    protected Image pressedImage;
    protected Image notificationImage;
    private boolean hasNotifications = false;
    private boolean defaultViewVisible = false;
    private boolean toggleDisabled = false;

    public SIPCommNotificationsButton(String text) {
        super(text);
        this.loadSkin();
        this.setForeground(Color.WHITE);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setFont(this.getFont().deriveFont(1, 10.0f));
        this.setBackground(new Color(255, 255, 255, 160));
    }

    public void loadSkin() {
        this.notificationImage = ImageLoader.getImage(ImageLoader.CALL_HISTORY_BUTTON_NOTIFICATION);
        this.setPreferredSize(new Dimension(this.defaultImage.getWidth((ImageObserver)((Object)this)), this.defaultImage.getHeight((ImageObserver)((Object)this))));
    }

    public void setToggleDisabled(boolean disableToggle) {
        this.toggleDisabled = disableToggle;
    }

    public boolean isToggleDisabled() {
        return this.toggleDisabled;
    }

    public boolean hasNotifications() {
        return this.hasNotifications;
    }

    public void setHasNotifications(boolean hasNotifications) {
        this.hasNotifications = hasNotifications;
    }

    public boolean isDefaultViewVisible() {
        return this.defaultViewVisible;
    }

    public void setDefaultViewVisible(boolean defaultViewVisible) {
        this.defaultViewVisible = defaultViewVisible;
    }

    public void setNotifications(int count) {
        this.setHasNotifications(true);
        this.setBackground(new Color(200, 0, 0));
        this.setVerticalTextPosition(1);
        Image iconImage = ImageLoader.getImage(this.notificationImage, new Integer(count).toString(), (Component)((Object)this));
        if (this.isDefaultViewVisible()) {
            this.setBgImage(ImageLoader.getImage(this.pressedImage, iconImage, this.pressedImage.getWidth(null) / 2 - this.notificationImage.getWidth(null) / 2, 0));
        } else {
            this.setBgImage(ImageLoader.getImage(this.defaultImage, iconImage, this.pressedImage.getWidth(null) / 2 - this.notificationImage.getWidth(null) / 2, 0));
        }
    }

    public void clearNotifications() {
        if (this.hasNotifications()) {
            this.setHasNotifications(false);
        } else {
            this.setIcon(null);
        }
        if (!this.isToggleDisabled() && this.isDefaultViewVisible()) {
            this.setBgImage(this.pressedImage);
        } else {
            this.setBgImage(this.defaultImage);
        }
        this.setText("");
    }
}

