/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.util.Iterator;
import net.java.sip.communicator.impl.gui.main.call.AbstractCallToggleButton;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.util.Logger;

public class HoldButton
extends AbstractCallToggleButton {
    private static final Logger logger = Logger.getLogger(HoldButton.class);
    private static final long serialVersionUID = 0L;

    public HoldButton(Call call) {
        this(call, false);
    }

    public HoldButton(Call call, boolean selected) {
        super(call, true, selected, ImageLoader.HOLD_BUTTON, ImageLoader.HOLD_BUTTON_PRESSED, "service.gui.HOLD_BUTTON_TOOL_TIP");
    }

    @Override
    public void buttonPressed() {
        if (this.call != null) {
            Iterator peers = this.call.getCallPeers();
            boolean on = this.isSelected();
            OperationSetBasicTelephony telephony = (OperationSetBasicTelephony)this.call.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class);
            while (peers.hasNext()) {
                CallPeer callPeer = (CallPeer)peers.next();
                try {
                    if (on) {
                        telephony.putOnHold(callPeer);
                        continue;
                    }
                    telephony.putOffHold(callPeer);
                }
                catch (OperationFailedException ofex) {
                    logger.error((Object)("Failed to put " + (on ? "on" : "off") + " hold."), (Throwable)ofex);
                }
            }
        }
    }
}

