/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.filetransfer;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatConversationComponent;
import net.java.sip.communicator.impl.gui.utils.FileImageLabel;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.FileTransfer;
import net.java.sip.communicator.service.protocol.event.FileTransferProgressEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferProgressListener;
import net.java.sip.communicator.util.ByteFormat;
import net.java.sip.communicator.util.GuiUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;

public abstract class FileTransferConversationComponent
extends ChatConversationComponent
implements ActionListener,
FileTransferProgressListener,
Skinnable {
    private final Logger logger = Logger.getLogger(FileTransferConversationComponent.class);
    protected static final int IMAGE_WIDTH = 64;
    protected static final int IMAGE_HEIGHT = 64;
    protected final FileImageLabel imageLabel;
    protected final JLabel titleLabel = new JLabel();
    protected final JLabel fileLabel = new JLabel();
    private final JTextArea errorArea = new JTextArea();
    private final JLabel errorIconLabel = new JLabel(new ImageIcon(ImageLoader.getImage(ImageLoader.EXCLAMATION_MARK)));
    protected final ChatConversationComponent.ChatConversationButton cancelButton = new ChatConversationComponent.ChatConversationButton();
    protected final ChatConversationComponent.ChatConversationButton retryButton = new ChatConversationComponent.ChatConversationButton();
    protected final ChatConversationComponent.ChatConversationButton acceptButton = new ChatConversationComponent.ChatConversationButton();
    protected final ChatConversationComponent.ChatConversationButton rejectButton = new ChatConversationComponent.ChatConversationButton();
    protected final ChatConversationComponent.ChatConversationButton openFileButton = new ChatConversationComponent.ChatConversationButton();
    protected final ChatConversationComponent.ChatConversationButton openFolderButton = new ChatConversationComponent.ChatConversationButton();
    protected final JProgressBar progressBar = new JProgressBar();
    private final TransparentPanel progressPropertiesPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
    private final JLabel progressSpeedLabel = new JLabel();
    private final JLabel estimatedTimeLabel = new JLabel();
    private File downloadFile;
    private FileTransfer fileTransfer;
    private static final int SPEED_CALCULATE_DELAY = 5000;
    private long transferredFileSize = 0L;
    private long lastSpeedTimestamp = 0L;
    private long lastEstimatedTimeTimestamp = 0L;
    private long lastTransferredBytes = 0L;
    private long lastProgressSpeed;
    private long lastEstimatedTime;

    public FileTransferConversationComponent() {
        this.imageLabel = new FileImageLabel();
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 4;
        this.constraints.anchor = 18;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)((Object)this.imageLabel), this.constraints);
        this.imageLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.DEFAULT_FILE_ICON)));
        this.constraints.gridx = 1;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 3;
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 18;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.titleLabel, this.constraints);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1, 11.0f));
        this.constraints.gridx = 1;
        this.constraints.gridy = 1;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.fileLabel, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 1;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(0, 5, 0, 5);
        this.constraints.fill = 0;
        this.add((Component)this.errorIconLabel, this.constraints);
        this.errorIconLabel.setVisible(false);
        this.constraints.gridx = 2;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 2;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(0, 5, 0, 5);
        this.constraints.fill = 2;
        this.add((Component)this.errorArea, this.constraints);
        this.errorArea.setForeground(new Color(resources.getColor("service.gui.ERROR_FOREGROUND")));
        this.setTextAreaStyle(this.errorArea);
        this.errorArea.setVisible(false);
        this.constraints.gridx = 1;
        this.constraints.gridy = 3;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 0.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.retryButton, this.constraints);
        this.retryButton.setText(GuiActivator.getResources().getI18NString("service.gui.RETRY"));
        this.retryButton.setVisible(false);
        this.constraints.gridx = 1;
        this.constraints.gridy = 3;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 0.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.cancelButton, this.constraints);
        this.cancelButton.setText(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setVisible(false);
        this.constraints.gridx = 2;
        this.constraints.gridy = 3;
        this.constraints.gridwidth = -1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 0.0;
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.constraints.insets = new Insets(0, 5, 0, 5);
        this.constraints.gridx = 3;
        this.constraints.gridy = 3;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 0.0;
        this.constraints.fill = 0;
        this.constraints.anchor = 22;
        this.constraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.progressPropertiesPanel, this.constraints);
        this.estimatedTimeLabel.setFont(this.estimatedTimeLabel.getFont().deriveFont(11.0f));
        this.estimatedTimeLabel.setVisible(false);
        this.progressSpeedLabel.setFont(this.progressSpeedLabel.getFont().deriveFont(11.0f));
        this.progressSpeedLabel.setVisible(false);
        this.progressPropertiesPanel.add((Component)this.progressSpeedLabel);
        this.progressPropertiesPanel.add((Component)this.estimatedTimeLabel);
        this.constraints.gridx = 1;
        this.constraints.gridy = 3;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 0.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(0, 5, 0, 5);
        this.constraints.fill = 0;
        this.add((Component)this.acceptButton, this.constraints);
        this.acceptButton.setText(GuiActivator.getResources().getI18NString("service.gui.ACCEPT"));
        this.acceptButton.setVisible(false);
        this.constraints.gridx = 2;
        this.constraints.gridy = 3;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 0.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(0, 5, 0, 5);
        this.constraints.fill = 0;
        this.add((Component)this.rejectButton, this.constraints);
        this.rejectButton.setText(GuiActivator.getResources().getI18NString("service.gui.REJECT"));
        this.rejectButton.setVisible(false);
        this.constraints.gridx = 1;
        this.constraints.gridy = 3;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 0.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(0, 5, 0, 5);
        this.constraints.fill = 0;
        this.add((Component)this.openFileButton, this.constraints);
        this.openFileButton.setText(GuiActivator.getResources().getI18NString("service.gui.OPEN"));
        this.openFileButton.setVisible(false);
        this.openFileButton.addActionListener(this);
        this.constraints.gridx = 2;
        this.constraints.gridy = 3;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 0.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(0, 5, 0, 5);
        this.constraints.fill = 0;
        this.add((Component)this.openFolderButton, this.constraints);
        this.openFolderButton.setText(GuiActivator.getResources().getI18NString("service.gui.OPEN_FOLDER"));
        this.openFolderButton.setVisible(false);
        this.openFolderButton.addActionListener(this);
        this.constraints.gridx = 1;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 3;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(0, 5, 0, 5);
        this.constraints.ipadx = 150;
        this.constraints.fill = 2;
        this.add((Component)this.progressBar, this.constraints);
        this.progressBar.setVisible(false);
        this.progressBar.setStringPainted(true);
    }

    private void setTextAreaStyle(JTextArea textArea) {
        textArea.setOpaque(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
    }

    @Override
    protected void showErrorMessage(String message) {
        this.errorArea.setText(message);
        this.errorIconLabel.setVisible(true);
        this.errorArea.setVisible(true);
    }

    protected void setCompletedDownloadFile(File file) {
        this.downloadFile = file;
        this.imageLabel.setFile(this.downloadFile);
        this.imageLabel.setToolTipText(resources.getI18NString("service.gui.OPEN_FILE_FROM_IMAGE"));
        this.imageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    FileTransferConversationComponent.this.openFile(FileTransferConversationComponent.this.downloadFile);
                }
            }
        });
    }

    protected void setFileTransfer(FileTransfer fileTransfer, long transferredFileSize) {
        this.fileTransfer = fileTransfer;
        this.transferredFileSize = transferredFileSize;
        fileTransfer.addProgressListener((FileTransferProgressListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JButton sourceButton = (JButton)evt.getSource();
        if (sourceButton.equals(this.openFileButton)) {
            this.openFile(this.downloadFile);
        } else if (sourceButton.equals(this.openFolderButton)) {
            try {
                File downloadDir = GuiActivator.getFileAccessService().getDefaultDownloadDirectory();
                GuiActivator.getDesktopService().open(downloadDir);
            }
            catch (IllegalArgumentException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Unable to open folder.", (Throwable)e);
                }
                this.showErrorMessage(resources.getI18NString("service.gui.FOLDER_DOES_NOT_EXIST"));
            }
            catch (NullPointerException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Unable to open folder.", (Throwable)e);
                }
                this.showErrorMessage(resources.getI18NString("service.gui.FOLDER_DOES_NOT_EXIST"));
            }
            catch (UnsupportedOperationException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Unable to open folder.", (Throwable)e);
                }
                this.showErrorMessage(resources.getI18NString("service.gui.FILE_OPEN_NOT_SUPPORTED"));
            }
            catch (SecurityException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Unable to open folder.", (Throwable)e);
                }
                this.showErrorMessage(resources.getI18NString("service.gui.FOLDER_OPEN_NO_PERMISSION"));
            }
            catch (IOException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Unable to open folder.", (Throwable)e);
                }
                this.showErrorMessage(resources.getI18NString("service.gui.FOLDER_OPEN_NO_APPLICATION"));
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Unable to open file.", (Throwable)e);
                }
                this.showErrorMessage(resources.getI18NString("service.gui.FOLDER_OPEN_FAILED"));
            }
        } else if (sourceButton.equals(this.cancelButton) && this.fileTransfer != null) {
            this.fileTransfer.cancel();
        }
    }

    public void progressChanged(FileTransferProgressEvent event) {
        this.progressBar.setValue((int)event.getProgress());
        long transferredBytes = event.getFileTransfer().getTransferedBytes();
        long progressTimestamp = event.getTimestamp();
        String bytesString = ByteFormat.format((long)transferredBytes);
        if (progressTimestamp - this.lastSpeedTimestamp >= 5000L) {
            this.lastProgressSpeed = Math.round(this.calculateProgressSpeed(transferredBytes));
            this.lastSpeedTimestamp = progressTimestamp;
            this.lastTransferredBytes = transferredBytes;
        }
        if (progressTimestamp - this.lastEstimatedTimeTimestamp >= 5000L && this.lastProgressSpeed > 0L) {
            this.lastEstimatedTime = Math.round(this.calculateEstimatedTransferTime(this.lastProgressSpeed, this.transferredFileSize - transferredBytes));
            this.lastEstimatedTimeTimestamp = progressTimestamp;
        }
        this.progressBar.setString(this.getProgressLabel(bytesString));
        if (this.lastProgressSpeed > 0L) {
            this.progressSpeedLabel.setText(resources.getI18NString("service.gui.SPEED") + ByteFormat.format((long)this.lastProgressSpeed) + "/sec");
            this.progressSpeedLabel.setVisible(true);
        }
        if (this.lastEstimatedTime > 0L) {
            this.estimatedTimeLabel.setText(resources.getI18NString("service.gui.ESTIMATED_TIME") + GuiUtils.formatSeconds((long)(this.lastEstimatedTime * 1000L)));
            this.estimatedTimeLabel.setVisible(true);
        }
    }

    protected String getFileLabel(File file) {
        String fileName = file.getName();
        long fileSize = file.length();
        String text = ByteFormat.format((long)fileSize);
        return fileName + " (" + text + ")";
    }

    protected String getFileLabel(String fileName, long fileSize) {
        String text = ByteFormat.format((long)fileSize);
        return fileName + " (" + text + ")";
    }

    protected void hideProgressRelatedComponents() {
        this.progressBar.setVisible(false);
        this.progressSpeedLabel.setVisible(false);
        this.estimatedTimeLabel.setVisible(false);
    }

    protected abstract String getProgressLabel(String var1);

    private double calculateProgressSpeed(long transferredBytes) {
        return (transferredBytes - this.lastTransferredBytes) / 5000L * 1000L;
    }

    private double calculateEstimatedTransferTime(double speed, long bytesLeft) {
        return (double)bytesLeft / speed;
    }

    @Override
    public void loadSkin() {
        this.errorIconLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.EXCLAMATION_MARK)));
        if (this.downloadFile != null) {
            this.imageLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.DEFAULT_FILE_ICON)));
        }
        this.errorArea.setForeground(new Color(resources.getColor("service.gui.ERROR_FOREGROUND")));
    }
}

