/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatConversationContainer;
import net.java.sip.communicator.impl.gui.main.chat.ChatConversationPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatMessage;
import net.java.sip.communicator.impl.gui.main.chat.filetransfer.FileHistoryConversationComponent;
import net.java.sip.communicator.impl.gui.main.chat.history.DatesPanel;
import net.java.sip.communicator.impl.gui.main.chat.history.HistoryMenu;
import net.java.sip.communicator.impl.gui.main.chat.history.SearchPanel;
import net.java.sip.communicator.plugin.desktoputil.ExtendedTransferHandler;
import net.java.sip.communicator.plugin.desktoputil.SIPCommFrame;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.filehistory.FileHistoryService;
import net.java.sip.communicator.service.filehistory.FileRecord;
import net.java.sip.communicator.service.history.event.HistorySearchProgressListener;
import net.java.sip.communicator.service.history.event.ProgressEvent;
import net.java.sip.communicator.service.metahistory.MetaHistoryService;
import net.java.sip.communicator.service.msghistory.MessageHistoryService;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageListener;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.util.GuiUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;

public class HistoryWindow
extends SIPCommFrame
implements ChatConversationContainer,
HistorySearchProgressListener,
MessageListener,
ChatRoomMessageListener,
Skinnable {
    private static final Logger logger = Logger.getLogger(HistoryWindow.class);
    private static final String[] HISTORY_FILTER = new String[]{MessageHistoryService.class.getName(), FileHistoryService.class.getName()};
    private static final int SPACING = 5;
    private ChatConversationPanel chatConvPanel;
    private final JPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
    private JProgressBar progressBar;
    private HistoryMenu historyMenu;
    private DatesPanel datesPanel;
    private Object historyContact;
    private MetaHistoryService history;
    private Hashtable<Date, HTMLDocument> dateHistoryTable = new Hashtable();
    private final JLabel readyLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.READY"));
    private String searchKeyword;
    private Set<Date> datesDisplayed = new LinkedHashSet<Date>();
    private Date ignoreProgressDate;
    private int lastProgress = 0;
    private List<OperationSetBasicInstantMessaging> basicInstantMessagings;
    private ChatRoom chatRoom;

    public HistoryWindow(Object historyContact) {
        this.historyContact = historyContact;
        this.chatConvPanel = new ChatConversationPanel(this);
        this.chatConvPanel.getChatTextPane().setTransferHandler((TransferHandler)new ExtendedTransferHandler());
        this.progressBar = new JProgressBar(0, 1000);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.history = GuiActivator.getMetaHistoryService();
        this.history.addSearchProgressListener((HistorySearchProgressListener)this);
        this.datesPanel = new DatesPanel(this);
        this.historyMenu = new HistoryMenu((JFrame)((Object)this));
        this.initPanels();
        this.initDates();
        this.pack();
        if (historyContact instanceof MetaContact) {
            MetaContact metaContact = (MetaContact)historyContact;
            this.setTitle(GuiActivator.getResources().getI18NString("service.gui.HISTORY_CONTACT", new String[]{metaContact.getDisplayName()}));
            Iterator protoContacts = metaContact.getContacts();
            this.basicInstantMessagings = new ArrayList<OperationSetBasicInstantMessaging>();
            while (protoContacts.hasNext()) {
                Contact protoContact = (Contact)protoContacts.next();
                OperationSetBasicInstantMessaging basicInstantMessaging = (OperationSetBasicInstantMessaging)protoContact.getProtocolProvider().getOperationSet(OperationSetBasicInstantMessaging.class);
                if (basicInstantMessaging == null) continue;
                basicInstantMessaging.addMessageListener((MessageListener)this);
                this.basicInstantMessagings.add(basicInstantMessaging);
            }
        } else if (historyContact instanceof ChatRoomWrapper) {
            this.chatRoom = ((ChatRoomWrapper)historyContact).getChatRoom();
            this.chatRoom.addMessageListener((ChatRoomMessageListener)this);
        }
    }

    private void initPanels() {
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.mainPanel.setPreferredSize(new Dimension(500, 400));
        this.mainPanel.add((Component)((Object)new SearchPanel(this)), "North");
        this.mainPanel.add((Component)((Object)this.chatConvPanel), "Center");
        this.mainPanel.add((Component)((Object)this.datesPanel), "West");
        this.getContentPane().add(this.mainPanel);
    }

    private void initDates() {
        this.initProgressBar(null);
        new DatesLoader().start();
    }

    public void showHistoryByPeriod(Date startDate, Date endDate) {
        if ((this.searchKeyword == null || this.searchKeyword.length() == 0) && this.dateHistoryTable.containsKey(startDate)) {
            HTMLDocument document = this.dateHistoryTable.get(startDate);
            this.chatConvPanel.setContent(document);
        } else {
            this.chatConvPanel.clear();
            this.initProgressBar(startDate);
            new MessagesLoader(startDate, endDate).start();
        }
    }

    public void showHistoryByKeyword(String keyword) {
        this.initProgressBar(null);
        this.chatConvPanel.clear();
        this.datesPanel.setLastSelectedIndex(-1);
        new KeywordDatesLoader(keyword).start();
        this.searchKeyword = keyword;
    }

    private HTMLDocument createHistory(Collection<Object> historyRecords) {
        if (historyRecords != null && historyRecords.size() > 0) {
            Iterator<Object> i = historyRecords.iterator();
            String processedMessage = "";
            while (i.hasNext()) {
                MessageDeliveredEvent evt;
                Object o = i.next();
                ChatMessage chatMessage = null;
                ProtocolProviderService protocolProvider = null;
                if (o instanceof MessageDeliveredEvent) {
                    evt = (MessageDeliveredEvent)o;
                    protocolProvider = evt.getDestinationContact().getProtocolProvider();
                    chatMessage = new ChatMessage(GuiActivator.getUIService().getMainFrame().getAccountAddress(protocolProvider), GuiActivator.getUIService().getMainFrame().getAccountDisplayName(protocolProvider), evt.getTimestamp(), "OutgoingMessage", null, evt.getSourceMessage().getContent(), evt.getSourceMessage().getContentType(), evt.getSourceMessage().getMessageUID(), null);
                } else if (o instanceof MessageReceivedEvent) {
                    evt = (MessageReceivedEvent)o;
                    protocolProvider = evt.getSourceContact().getProtocolProvider();
                    chatMessage = new ChatMessage(evt.getSourceContact().getAddress(), evt.getSourceContact().getDisplayName(), evt.getTimestamp(), "IncomingMessage", null, evt.getSourceMessage().getContent(), evt.getSourceMessage().getContentType(), evt.getSourceMessage().getMessageUID(), null);
                } else if (o instanceof ChatRoomMessageReceivedEvent) {
                    evt = (ChatRoomMessageReceivedEvent)o;
                    protocolProvider = evt.getSourceChatRoom().getParentProvider();
                    chatMessage = new ChatMessage(evt.getSourceChatRoomMember().getName(), evt.getTimestamp(), "IncomingMessage", evt.getMessage().getContent(), evt.getMessage().getContentType());
                } else if (o instanceof ChatRoomMessageDeliveredEvent) {
                    evt = (ChatRoomMessageDeliveredEvent)o;
                    protocolProvider = evt.getSourceChatRoom().getParentProvider();
                    chatMessage = new ChatMessage(evt.getSourceChatRoom().getParentProvider().getAccountID().getUserID(), evt.getTimestamp(), "IncomingMessage", evt.getMessage().getContent(), evt.getMessage().getContentType());
                } else if (o instanceof FileRecord) {
                    FileRecord fileRecord = (FileRecord)o;
                    protocolProvider = fileRecord.getContact().getProtocolProvider();
                    FileHistoryConversationComponent component = new FileHistoryConversationComponent(fileRecord);
                    this.chatConvPanel.addComponent(component);
                }
                if (chatMessage == null) continue;
                processedMessage = this.chatConvPanel.processMessage(chatMessage, this.searchKeyword, protocolProvider, chatMessage.getContactName());
                this.chatConvPanel.appendMessageToEnd(processedMessage, "text/html");
            }
        }
        this.chatConvPanel.setDefaultContent();
        return this.chatConvPanel.getContent();
    }

    @Override
    public void addTypingNotification(String message) {
    }

    @Override
    public Window getConversationContainerWindow() {
        return this;
    }

    public Date getNextDateFromHistory(Date date) {
        Iterator<Date> iterator = this.datesDisplayed.iterator();
        while (iterator.hasNext()) {
            Date curr = iterator.next();
            if (!curr.equals(date)) continue;
            if (!iterator.hasNext()) break;
            return iterator.next();
        }
        return new Date(System.currentTimeMillis());
    }

    public void progressChanged(ProgressEvent evt) {
        int progress = evt.getProgress();
        if (this.lastProgress != progress && evt.getStartDate() == null || evt.getStartDate() != this.ignoreProgressDate) {
            this.progressBar.setValue(progress);
            if (this.progressBar.getPercentComplete() == 1.0) {
                Timer progressBarTimer = new Timer(1000, null);
                progressBarTimer.setRepeats(false);
                progressBarTimer.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HistoryWindow.this.mainPanel.remove(HistoryWindow.this.progressBar);
                        HistoryWindow.this.mainPanel.add((Component)HistoryWindow.this.readyLabel, "South");
                        HistoryWindow.this.mainPanel.revalidate();
                        HistoryWindow.this.mainPanel.repaint();
                        HistoryWindow.this.progressBar.setValue(0);
                    }
                });
                progressBarTimer.start();
            }
            this.lastProgress = progress;
        }
    }

    protected void close(boolean isEscaped) {
        this.history.removeSearchProgressListener((HistorySearchProgressListener)this);
        if (this.basicInstantMessagings != null) {
            for (OperationSetBasicInstantMessaging basicInstantMessaging : this.basicInstantMessagings) {
                basicInstantMessaging.removeMessageListener((MessageListener)this);
            }
            this.basicInstantMessagings = null;
        }
        if (this.chatRoom != null) {
            this.chatRoom.removeMessageListener((ChatRoomMessageListener)this);
            this.chatRoom = null;
        }
        if (this.chatConvPanel != null && this.chatConvPanel.getRightButtonMenu() != null && this.chatConvPanel.getRightButtonMenu().isVisible()) {
            this.chatConvPanel.getRightButtonMenu().setVisible(false);
        } else if (this.historyMenu != null && this.historyMenu.isPopupMenuVisible()) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
        } else {
            GuiActivator.getUIService().getHistoryWindowManager().removeHistoryWindowForContact(this.historyContact);
            if (this.datesPanel != null) {
                this.datesPanel.dispose();
            }
            if (this.chatConvPanel != null) {
                this.chatConvPanel.dispose();
            }
            this.dispose();
        }
    }

    private void initProgressBar(Date date) {
        if (date == null || date != this.ignoreProgressDate) {
            this.mainPanel.remove(this.readyLabel);
            this.mainPanel.add((Component)this.progressBar, "South");
            this.mainPanel.revalidate();
            this.mainPanel.repaint();
        }
    }

    public void messageReceived(MessageReceivedEvent evt) {
        Contact sourceContact = evt.getSourceContact();
        Message sourceMessage = evt.getSourceMessage();
        this.processMessage(sourceContact, evt.getTimestamp(), "IncomingMessage", sourceMessage.getContent(), sourceMessage.getContentType());
    }

    public void messageDelivered(MessageDeliveredEvent evt) {
        Contact destContact = evt.getDestinationContact();
        Message sourceMessage = evt.getSourceMessage();
        this.processMessage(destContact, evt.getTimestamp(), "OutgoingMessage", sourceMessage.getContent(), sourceMessage.getContentType());
    }

    public void messageDeliveryFailed(MessageDeliveryFailedEvent evt) {
    }

    private void processMessage(Contact contact, Date timestamp, String messageType, String messageContent, String messageContentType) {
        if (!(this.historyContact instanceof MetaContact)) {
            return;
        }
        Contact containedContact = ((MetaContact)this.historyContact).getContact(contact.getAddress(), contact.getProtocolProvider());
        if (containedContact != null) {
            int lastDateIndex = this.datesPanel.getDatesNumber() - 1;
            if (lastDateIndex < 0) {
                return;
            }
            Date lastDate = this.datesPanel.getDate(lastDateIndex);
            if (lastDate != null && GuiUtils.compareDatesOnly((Date)lastDate, (Date)timestamp) == 0) {
                ChatMessage chatMessage;
                String processedMessage;
                HTMLDocument document = this.dateHistoryTable.get(lastDate);
                if (document != null && (processedMessage = this.chatConvPanel.processMessage(chatMessage = new ChatMessage(contact.getDisplayName(), timestamp, messageType, messageContent, messageContentType), this.searchKeyword, contact.getProtocolProvider(), contact.getAddress())) != null) {
                    this.appendMessageToDocument(document, processedMessage);
                }
            } else if (lastDate == null || GuiUtils.compareDatesOnly((Date)lastDate, (Date)timestamp) < 0) {
                long milisecondsPerDay = 86400000L;
                Date date = new Date(timestamp.getTime() - timestamp.getTime() % milisecondsPerDay);
                this.datesDisplayed.add(date);
                if (!this.datesPanel.containsDate(date)) {
                    this.datesPanel.addDate(date);
                }
            }
        }
    }

    private void appendMessageToDocument(HTMLDocument doc, String chatString) {
        Element root = doc.getDefaultRootElement();
        try {
            doc.insertAfterEnd(root.getElement(root.getElementCount() - 1), chatString);
        }
        catch (BadLocationException e) {
            logger.error((Object)"Insert in the HTMLDocument failed.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Insert in the HTMLDocument failed.", (Throwable)e);
        }
    }

    public void messageDelivered(ChatRoomMessageDeliveredEvent evt) {
    }

    public void messageDeliveryFailed(ChatRoomMessageDeliveryFailedEvent evt) {
    }

    public void messageReceived(ChatRoomMessageReceivedEvent evt) {
    }

    public void loadSkin() {
        this.dateHistoryTable.clear();
        Date startDate = this.datesPanel.getDate(this.datesPanel.getLastSelectedIndex());
        this.chatConvPanel.clear();
        this.initProgressBar(startDate);
        new MessagesLoader(startDate, this.getNextDateFromHistory(startDate)).start();
    }

    private class KeywordDatesLoader
    extends Thread {
        private Vector<Date> keywordDatesVector = new Vector();
        private final String keyword;

        public KeywordDatesLoader(String keyword) {
            this.keyword = keyword;
        }

        @Override
        public void run() {
            Collection msgList = null;
            if (HistoryWindow.this.historyContact instanceof MetaContact) {
                msgList = HistoryWindow.this.history.findByKeyword(HISTORY_FILTER, HistoryWindow.this.historyContact, this.keyword);
            } else if (HistoryWindow.this.historyContact instanceof ChatRoomWrapper) {
                ChatRoomWrapper chatRoomWrapper = (ChatRoomWrapper)HistoryWindow.this.historyContact;
                if (chatRoomWrapper.getChatRoom() == null) {
                    return;
                }
                msgList = HistoryWindow.this.history.findByKeyword(HISTORY_FILTER, (Object)chatRoomWrapper.getChatRoom(), this.keyword);
            }
            if (msgList != null) {
                for (Object o : msgList) {
                    Date date = new Date(0L);
                    if (o instanceof MessageDeliveredEvent) {
                        MessageDeliveredEvent evt = (MessageDeliveredEvent)o;
                        date = evt.getTimestamp();
                    } else if (o instanceof MessageReceivedEvent) {
                        MessageReceivedEvent evt = (MessageReceivedEvent)o;
                        date = evt.getTimestamp();
                    }
                    long milisecondsPerDay = 86400000L;
                    for (Date date1 : HistoryWindow.this.datesDisplayed) {
                        if (Math.floor(date1.getTime() / milisecondsPerDay) != Math.floor(date.getTime() / milisecondsPerDay) || this.keywordDatesVector.contains(date1)) continue;
                        this.keywordDatesVector.add(date1);
                    }
                }
            }
            Runnable updateDatesPanel = new Runnable(){

                @Override
                public void run() {
                    HistoryWindow.this.datesPanel.removeAllDates();
                    if (KeywordDatesLoader.this.keywordDatesVector.size() > 0) {
                        Date date = null;
                        for (int i = 0; i < KeywordDatesLoader.this.keywordDatesVector.size(); ++i) {
                            date = (Date)KeywordDatesLoader.this.keywordDatesVector.get(i);
                            if (HistoryWindow.this.datesPanel.containsDate(date)) continue;
                            HistoryWindow.this.datesPanel.addDate(date);
                        }
                        if (date != null) {
                            HistoryWindow.this.ignoreProgressDate = date;
                        }
                        HistoryWindow.this.datesPanel.setSelected(HistoryWindow.this.datesPanel.getDatesNumber() - 1);
                    } else {
                        HistoryWindow.this.chatConvPanel.setDefaultContent();
                    }
                }
            };
            SwingUtilities.invokeLater(updateDatesPanel);
        }
    }

    private class MessagesLoader
    extends Thread {
        private final Date startDate;
        private final Date endDate;

        public MessagesLoader(Date startDate, Date endDate) {
            this.startDate = startDate;
            this.endDate = endDate;
        }

        @Override
        public void run() {
            Collection msgList;
            if (HistoryWindow.this.historyContact instanceof MetaContact) {
                msgList = HistoryWindow.this.history.findByPeriod(HISTORY_FILTER, HistoryWindow.this.historyContact, this.startDate, this.endDate);
            } else if (HistoryWindow.this.historyContact instanceof ChatRoomWrapper) {
                ChatRoomWrapper chatRoomWrapper = (ChatRoomWrapper)HistoryWindow.this.historyContact;
                if (chatRoomWrapper.getChatRoom() == null) {
                    return;
                }
                msgList = HistoryWindow.this.history.findByPeriod(HISTORY_FILTER, (Object)chatRoomWrapper.getChatRoom(), this.startDate, this.endDate);
            } else {
                msgList = null;
            }
            Runnable updateMessagesPanel = new Runnable(){

                @Override
                public void run() {
                    HTMLDocument doc = HistoryWindow.this.createHistory(msgList);
                    if (HistoryWindow.this.searchKeyword == null || HistoryWindow.this.searchKeyword.length() == 0) {
                        HistoryWindow.this.dateHistoryTable.put(MessagesLoader.this.startDate, doc);
                    }
                }
            };
            SwingUtilities.invokeLater(updateMessagesPanel);
        }
    }

    private class DatesLoader
    extends Thread {
        private DatesLoader() {
        }

        @Override
        public void run() {
            Collection msgList = null;
            if (HistoryWindow.this.historyContact instanceof MetaContact) {
                msgList = HistoryWindow.this.history.findByEndDate(HISTORY_FILTER, HistoryWindow.this.historyContact, new Date(System.currentTimeMillis()));
            } else if (HistoryWindow.this.historyContact instanceof ChatRoomWrapper) {
                ChatRoomWrapper chatRoomWrapper = (ChatRoomWrapper)HistoryWindow.this.historyContact;
                if (chatRoomWrapper.getChatRoom() == null) {
                    return;
                }
                msgList = HistoryWindow.this.history.findByEndDate(HISTORY_FILTER, (Object)chatRoomWrapper.getChatRoom(), new Date(System.currentTimeMillis()));
            }
            if (msgList != null) {
                for (Object o : msgList) {
                    Date currDate;
                    Date date = new Date(0L);
                    if (o instanceof MessageDeliveredEvent) {
                        MessageDeliveredEvent evt = (MessageDeliveredEvent)o;
                        date = evt.getTimestamp();
                    } else if (o instanceof MessageReceivedEvent) {
                        MessageReceivedEvent evt = (MessageReceivedEvent)o;
                        date = evt.getTimestamp();
                    } else if (o instanceof ChatRoomMessageReceivedEvent) {
                        ChatRoomMessageReceivedEvent evt = (ChatRoomMessageReceivedEvent)o;
                        date = evt.getTimestamp();
                    } else if (o instanceof ChatRoomMessageDeliveredEvent) {
                        ChatRoomMessageDeliveredEvent evt = (ChatRoomMessageDeliveredEvent)o;
                        date = evt.getTimestamp();
                    } else if (o instanceof FileRecord) {
                        FileRecord fileRecord = (FileRecord)o;
                        date = fileRecord.getDate();
                    }
                    boolean containsDate = false;
                    Iterator iterator = HistoryWindow.this.datesDisplayed.iterator();
                    while (iterator.hasNext() && !(containsDate = GuiUtils.compareDatesOnly((Date)date, (Date)(currDate = (Date)iterator.next())) == 0)) {
                    }
                    if (containsDate) continue;
                    HistoryWindow.this.datesDisplayed.add(date);
                }
            }
            if (msgList != null && msgList.size() > 0) {
                Runnable updateDatesPanel = new Runnable(){

                    @Override
                    public void run() {
                        Date date = null;
                        Iterator iterator = HistoryWindow.this.datesDisplayed.iterator();
                        while (iterator.hasNext()) {
                            Date curr;
                            date = curr = (Date)iterator.next();
                            if (HistoryWindow.this.datesPanel.containsDate(date)) continue;
                            HistoryWindow.this.datesPanel.addDate(date);
                        }
                        if (date != null) {
                            HistoryWindow.this.ignoreProgressDate = date;
                        }
                        int lastDateIndex = HistoryWindow.this.datesPanel.getDatesNumber() - 1;
                        HistoryWindow.this.datesPanel.setSelected(lastDateIndex);
                    }
                };
                SwingUtilities.invokeLater(updateDatesPanel);
            }
        }
    }
}

