/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.jingle;

import net.java.sip.communicator.impl.protocol.jabber.extensions.CallIdPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.DefaultPacketExtensionProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CoinPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CryptoPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.DtlsFingerprintPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.EncryptionPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.GroupPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.InputEvtPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleAction;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.MuteSessionInfoPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ParameterPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RTPHdrExtPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RawUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ReasonPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ReasonProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RemoteCandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtcpFbPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtcpmuxPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SctpMapExtensionProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SessionInfoPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SessionInfoType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.TransferPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.TransferredPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ZrtpHashPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jitsimeet.BundlePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jitsimeet.SSRCInfoPacketExtension;
import net.java.sip.communicator.service.protocol.jabber.AbstractSmackInteroperabilityLayer;
import org.jivesoftware.smack.provider.IQProvider;
import org.xmlpull.v1.XmlPullParser;

public class JingleIQProvider
implements IQProvider {
    public JingleIQProvider() {
        AbstractSmackInteroperabilityLayer smackInteroperabilityLayer = AbstractSmackInteroperabilityLayer.getInstance();
        smackInteroperabilityLayer.addExtensionProvider("description", "urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<RtpDescriptionPacketExtension>(RtpDescriptionPacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("payload-type", "urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<PayloadTypePacketExtension>(PayloadTypePacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("parameter", "urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<ParameterPacketExtension>(ParameterPacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("rtp-hdrext", "urn:xmpp:jingle:apps:rtp:rtp-hdrext:0", new DefaultPacketExtensionProvider<RTPHdrExtPacketExtension>(RTPHdrExtPacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("sctpmap", "urn:xmpp:jingle:transports:dtls-sctp:1", (Object)new SctpMapExtensionProvider());
        smackInteroperabilityLayer.addExtensionProvider("encryption", "urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<EncryptionPacketExtension>(EncryptionPacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("zrtp-hash", "urn:xmpp:jingle:apps:rtp:zrtp:1", new DefaultPacketExtensionProvider<ZrtpHashPacketExtension>(ZrtpHashPacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("crypto", "urn:xmpp:jingle:apps:rtp:1", new DefaultPacketExtensionProvider<CryptoPacketExtension>(CryptoPacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("bundle", "http://estos.de/ns/bundle", new DefaultPacketExtensionProvider<BundlePacketExtension>(BundlePacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("group", "urn:xmpp:jingle:apps:grouping:0", new DefaultPacketExtensionProvider<GroupPacketExtension>(GroupPacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("transport", "urn:xmpp:jingle:transports:ice-udp:1", new DefaultPacketExtensionProvider<IceUdpTransportPacketExtension>(IceUdpTransportPacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("transport", "urn:xmpp:jingle:transports:raw-udp:1", new DefaultPacketExtensionProvider<RawUdpTransportPacketExtension>(RawUdpTransportPacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("candidate", "urn:xmpp:jingle:transports:ice-udp:1", new DefaultPacketExtensionProvider<CandidatePacketExtension>(CandidatePacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("candidate", "urn:xmpp:jingle:transports:raw-udp:1", new DefaultPacketExtensionProvider<CandidatePacketExtension>(CandidatePacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("remote-candidate", "urn:xmpp:jingle:transports:ice-udp:1", new DefaultPacketExtensionProvider<RemoteCandidatePacketExtension>(RemoteCandidatePacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("inputevt", "http://jitsi.org/protocol/inputevt", new DefaultPacketExtensionProvider<InputEvtPacketExtension>(InputEvtPacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("conference-info", "", new DefaultPacketExtensionProvider<CoinPacketExtension>(CoinPacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("fingerprint", "urn:xmpp:jingle:apps:dtls:0", new DefaultPacketExtensionProvider<DtlsFingerprintPacketExtension>(DtlsFingerprintPacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("transfer", "urn:xmpp:jingle:transfer:0", new DefaultPacketExtensionProvider<TransferPacketExtension>(TransferPacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("transferred", "urn:xmpp:jingle:transfer:0", new DefaultPacketExtensionProvider<TransferredPacketExtension>(TransferredPacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("callid", "http://jitsi.org/protocol/condesc", new DefaultPacketExtensionProvider<CallIdPacketExtension>(CallIdPacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("rtcp-fb", "urn:xmpp:jingle:apps:rtp:rtcp-fb:0", new DefaultPacketExtensionProvider<RtcpFbPacketExtension>(RtcpFbPacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("rtcp-mux", "urn:xmpp:jingle:transports:ice-udp:1", new DefaultPacketExtensionProvider<RtcpmuxPacketExtension>(RtcpmuxPacketExtension.class));
        smackInteroperabilityLayer.addExtensionProvider("ssrc-info", "http://jitsi.org/jitmeet", new DefaultPacketExtensionProvider<SSRCInfoPacketExtension>(SSRCInfoPacketExtension.class));
    }

    public JingleIQ parseIQ(XmlPullParser parser) throws Exception {
        JingleIQ jingleIQ = new JingleIQ();
        JingleAction action = JingleAction.parseString(parser.getAttributeValue("", "action"));
        String initiator = parser.getAttributeValue("", "initiator");
        String responder = parser.getAttributeValue("", "responder");
        String sid = parser.getAttributeValue("", "sid");
        jingleIQ.setAction(action);
        jingleIQ.setInitiator(initiator);
        jingleIQ.setResponder(responder);
        jingleIQ.setSID(sid);
        boolean done = false;
        DefaultPacketExtensionProvider<ContentPacketExtension> contentProvider = new DefaultPacketExtensionProvider<ContentPacketExtension>(ContentPacketExtension.class);
        ReasonProvider reasonProvider = new ReasonProvider();
        DefaultPacketExtensionProvider<TransferPacketExtension> transferProvider = new DefaultPacketExtensionProvider<TransferPacketExtension>(TransferPacketExtension.class);
        DefaultPacketExtensionProvider<CoinPacketExtension> coinProvider = new DefaultPacketExtensionProvider<CoinPacketExtension>(CoinPacketExtension.class);
        DefaultPacketExtensionProvider<CallIdPacketExtension> callidProvider = new DefaultPacketExtensionProvider<CallIdPacketExtension>(CallIdPacketExtension.class);
        while (!done) {
            int eventType = parser.next();
            String elementName = parser.getName();
            String namespace = parser.getNamespace();
            if (eventType == 2) {
                if (elementName.equals("content")) {
                    ContentPacketExtension content = (ContentPacketExtension)contentProvider.parseExtension(parser);
                    jingleIQ.addContent(content);
                } else if (elementName.equals("reason")) {
                    ReasonPacketExtension reason = reasonProvider.parseExtension(parser);
                    jingleIQ.setReason(reason);
                } else if (elementName.equals("transfer") && namespace.equals("urn:xmpp:jingle:transfer:0")) {
                    jingleIQ.addExtension(transferProvider.parseExtension(parser));
                } else if (elementName.equals("conference-info")) {
                    jingleIQ.addExtension(coinProvider.parseExtension(parser));
                } else if (elementName.equals("callid")) {
                    jingleIQ.addExtension(callidProvider.parseExtension(parser));
                }
                if (namespace.equals("urn:xmpp:jingle:apps:rtp:info:1")) {
                    SessionInfoType type = SessionInfoType.valueOf(elementName);
                    if (type == SessionInfoType.mute || type == SessionInfoType.unmute) {
                        String name = parser.getAttributeValue("", "name");
                        jingleIQ.setSessionInfo(new MuteSessionInfoPacketExtension(type == SessionInfoType.mute, name));
                    } else {
                        jingleIQ.setSessionInfo(new SessionInfoPacketExtension(type));
                    }
                }
            }
            if (eventType != 3 || !parser.getName().equals("jingle")) continue;
            done = true;
        }
        return jingleIQ;
    }
}

