/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import org.jitsi.impl.neomedia.RTCPFeedbackMessagePacket;
import org.jitsi.impl.neomedia.rtcp.RTCPFBPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPHeaderUtils;
import org.jitsi.service.neomedia.ByteArrayBuffer;

public class RTCPREMBPacket
extends RTCPFBPacket {
    public static final int FMT = 15;
    public int exp;
    public int mantissa;
    public long[] dest;

    public RTCPREMBPacket(long senderSSRC, long mediaSSRC, int exp, int mantissa, long[] dest) {
        super(15, 206, senderSSRC, mediaSSRC);
        this.exp = exp;
        this.mantissa = mantissa;
        this.dest = dest;
    }

    public RTCPREMBPacket(long senderSSRC, long mediaSSRC, long bitrate, long[] dest) {
        super(15, 206, senderSSRC, mediaSSRC);
        this.exp = 0;
        for (int i = 0; i < 64; ++i) {
            if (bitrate > (long)(262143 << i)) continue;
            this.exp = i;
            break;
        }
        this.mantissa = (int)bitrate >> this.exp;
        this.dest = dest;
    }

    public RTCPREMBPacket(RTCPCompoundPacket base) {
        super(base);
        this.fmt = 15;
        this.type = 206;
    }

    public long[] getDest() {
        return this.dest;
    }

    public void setDest(long[] dest) {
        this.dest = dest;
    }

    @Override
    public void assemble(DataOutputStream dataoutputstream) throws IOException {
        int len = this.calcLength();
        byte[] buf = new byte[len];
        int off = 0;
        buf[off++] = -113;
        buf[off++] = -50;
        int rtcpPacketLength = len / 4 - 1;
        buf[off++] = (byte)((rtcpPacketLength & 0xFF00) >> 8);
        buf[off++] = (byte)(rtcpPacketLength & 0xFF);
        RTCPFeedbackMessagePacket.writeSSRC(this.senderSSRC, buf, off);
        RTCPFeedbackMessagePacket.writeSSRC(0L, buf, off += 4);
        off += 4;
        buf[off++] = 82;
        buf[off++] = 69;
        buf[off++] = 77;
        buf[off++] = 66;
        buf[off++] = (byte)(this.dest != null && this.dest.length != 0 ? this.dest.length : 0);
        buf[off++] = (byte)((this.exp & 0x3F) << 2 | (this.mantissa & 0x30000) >> 16);
        buf[off++] = (byte)((this.mantissa & 0xFF00) >> 8);
        buf[off++] = (byte)(this.mantissa & 0xFF);
        if (this.dest != null && this.dest.length != 0) {
            for (long d : this.dest) {
                RTCPFeedbackMessagePacket.writeSSRC(d, buf, off);
                off += 4;
            }
        }
        dataoutputstream.write(buf, 0, len);
    }

    @Override
    public int calcLength() {
        int len = 20;
        if (this.dest != null) {
            len += this.dest.length * 4;
        }
        return len;
    }

    @Override
    public String toString() {
        return "\tRTCP REMB packet from sync source " + this.senderSSRC + "\n\t\tfor sync sources: " + Arrays.toString(this.dest) + "\n\t\tBR Exp: " + this.exp + "\n\t\tBR Mantissa: " + this.mantissa;
    }

    public long getBitrate() {
        return (long)((double)this.mantissa * Math.pow(2.0, this.exp));
    }

    public static boolean isREMBPacket(ByteArrayBuffer baf) {
        int rc = RTCPHeaderUtils.getReportCount(baf);
        return RTCPREMBPacket.isPSFBPacket(baf) && rc == 15;
    }
}

