/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp;

import net.sf.fmj.media.rtp.RTCPSRPacket;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.rtp.FrameDesc;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackDesc;
import org.jitsi.impl.neomedia.rtp.RTCPPacketListenerAdapter;
import org.jitsi.impl.neomedia.rtp.RTPEncodingDesc;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.ByteArrayBuffer;
import org.jitsi.util.ArrayUtils;

public class MediaStreamTrackReceiver
extends RTCPPacketListenerAdapter
implements TransformEngine,
PacketTransformer {
    private final MediaStreamImpl stream;
    private MediaStreamTrackDesc[] tracks;

    public MediaStreamTrackReceiver(MediaStreamImpl stream) {
        this.stream = stream;
        this.stream.getMediaStreamStats().addRTCPPacketListener(this);
    }

    public FrameDesc findFrameDesc(ByteArrayBuffer buf) {
        if (buf == null) {
            return null;
        }
        return this.findFrameDesc(buf.getBuffer(), buf.getOffset(), buf.getLength());
    }

    public FrameDesc findFrameDesc(byte[] buf, int off, int len) {
        RTPEncodingDesc rtpEncoding = this.findRTPEncodingDesc(buf, off, len);
        if (rtpEncoding == null) {
            return null;
        }
        return rtpEncoding.findFrameDesc(buf, off, len);
    }

    public RTPEncodingDesc findRTPEncodingDesc(ByteArrayBuffer buf) {
        if (buf == null) {
            return null;
        }
        return this.findRTPEncodingDesc(buf.getBuffer(), buf.getOffset(), buf.getLength());
    }

    public RTPEncodingDesc findRTPEncodingDesc(byte[] buf, int off, int len) {
        MediaStreamTrackDesc[] localTracks = this.tracks;
        if (ArrayUtils.isNullOrEmpty(localTracks)) {
            return null;
        }
        for (MediaStreamTrackDesc track : localTracks) {
            RTPEncodingDesc encoding = track.findRTPEncodingDesc(buf, off, len);
            if (encoding == null) continue;
            return encoding;
        }
        return null;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    @Override
    public void srReceived(RTCPSRPacket srPacket) {
        MediaStreamTrackDesc track = this.findMediaStreamTrackDesc((long)srPacket.ssrc & 0xFFFFFFFFL);
        if (track != null) {
            track.srReceived(srPacket);
        }
    }

    @Override
    public void close() {
        this.stream.getMediaStreamStats().removeRTCPPacketListener(this);
    }

    public MediaStreamTrackDesc[] getMediaStreamTracks() {
        return this.tracks;
    }

    public boolean setMediaStreamTracks(MediaStreamTrackDesc[] newTracks) {
        int newTracksLen;
        MediaStreamTrackDesc[] oldTracks = this.tracks;
        int oldTracksLen = oldTracks == null ? 0 : oldTracks.length;
        int n = newTracksLen = newTracks == null ? 0 : newTracks.length;
        if (oldTracksLen == 0 || newTracksLen == 0) {
            this.tracks = newTracks;
            return oldTracksLen != newTracksLen;
        }
        int cntMatched = 0;
        MediaStreamTrackDesc[] mergedTracks = new MediaStreamTrackDesc[newTracks.length];
        for (int i = 0; i < newTracks.length; ++i) {
            RTPEncodingDesc newEncoding = newTracks[i].getRTPEncodings()[0];
            int j = 0;
            while (i < oldTracks.length) {
                if (oldTracks[j] != null && oldTracks[j].matches(newEncoding.getPrimarySSRC())) {
                    mergedTracks[i] = oldTracks[j];
                    ++cntMatched;
                    break;
                }
                ++j;
            }
            if (mergedTracks[i] != null) continue;
            mergedTracks[i] = newTracks[i];
        }
        this.tracks = mergedTracks;
        return oldTracksLen != newTracksLen || cntMatched != oldTracks.length;
    }

    public MediaStreamImpl getStream() {
        return this.stream;
    }

    public MediaStreamTrackDesc findMediaStreamTrackDesc(long ssrc) {
        MediaStreamTrackDesc[] localTracks = this.tracks;
        if (ArrayUtils.isNullOrEmpty(localTracks)) {
            return null;
        }
        for (MediaStreamTrackDesc track : localTracks) {
            if (!track.matches(ssrc)) continue;
            return track;
        }
        return null;
    }

    @Override
    public RawPacket[] reverseTransform(RawPacket[] pkts) {
        RawPacket[] cumulExtras = null;
        for (int i = 0; i < pkts.length; ++i) {
            RawPacket[] extras;
            RTPEncodingDesc encoding;
            if (!RTPPacketPredicate.INSTANCE.test(pkts[i]) || (encoding = this.findRTPEncodingDesc(pkts[i])) == null || ArrayUtils.isNullOrEmpty(extras = encoding.getMediaStreamTrack().reverseTransform(pkts[i], encoding))) continue;
            cumulExtras = ArrayUtils.concat(cumulExtras, extras);
        }
        return ArrayUtils.concat(cumulExtras, pkts);
    }

    @Override
    public RawPacket[] transform(RawPacket[] pkts) {
        return pkts;
    }
}

