/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.stats;

import org.ice4j.util.RateStatistics;
import org.jitsi.impl.neomedia.stats.AbstractTrackStats;
import org.jitsi.service.neomedia.stats.SendTrackStats;
import org.jitsi.util.RTPUtils;

public class SendTrackStatsImpl
extends AbstractTrackStats
implements SendTrackStats {
    private int highestSeq = -1;
    RateStatistics packetsNotSentRate = new RateStatistics(1000, 1000.0f);
    private double fractionLost = -1.0;
    private long fractionLostLastUpdate = -1L;

    SendTrackStatsImpl(int interval, long ssrc) {
        super(interval, ssrc);
    }

    void rtpPacketSent(int seq, int length) {
        long now = System.currentTimeMillis();
        super.packetProcessed(length, now, true);
        if (this.highestSeq == -1) {
            this.highestSeq = seq;
            return;
        }
        int diff = RTPUtils.sequenceNumberDiff(seq, this.highestSeq);
        if (diff <= 0) {
            this.packetsNotSentRate.update(-1, now);
        } else {
            this.highestSeq = seq;
            if (diff > 1) {
                this.packetsNotSentRate.update(diff - 1, now);
            }
        }
    }

    @Override
    public double getLossRate() {
        long now = System.currentTimeMillis();
        if (this.fractionLostLastUpdate == -1L || now - this.fractionLostLastUpdate > 8000L) {
            return 0.0;
        }
        long packetsNotSent = this.packetsNotSentRate.getAccumulatedCount(now);
        long packetsSent = this.packetRate.getAccumulatedCount(now);
        double fractionNotSent = packetsSent + packetsNotSent > 0L ? (double)(packetsNotSent / (packetsNotSent + packetsSent)) : 0.0;
        return Math.max(0.0, this.fractionLost - fractionNotSent);
    }

    @Override
    public int getHighestSent() {
        return this.highestSeq;
    }

    void rtcpPacketSent(int length) {
        super.packetProcessed(length, System.currentTimeMillis(), false);
    }

    void rtcpReceiverReportReceived(int fractionLost) {
        this.fractionLost = (double)fractionLost / 256.0;
        this.fractionLostLastUpdate = System.currentTimeMillis();
    }
}

