/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.fec;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.fec.FECReceiver;
import org.jitsi.impl.neomedia.transform.fec.FECSender;
import org.jitsi.util.Logger;

public class FECTransformEngine
implements TransformEngine,
PacketTransformer {
    private static final Logger logger = Logger.getLogger(FECTransformEngine.class);
    public static final int INITIAL_BUFFER_SIZE = 1500;
    private byte incomingPT = (byte)-1;
    private byte outgoingPT = (byte)-1;
    private int fecRate = 0;
    private final Map<Long, FECReceiver> fecReceivers = new HashMap<Long, FECReceiver>();
    private final Map<Long, FECSender> fecSenders = new HashMap<Long, FECSender>();

    public FECTransformEngine(byte incomingPT, byte outgoingPT) {
        this.setIncomingPT(incomingPT);
        this.setOutgoingPT(outgoingPT);
    }

    public FECTransformEngine() {
        this(-1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawPacket[] reverseTransform(RawPacket[] pkts) {
        FECReceiver fpt;
        if (this.incomingPT == -1 || pkts == null) {
            return pkts;
        }
        Long ssrc = this.findSSRC(pkts);
        if (ssrc == null) {
            return pkts;
        }
        Map<Long, FECReceiver> map = this.fecReceivers;
        synchronized (map) {
            fpt = this.fecReceivers.get(ssrc);
            if (fpt == null) {
                fpt = new FECReceiver(ssrc, this.incomingPT);
                this.fecReceivers.put(ssrc, fpt);
            }
        }
        return fpt.reverseTransform(pkts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawPacket[] transform(RawPacket[] pkts) {
        FECSender fpt;
        if (this.outgoingPT == -1 || pkts == null) {
            return pkts;
        }
        Long ssrc = this.findSSRC(pkts);
        if (ssrc == null) {
            return pkts;
        }
        Map<Long, FECSender> map = this.fecSenders;
        synchronized (map) {
            fpt = this.fecSenders.get(ssrc);
            if (fpt == null) {
                fpt = new FECSender(ssrc, this.fecRate, this.outgoingPT);
                this.fecSenders.put(ssrc, fpt);
            }
        }
        return fpt.transform(pkts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Collection<FECSender> senders;
        Collection<FECReceiver> receivers;
        Iterator<FECSender> iterator = this.fecReceivers;
        synchronized (iterator) {
            receivers = this.fecReceivers.values();
            this.fecReceivers.clear();
        }
        iterator = this.fecSenders;
        synchronized (iterator) {
            senders = this.fecSenders.values();
            this.fecSenders.clear();
        }
        for (FECReceiver fecReceiver : receivers) {
            fecReceiver.close();
        }
        for (FECSender fecSender : senders) {
            fecSender.close();
        }
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIncomingPT(byte incomingPT) {
        this.incomingPT = incomingPT;
        Map<Long, FECReceiver> map = this.fecReceivers;
        synchronized (map) {
            for (FECReceiver f : this.fecReceivers.values()) {
                f.setUlpfecPT(incomingPT);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Setting payload type for incoming ulpfec: " + incomingPT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutgoingPT(byte outgoingPT) {
        this.outgoingPT = outgoingPT;
        Map<Long, FECSender> map = this.fecSenders;
        synchronized (map) {
            for (FECSender f : this.fecSenders.values()) {
                f.setUlpfecPT(outgoingPT);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Setting payload type for outgoing ulpfec: " + outgoingPT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFecRate(int fecRate) {
        Map<Long, FECSender> map = this.fecSenders;
        synchronized (map) {
            for (FECSender f : this.fecSenders.values()) {
                f.setFecRate(fecRate);
            }
        }
        this.fecRate = fecRate;
    }

    public int getFecRate() {
        return this.fecRate;
    }

    private Long findSSRC(RawPacket[] pkts) {
        Long ret = null;
        if (pkts != null) {
            for (RawPacket p : pkts) {
                if (p == null) continue;
                ret = p.getSSRCAsLong();
                break;
            }
        }
        return ret;
    }
}

