/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.listeners;

import com.ircclouds.irc.api.Callback;
import com.ircclouds.irc.api.IRCException;
import com.ircclouds.irc.api.domain.messages.ChannelKick;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import java.util.HashMap;
import java.util.Map;

public abstract class KickUserListener {
    private Map<String, Callback<String>> callbacks = new HashMap<String, Callback<String>>();

    public void onChannelKick(ChannelKick aChanKick) {
        if (this.callbacks.containsKey(aChanKick)) {
            this.callbacks.get(aChanKick).onSuccess("");
            this.delChanUser(aChanKick.getChannelName(), aChanKick.getKickedNickname());
        }
    }

    public void onServerMessage(ServerNumericMessage aServerMessage) {
        String _chan;
        if ((aServerMessage.getNumericCode() == 403 || aServerMessage.getNumericCode() == 482) && this.callbacks.containsKey(_chan = aServerMessage.getText().split(" ")[0])) {
            this.callbacks.remove(_chan).onFailure(new IRCException(aServerMessage.getText()));
        }
    }

    public void submit(String aChannel, Callback<String> aCallback) {
        this.callbacks.put(aChannel, aCallback);
    }

    protected abstract void delChanUser(String var1, String var2);
}

