/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.defaultresourcepack;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import net.java.sip.communicator.plugin.defaultresourcepack.DefaultResourcePackActivator;
import net.java.sip.communicator.service.resources.LanguagePack;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;

public class DefaultLanguagePackImpl
implements LanguagePack {
    private static final String DEFAULT_RESOURCE_PATH = "resources.languages.resources";
    private Locale localeInBuffer = null;
    private Map<String, String> lastResourcesAsked = null;
    private Vector<Locale> availableLocales = new Vector();

    public DefaultLanguagePackImpl() {
        Enumeration fsEnum = DefaultResourcePackActivator.bundleContext.getBundle().findEntries("/resources/languages", "*.properties", false);
        if (fsEnum != null) {
            while (fsEnum.hasMoreElements()) {
                String fileName = ((URL)fsEnum.nextElement()).getFile();
                int localeIndex = fileName.indexOf(95);
                if (localeIndex == -1) continue;
                String localeId = fileName.substring(localeIndex + 1, fileName.indexOf(46, localeIndex));
                this.availableLocales.add(ResourceManagementServiceUtils.getLocale((String)localeId));
            }
        }
    }

    public Map<String, String> getResources() {
        return this.getResources(Locale.getDefault());
    }

    public Map<String, String> getResources(Locale locale) {
        if (locale.equals(this.localeInBuffer) && this.lastResourcesAsked != null) {
            return this.lastResourcesAsked;
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(DEFAULT_RESOURCE_PATH, locale, new ResourceBundle.Control(){

            @Override
            public String toBundleName(String baseName, Locale locale) {
                if (locale.equals(new Locale("he"))) {
                    return baseName + "_he";
                }
                if (locale.equals(new Locale("yi"))) {
                    return baseName + "_yi";
                }
                if (locale.equals(new Locale("id"))) {
                    return baseName + "_id";
                }
                return super.toBundleName(baseName, locale);
            }
        });
        Hashtable<String, String> resources = new Hashtable<String, String>();
        this.initResources(resourceBundle, resources);
        this.initPluginResources(resources, locale);
        this.localeInBuffer = locale;
        this.lastResourcesAsked = resources;
        return resources;
    }

    public Set<String> getResourceKeys(Locale locale) {
        try {
            Method handleKeySet = ResourceBundle.class.getDeclaredMethod("handleKeySet", new Class[0]);
            handleKeySet.setAccessible(true);
            return (Set)handleKeySet.invoke((Object)ResourceBundle.getBundle(DEFAULT_RESOURCE_PATH, locale), new Object[0]);
        }
        catch (Exception exception) {
            return new HashSet<String>();
        }
    }

    public String getName() {
        return "Default Language Resources";
    }

    public String getDescription() {
        return "Provide Jitsi default Language resource pack.";
    }

    private void initResources(ResourceBundle resourceBundle, Map<String, String> resources) {
        Enumeration<String> colorKeys = resourceBundle.getKeys();
        while (colorKeys.hasMoreElements()) {
            String key = colorKeys.nextElement();
            String value = resourceBundle.getString(key);
            resources.put(key, value);
        }
    }

    private void initPluginResources(Map<String, String> resources, Locale locale) {
        Iterator<String> pluginProperties = DefaultResourcePackActivator.findResourcePaths("resources/languages", "strings-*.properties");
        while (pluginProperties.hasNext()) {
            String resourceBundleName = pluginProperties.next();
            if (resourceBundleName.indexOf(95) != -1) continue;
            ResourceBundle resourceBundle = ResourceBundle.getBundle(resourceBundleName.substring(0, resourceBundleName.indexOf(".properties")), locale);
            this.initResources(resourceBundle, resources);
        }
    }

    public Iterator<Locale> getAvailableLocales() {
        return this.availableLocales.iterator();
    }
}

