/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public abstract class AbstractCall<T extends CallPeer, U extends ProtocolProviderService>
extends Call {
    private List<T> callPeers;
    private final Object callPeersSyncRoot = new Object();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private List<T> unmodifiableCallPeers;

    protected AbstractCall(U sourceProvider) {
        super((ProtocolProviderService)sourceProvider);
        this.callPeers = Collections.emptyList();
        this.unmodifiableCallPeers = Collections.unmodifiableList(this.callPeers);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doAddCallPeer(T callPeer) {
        if (callPeer == null) {
            throw new NullPointerException("callPeer");
        }
        Object object = this.callPeersSyncRoot;
        synchronized (object) {
            if (this.callPeers.contains(callPeer)) {
                return false;
            }
            ArrayList<T> newCallPeers = new ArrayList<T>(this.callPeers);
            if (newCallPeers.add(callPeer)) {
                this.callPeers = newCallPeers;
                this.unmodifiableCallPeers = Collections.unmodifiableList(this.callPeers);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRemoveCallPeer(T callPeer) {
        Object object = this.callPeersSyncRoot;
        synchronized (object) {
            ArrayList<T> newCallPeers = new ArrayList<T>(this.callPeers);
            if (newCallPeers.remove(callPeer)) {
                this.callPeers = newCallPeers;
                this.unmodifiableCallPeers = Collections.unmodifiableList(this.callPeers);
                return true;
            }
            return false;
        }
    }

    @Override
    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(property, oldValue, newValue);
    }

    @Override
    public int getCallPeerCount() {
        return this.getCallPeerList().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getCallPeerList() {
        Object object = this.callPeersSyncRoot;
        synchronized (object) {
            return this.unmodifiableCallPeers;
        }
    }

    public Iterator<T> getCallPeers() {
        return this.getCallPeerList().iterator();
    }

    public U getProtocolProvider() {
        return (U)super.getProtocolProvider();
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

