/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.LowPriorityEventQueue;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.resources.ResourceManagementService;

public class SoundLevelIndicator
extends TransparentPanel
implements Skinnable {
    private static final long serialVersionUID = 0L;
    private static final String SOUND_LEVEL_ACTIVE_LEFT = "service.gui.soundlevel.SOUND_LEVEL_ACTIVE_LEFT";
    private static final String SOUND_LEVEL_ACTIVE_LEFT_GRADIENT = "service.gui.soundlevel.SOUND_LEVEL_ACTIVE_LEFT_GRADIENT";
    private static final String SOUND_LEVEL_ACTIVE_MIDDLE = "service.gui.soundlevel.SOUND_LEVEL_ACTIVE_MIDDLE";
    private static final String SOUND_LEVEL_ACTIVE_RIGHT = "service.gui.soundlevel.SOUND_LEVEL_ACTIVE_RIGHT";
    private static final String SOUND_LEVEL_ACTIVE_RIGHT_GRADIENT = "service.gui.soundlevel.SOUND_LEVEL_ACTIVE_RIGHT_GRADIENT";
    private static final String SOUND_LEVEL_INACTIVE_LEFT = "service.gui.soundlevel.SOUND_LEVEL_INACTIVE_LEFT";
    private static final String SOUND_LEVEL_INACTIVE_MIDDLE = "service.gui.soundlevel.SOUND_LEVEL_INACTIVE_MIDDLE";
    private static final String SOUND_LEVEL_INACTIVE_RIGHT = "service.gui.soundlevel.SOUND_LEVEL_INACTIVE_RIGHT";
    private final LevelUpdate levelUpdate = new LevelUpdate();
    private Runnable levelUpdateScheduler;
    private final int maxSoundLevel;
    private final int minSoundLevel;
    private int soundBarCount;
    private int soundLevel;
    private ImageIcon soundLevelActiveImageLeft;
    private ImageIcon soundLevelActiveImageLeftGradient;
    private ImageIcon soundLevelActiveImageMiddle;
    private ImageIcon soundLevelActiveImageRight;
    private ImageIcon soundLevelActiveImageRightGradient;
    private ImageIcon soundLevelInactiveImageLeft;
    private ImageIcon soundLevelInactiveImageMiddle;
    private ImageIcon soundLevelInactiveImageRight;

    public SoundLevelIndicator(int minSoundLevel, int maxSoundLevel) {
        this.minSoundLevel = minSoundLevel;
        this.maxSoundLevel = maxSoundLevel;
        this.soundLevel = minSoundLevel;
        this.loadSkin();
        this.setLayout(new BoxLayout((Container)((Object)this), 0));
    }

    private int getSoundBarCount(int width) {
        int soundBarWidth = this.soundLevelActiveImageLeft.getIconWidth();
        return width / soundBarWidth;
    }

    public void loadSkin() {
        ResourceManagementService resources = DesktopUtilActivator.getResources();
        this.soundLevelActiveImageLeft = resources.getImage(SOUND_LEVEL_ACTIVE_LEFT);
        this.soundLevelActiveImageLeftGradient = resources.getImage(SOUND_LEVEL_ACTIVE_LEFT_GRADIENT);
        this.soundLevelActiveImageMiddle = resources.getImage(SOUND_LEVEL_ACTIVE_MIDDLE);
        this.soundLevelActiveImageRight = resources.getImage(SOUND_LEVEL_ACTIVE_RIGHT);
        this.soundLevelActiveImageRightGradient = resources.getImage(SOUND_LEVEL_ACTIVE_RIGHT_GRADIENT);
        this.soundLevelInactiveImageLeft = resources.getImage(SOUND_LEVEL_INACTIVE_LEFT);
        this.soundLevelInactiveImageMiddle = resources.getImage(SOUND_LEVEL_INACTIVE_MIDDLE);
        this.soundLevelInactiveImageRight = resources.getImage(SOUND_LEVEL_INACTIVE_RIGHT);
        if (!this.isPreferredSizeSet()) {
            int width;
            int height;
            int preferredHeight = 0;
            int preferredWidth = 0;
            if (this.soundLevelActiveImageLeft != null) {
                height = this.soundLevelActiveImageLeft.getIconHeight();
                width = this.soundLevelActiveImageLeft.getIconWidth();
                if (preferredHeight < height) {
                    preferredHeight = height;
                }
                if (preferredWidth < width) {
                    preferredWidth = width;
                }
            }
            if (this.soundLevelInactiveImageLeft != null) {
                height = this.soundLevelInactiveImageLeft.getIconHeight();
                width = this.soundLevelInactiveImageLeft.getIconWidth();
                if (preferredHeight < height) {
                    preferredHeight = height;
                }
                if (preferredWidth < width) {
                    preferredWidth = width;
                }
            }
            if (preferredHeight > 0 && preferredWidth > 0) {
                this.setPreferredSize(new Dimension(10 * preferredWidth, preferredHeight));
            }
        }
        this.updateSoundLevel(this.soundLevel);
    }

    public void resetSoundLevel() {
        this.soundLevel = this.minSoundLevel;
        this.updateSoundLevel(this.minSoundLevel);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        int newSoundBarCount = this.getSoundBarCount(this.getWidth());
        if (newSoundBarCount > 0) {
            block0: while (newSoundBarCount < this.soundBarCount) {
                for (int i = this.getComponentCount() - 1; i >= 0; --i) {
                    Component c = this.getComponent(i);
                    if (!(c instanceof JLabel)) continue;
                    this.remove(c);
                    --this.soundBarCount;
                    continue block0;
                }
            }
            while (this.soundBarCount < newSoundBarCount) {
                JLabel soundBar = this.soundBarCount == 0 ? new JLabel(this.soundLevelInactiveImageLeft) : (this.soundBarCount == newSoundBarCount - 1 ? new JLabel(this.soundLevelInactiveImageRight) : new JLabel(this.soundLevelInactiveImageMiddle));
                soundBar.setVerticalAlignment(0);
                this.add(soundBar);
                ++this.soundBarCount;
            }
        }
        this.updateSoundLevel(this.soundLevel);
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSoundLevel(int soundLevel) {
        Runnable levelUpdateScheduler;
        this.levelUpdate.setSoundLevel(soundLevel);
        SoundLevelIndicator soundLevelIndicator = this;
        synchronized (soundLevelIndicator) {
            if (this.levelUpdateScheduler == null) {
                this.levelUpdateScheduler = LowPriorityEventQueue.createRepetitiveInvokeLater(this.levelUpdate);
            }
            levelUpdateScheduler = this.levelUpdateScheduler;
        }
        levelUpdateScheduler.run();
    }

    private void updateSoundLevelInternal(int soundLevel) {
        int range = 1;
        if (this.minSoundLevel > -1 && this.maxSoundLevel > -1 && this.minSoundLevel < this.maxSoundLevel) {
            range = this.maxSoundLevel - this.minSoundLevel;
            if (soundLevel < 40) {
                soundLevel = this.minSoundLevel;
            } else if (soundLevel > 85) {
                soundLevel = this.maxSoundLevel;
            } else if ((soundLevel = (int)(((double)soundLevel - 40.0) / 45.0 * (double)range)) < this.minSoundLevel) {
                soundLevel = this.minSoundLevel;
            } else if (soundLevel > this.maxSoundLevel) {
                soundLevel = this.maxSoundLevel;
            }
        }
        this.soundLevel = (int)((double)this.soundLevel * 0.8 + (double)soundLevel * 0.2);
        int activeSoundBarCount = Math.round((float)(this.soundLevel * this.soundBarCount) / (float)range);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component c = this.getComponent(i);
            if (!(c instanceof JLabel)) continue;
            ImageIcon activeIcon = null;
            ImageIcon inactiveIcon = null;
            if (i == 0) {
                if (activeSoundBarCount == 1) {
                    activeIcon = this.soundLevelActiveImageLeftGradient;
                } else {
                    activeIcon = this.soundLevelActiveImageLeft;
                    inactiveIcon = this.soundLevelInactiveImageLeft;
                }
            } else if (i == activeSoundBarCount - 1) {
                activeIcon = i == components.length - 1 ? this.soundLevelActiveImageRight : this.soundLevelActiveImageRightGradient;
            } else if (i == components.length - 1) {
                inactiveIcon = this.soundLevelInactiveImageRight;
            } else {
                activeIcon = this.soundLevelActiveImageMiddle;
                inactiveIcon = this.soundLevelInactiveImageMiddle;
            }
            ((JLabel)c).setIcon(i < activeSoundBarCount ? activeIcon : inactiveIcon);
        }
        this.repaint();
    }

    private class LevelUpdate
    implements Runnable {
        private int soundLevel;

        private LevelUpdate() {
        }

        @Override
        public void run() {
            SoundLevelIndicator.this.updateSoundLevelInternal(this.soundLevel);
        }

        public void setSoundLevel(int soundLevel) {
            this.soundLevel = soundLevel;
        }
    }
}

