/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.animation;

import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.GlobalFadeTrackerCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FadeConfigurationManager {
    private static FadeConfigurationManager instance;
    private Set<FadeKind> globalAllowed = new HashSet<FadeKind>();
    private Map<FadeKind, Set<Class<?>>> classAllowed = new HashMap();
    private Map<FadeKind, Set<Class<?>>> classDisallowed = new HashMap();
    private Map<FadeKind, Set<Component>> instanceAllowed = new HashMap<FadeKind, Set<Component>>();
    private Map<FadeKind, Set<Component>> instanceDisallowed = new HashMap<FadeKind, Set<Component>>();

    public static synchronized FadeConfigurationManager getInstance() {
        if (instance == null) {
            instance = new FadeConfigurationManager();
        }
        return instance;
    }

    private FadeConfigurationManager() {
    }

    public synchronized void allowFades(FadeKind fadeKind) {
        this.globalAllowed.add(fadeKind);
    }

    public synchronized void allowFades(FadeKind fadeKind, Class<?> clazz) {
        Set<Class<?>> existingAllowed = this.classAllowed.get(fadeKind);
        if (existingAllowed == null) {
            existingAllowed = new HashSet();
            this.classAllowed.put(fadeKind, existingAllowed);
        }
        existingAllowed.add(clazz);
        Set<Class<?>> existingDisallowed = this.classDisallowed.get(fadeKind);
        if (existingDisallowed != null) {
            existingDisallowed.remove(clazz);
        }
    }

    public synchronized void allowFades(FadeKind fadeKind, Class<?>[] clazz) {
        for (int i = 0; i < clazz.length; ++i) {
            this.allowFades(fadeKind, clazz[i]);
        }
    }

    public synchronized void allowFades(FadeKind fadeKind, Component comp) {
        Set<Component> existingAllowed = this.instanceAllowed.get(fadeKind);
        if (existingAllowed == null) {
            existingAllowed = new HashSet<Component>();
            this.instanceAllowed.put(fadeKind, existingAllowed);
        }
        existingAllowed.add(comp);
        Set<Component> existingDisallowed = this.instanceDisallowed.get(fadeKind);
        if (existingDisallowed != null) {
            existingDisallowed.remove(comp);
        }
    }

    public synchronized void disallowFades(FadeKind fadeKind) {
        this.globalAllowed.remove(fadeKind);
    }

    public synchronized void disallowFades(FadeKind fadeKind, Class<?> clazz) {
        Set<Class<?>> existingDisallowed;
        Set<Class<?>> existingAllowed = this.classAllowed.get(fadeKind);
        if (existingAllowed != null) {
            existingAllowed.remove(clazz);
            if (existingAllowed.size() == 0) {
                this.classAllowed.remove(fadeKind);
            }
        }
        if ((existingDisallowed = this.classDisallowed.get(fadeKind)) == null) {
            existingDisallowed = new HashSet();
            this.classDisallowed.put(fadeKind, existingDisallowed);
        }
        existingDisallowed.add(clazz);
    }

    public synchronized void disallowFades(FadeKind fadeKind, Class<?>[] clazz) {
        for (int i = 0; i < clazz.length; ++i) {
            this.disallowFades(fadeKind, clazz[i]);
        }
    }

    public synchronized void disallowFades(FadeKind fadeKind, Component comp) {
        Set<Component> existingDisallowed;
        Set<Component> existingAllowed = this.instanceAllowed.get(fadeKind);
        if (existingAllowed != null) {
            existingAllowed.remove(comp);
            if (existingAllowed.size() == 0) {
                this.instanceAllowed.remove(fadeKind);
            }
        }
        if ((existingDisallowed = this.instanceDisallowed.get(fadeKind)) == null) {
            existingDisallowed = new HashSet<Component>();
            this.instanceDisallowed.put(fadeKind, existingDisallowed);
        }
        existingDisallowed.add(comp);
    }

    public synchronized boolean fadeAllowed(FadeKind fadeKind, Component comp) {
        Set<Component> instanceDisallowed = this.instanceDisallowed.get(fadeKind);
        if (instanceDisallowed != null && instanceDisallowed.contains(comp)) {
            return false;
        }
        Set<Component> instanceAllowed = this.instanceAllowed.get(fadeKind);
        if (instanceAllowed != null && instanceAllowed.contains(comp)) {
            return true;
        }
        if (comp != null) {
            Class<?> clazz = comp.getClass();
            Set<Class<?>> classAllowed = this.classAllowed.get(fadeKind);
            Set<Class<?>> classDisallowed = this.classDisallowed.get(fadeKind);
            if (classDisallowed != null) {
                for (Class<?> disallowed : classDisallowed) {
                    if (!disallowed.isAssignableFrom(clazz)) continue;
                    return false;
                }
            }
            if (classAllowed != null) {
                for (Class<?> allowed : classAllowed) {
                    if (!allowed.isAssignableFrom(clazz)) continue;
                    return true;
                }
            }
        }
        return this.globalAllowed.contains(fadeKind);
    }

    public static void addGlobalFadeTrackerCallback(GlobalFadeTrackerCallback callback) {
        FadeTracker.getInstance().addGlobalCallback(callback);
    }

    public static void removeGlobalFadeTrackerCallback(GlobalFadeTrackerCallback callback) {
        FadeTracker.getInstance().removeGlobalCallback(callback);
    }
}

