/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.igniterealtime.jbosh.AbstractBody;
import org.igniterealtime.jbosh.BOSHClient;
import org.igniterealtime.jbosh.BOSHClientConfig;
import org.igniterealtime.jbosh.BOSHClientConnEvent;
import org.igniterealtime.jbosh.BOSHClientConnListener;
import org.igniterealtime.jbosh.BOSHClientResponseListener;
import org.igniterealtime.jbosh.BOSHException;
import org.igniterealtime.jbosh.BOSHMessageEvent;
import org.igniterealtime.jbosh.BodyQName;
import org.igniterealtime.jbosh.ComposableBody;
import org.jivesoftware.smack.AbstractConnection;
import org.jivesoftware.smack.BOSHConfiguration;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.PacketReader;
import org.jivesoftware.smack.PacketWriter;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Presence;

public class XMPPBOSHConnection
extends AbstractConnection {
    private static final Logger LOGGER = Logger.getLogger(XMPPBOSHConnection.class.getName());
    public static final String XMPP_BOSH_NS = "urn:xmpp:xbosh";
    public static final String BOSH_URI = "http://jabber.org/protocol/httpbind";
    public static final String BOSH_STREAM_ROOT = "boshstream";
    private BOSHClient client;
    private PipedWriter readerPipe;
    protected String sessionID = null;

    public XMPPBOSHConnection(BOSHConfiguration config) {
        super(config);
    }

    @Override
    protected void connectUsingConfiguration(ConnectionConfiguration c) throws XMPPException {
        BOSHConfiguration config = (BOSHConfiguration)c;
        try {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
            this.sessionID = null;
            BOSHClientConfig.Builder cfgBuilder = BOSHClientConfig.Builder.create(config.getURI(), config.getServiceName());
            if (config.isProxyEnabled()) {
                cfgBuilder.setProxy(config.getProxyAddress(), config.getProxyPort());
            }
            this.client = BOSHClient.create(cfgBuilder.build());
            this.client.addBOSHClientConnListener(new BOSHConnectionListener());
            this.client.addBOSHClientResponseListener(new BOSHPacketReader());
        }
        catch (URISyntaxException e) {
            throw new XMPPException(e);
        }
    }

    @Override
    protected void initConnectionFailed(XMPPException ex) {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    protected void initReaderAndWriter() throws XMPPException {
        this.writer = new BOSHWriter();
        try {
            this.readerPipe = new PipedWriter();
            this.reader = new PipedReader(this.readerPipe);
            this.readerPipe.write("<boshstream>");
        }
        catch (IOException e) {
            throw new XMPPException(e);
        }
        super.initReaderAndWriter();
    }

    @Override
    protected PacketReader createPacketReader() {
        return new PacketReader(this, BOSH_STREAM_ROOT);
    }

    @Override
    protected PacketWriter createPacketWriter() {
        return new BOSHPacketWriter();
    }

    @Override
    public boolean isSecureConnection() {
        return false;
    }

    @Override
    public boolean isUsingCompression() {
        return false;
    }

    @Override
    protected boolean useCompression() {
        return false;
    }

    @Override
    public void shutdown(Presence p) {
        super.shutdown(p);
        this.sessionID = null;
        if (this.client != null) {
            try {
                this.client.disconnect();
            }
            catch (BOSHException e) {
                LOGGER.log(Level.SEVERE, "Error disconnecting", e);
            }
            this.client = null;
        }
        if (this.readerPipe != null) {
            try {
                this.readerPipe.write("</boshstream>");
                this.readerPipe.flush();
                this.readerPipe.close();
                this.readerPipe = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void send(ComposableBody body) throws BOSHException {
        if (body == null) {
            throw new NullPointerException("Body mustn't be null!");
        }
        if (this.sessionID != null) {
            body = body.rebuild().setAttribute(BodyQName.create(BOSH_URI, "sid"), this.sessionID).build();
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("SEND: " + body.toXML());
        }
        this.client.send(body);
    }

    @Override
    protected void onSuccessReceived() throws IOException {
        this.packetWriter.openStream();
    }

    private class BOSHWriter
    extends Writer {
        private StringBuilder buffer = new StringBuilder();

        private BOSHWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.buffer == null) {
                throw new IOException("BOSHWriter is closed");
            }
            this.buffer.append(cbuf, off, len);
        }

        @Override
        public void flush() throws IOException {
            if (this.buffer == null) {
                throw new IOException("BOSHWriter is closed");
            }
            try {
                String toSend = this.buffer.toString();
                this.buffer = new StringBuilder();
                ComposableBody body = ComposableBody.builder().setPayloadXML(toSend).build();
                XMPPBOSHConnection.this.send(body);
            }
            catch (BOSHException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.buffer = null;
        }
    }

    private class BOSHPacketReader
    implements BOSHClientResponseListener {
        private BOSHPacketReader() {
        }

        @Override
        public void responseReceived(BOSHMessageEvent event) {
            block6: {
                AbstractBody body = event.getBody();
                if (body != null) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("RECVD: " + body.toXML());
                    }
                    try {
                        if (XMPPBOSHConnection.this.sessionID == null) {
                            XMPPBOSHConnection.this.sessionID = body.getAttribute(BodyQName.create(XMPPBOSHConnection.BOSH_URI, "sid"));
                        }
                        if (XMPPBOSHConnection.this.connectionID == null) {
                            XMPPBOSHConnection.this.connectionID = body.getAttribute(BodyQName.create(XMPPBOSHConnection.BOSH_URI, "authid"));
                        }
                        XMPPBOSHConnection.this.readerPipe.write(body.toXML());
                        XMPPBOSHConnection.this.readerPipe.flush();
                    }
                    catch (IOException e) {
                        if (!XMPPBOSHConnection.this.isConnected()) break block6;
                        XMPPBOSHConnection.this.packetReader.notifyConnectionError(e);
                    }
                }
            }
        }
    }

    class BOSHPacketWriter
    extends PacketWriter {
        BOSHPacketWriter() {
            super(XMPPBOSHConnection.this, true);
        }

        @Override
        protected void openStream() throws IOException {
            try {
                ComposableBody.Builder body = ComposableBody.builder();
                body.setNamespaceDefinition("xmpp", XMPPBOSHConnection.XMPP_BOSH_NS);
                body.setAttribute(BodyQName.createWithPrefix(XMPPBOSHConnection.XMPP_BOSH_NS, "version", "xmpp"), "1.0");
                if (XMPPBOSHConnection.this.connected) {
                    body.setAttribute(BodyQName.createWithPrefix(XMPPBOSHConnection.XMPP_BOSH_NS, "restart", "xmpp"), "true");
                }
                body.setAttribute(BodyQName.create(XMPPBOSHConnection.BOSH_URI, "to"), XMPPBOSHConnection.this.config.getServiceName());
                XMPPBOSHConnection.this.send(body.build());
            }
            catch (BOSHException e) {
                throw new IOException(e);
            }
        }

        @Override
        protected void closeStream() throws IOException {
        }
    }

    private class BOSHConnectionListener
    implements BOSHClientConnListener {
        private BOSHConnectionListener() {
        }

        @Override
        public void connectionEvent(BOSHClientConnEvent connEvent) {
            try {
                if (connEvent.isConnected()) {
                    XMPPBOSHConnection.this.connected = true;
                } else {
                    if (connEvent.isError()) {
                        if (XMPPBOSHConnection.this.packetReader != null) {
                            XMPPBOSHConnection.this.packetReader.notifyConnectionError(new IOException(connEvent.getCause()));
                        } else {
                            LOGGER.log(Level.SEVERE, "BOSH ERROR", connEvent.getCause());
                        }
                    }
                    XMPPBOSHConnection.this.connected = false;
                }
            }
            finally {
                if (XMPPBOSHConnection.this.packetReader != null) {
                    XMPPBOSHConnection.this.packetReader.releaseConnectionIDLock();
                }
            }
        }
    }
}

