/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.ldap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.java.sip.communicator.impl.ldap.LdapServiceImpl;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.ldap.LdapConstants;
import net.java.sip.communicator.service.ldap.LdapDirectorySettings;
import org.jitsi.service.configuration.ConfigurationService;

public class LdapDirectorySettingsImpl
implements LdapDirectorySettings {
    private static final String directoriesPath = "net.java.sip.communicator.impl.ldap.directories";
    private String name;
    private boolean enabled;
    private String hostname;
    private LdapConstants.Encryption encryption;
    private int port;
    private LdapConstants.Auth auth;
    private String bindDN;
    private String password;
    private String baseDN;
    private LdapConstants.Scope scope;
    private String globalPhonePrefix;
    private String mailSuffix = null;
    private String queryMode;
    private String customQuery;
    private boolean mangleQuery;
    private boolean photoInline;
    private Map<String, List<String>> mapAttributes = new HashMap<String, List<String>>();

    public LdapDirectorySettingsImpl() {
        this.setName("");
        this.setEnabled(true);
        this.setHostname("");
        this.setEncryption(LdapConstants.Encryption.defaultValue());
        this.setPort(0);
        this.setAuth(LdapConstants.Auth.defaultValue());
        this.setBindDN("");
        this.setPassword("");
        this.setBaseDN("");
        this.setScope(LdapConstants.Scope.defaultValue());
        this.setGlobalPhonePrefix("");
        this.setQueryMode("");
        this.setCustomQuery("");
        this.setMangleQuery(true);
        this.setPhotoInline(false);
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("mail");
        lst.add("uid");
        this.mapAttributes.put("mail", lst);
        lst = new ArrayList();
        lst.add("telephoneNumber");
        lst.add("primaryPhone");
        lst.add("companyPhone");
        lst.add("otherTelephone");
        lst.add("tel");
        this.mapAttributes.put("workPhone", lst);
        lst = new ArrayList();
        lst.add("mobilePhone");
        lst.add("mobileTelephoneNumber");
        lst.add("mobileTelephoneNumber");
        lst.add("mobileTelephoneNumber");
        lst.add("carPhone");
        this.mapAttributes.put("mobilePhone", lst);
        lst = new ArrayList();
        lst.add("homePhone");
        lst.add("otherHomePhone");
        this.mapAttributes.put("homePhone", lst);
    }

    public LdapDirectorySettingsImpl(LdapDirectorySettingsImpl settings) {
        this();
        this.setName(settings.getName());
        this.setEnabled(settings.isEnabled());
        this.setHostname(settings.getHostname());
        this.setEncryption(settings.getEncryption());
        this.setPort(settings.getPort());
        this.setAuth(settings.getAuth());
        this.setBindDN(settings.getBindDN());
        this.setPassword(settings.getPassword());
        this.setBaseDN(settings.getBaseDN());
        this.setScope(settings.getScope());
        this.setGlobalPhonePrefix(settings.getGlobalPhonePrefix());
        this.mapAttributes = settings.mapAttributes;
        this.mailSuffix = settings.mailSuffix;
        this.queryMode = settings.queryMode;
        this.customQuery = settings.customQuery;
        this.mangleQuery = settings.mangleQuery;
        this.photoInline = settings.photoInline;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public LdapConstants.Encryption getEncryption() {
        return this.encryption;
    }

    @Override
    public void setEncryption(LdapConstants.Encryption encryption) {
        this.encryption = encryption;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public LdapConstants.Auth getAuth() {
        return this.auth;
    }

    @Override
    public void setAuth(LdapConstants.Auth auth) {
        this.auth = auth;
    }

    @Override
    public String getBindDN() {
        return this.bindDN;
    }

    public String getUserName() {
        if (this.bindDN == null) {
            return null;
        }
        String userName = null;
        int uidIndex = this.bindDN.indexOf("uid=");
        if (uidIndex > -1) {
            int commaIndex = this.bindDN.indexOf(",", uidIndex + 5);
            userName = commaIndex > -1 ? this.bindDN.substring(uidIndex + 4, commaIndex) : this.bindDN.substring(uidIndex + 4);
        }
        return userName;
    }

    @Override
    public void setBindDN(String bindDN) {
        this.bindDN = bindDN;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getBaseDN() {
        return this.baseDN;
    }

    @Override
    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    @Override
    public LdapConstants.Scope getScope() {
        return this.scope;
    }

    @Override
    public void setScope(LdapConstants.Scope scope) {
        this.scope = scope;
    }

    @Override
    public String getGlobalPhonePrefix() {
        return this.globalPhonePrefix;
    }

    @Override
    public void setGlobalPhonePrefix(String prefix) {
        this.globalPhonePrefix = prefix;
    }

    public boolean equals(LdapDirectorySettings other) {
        return this.getName().equals(other.getName()) && this.getHostname().equals(other.getHostname()) && this.getEncryption().equals((Object)other.getEncryption()) && this.getPort() == other.getPort() && this.getAuth().equals((Object)other.getAuth()) && this.getBindDN().equals(other.getBindDN()) && this.getPassword().equals(other.getPassword()) && this.getBaseDN().equals(other.getBaseDN()) && this.getScope().equals((Object)other.getScope()) && this.getGlobalPhonePrefix().equals(other.getGlobalPhonePrefix()) && this.getCustomQuery().equals(other.getCustomQuery()) && this.getQueryMode().equals(other.getQueryMode()) && this.isMangleQuery() == other.isMangleQuery() && this.isPhotoInline() == other.isPhotoInline();
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.getName() ? 0 : this.getName().hashCode());
        hash = 31 * hash + (null == this.getHostname() ? 0 : this.getHostname().hashCode());
        hash = 31 * hash + (null == this.getEncryption() ? 0 : this.getEncryption().hashCode());
        hash = 31 * hash + this.getPort();
        hash = 31 * hash + (null == this.getAuth() ? 0 : this.getAuth().hashCode());
        hash = 31 * hash + (null == this.getBindDN() ? 0 : this.getBindDN().hashCode());
        hash = 31 * hash + (null == this.getPassword() ? 0 : this.getPassword().hashCode());
        hash = 31 * hash + (null == this.getScope() ? 0 : this.getScope().hashCode());
        hash = 31 * hash + (null == this.getBaseDN() ? 0 : this.getBaseDN().hashCode());
        hash = 31 * hash + (null == this.getGlobalPhonePrefix() ? 0 : this.getGlobalPhonePrefix().hashCode());
        hash = 31 * hash + (null == this.getCustomQuery() ? 0 : this.getCustomQuery().hashCode());
        hash = 32 * hash + (null == this.getQueryMode() ? 0 : this.getQueryMode().hashCode());
        hash = 33 * hash + (this.isMangleQuery() ? 1 : 0);
        hash = 34 * hash + (this.isPhotoInline() ? 1 : 0);
        return hash;
    }

    @Override
    public List<String> getMailSearchFields() {
        return this.mapAttributes.get("mail");
    }

    @Override
    public void setMailSearchFields(List<String> list) {
        this.mapAttributes.put("mail", list);
    }

    @Override
    public String getMailSuffix() {
        return this.mailSuffix;
    }

    @Override
    public void setMailSuffix(String suffix) {
        this.mailSuffix = suffix;
    }

    @Override
    public String getQueryMode() {
        return this.queryMode;
    }

    @Override
    public void setQueryMode(String queryMode) {
        this.queryMode = queryMode;
    }

    @Override
    public String getCustomQuery() {
        return this.customQuery;
    }

    @Override
    public void setCustomQuery(String query) {
        this.customQuery = query;
    }

    @Override
    public boolean isMangleQuery() {
        return this.mangleQuery;
    }

    @Override
    public void setMangleQuery(boolean mangle) {
        this.mangleQuery = mangle;
    }

    @Override
    public boolean isPhotoInline() {
        return this.photoInline;
    }

    @Override
    public void setPhotoInline(boolean inline) {
        this.photoInline = inline;
    }

    @Override
    public List<String> getWorkPhoneSearchFields() {
        return this.mapAttributes.get("workPhone");
    }

    @Override
    public void setWorkPhoneSearchFields(List<String> list) {
        this.mapAttributes.put("workPhone", list);
    }

    @Override
    public List<String> getMobilePhoneSearchFields() {
        return this.mapAttributes.get("mobilePhone");
    }

    @Override
    public void setMobilePhoneSearchFields(List<String> list) {
        this.mapAttributes.put("mobilePhone", list);
    }

    @Override
    public List<String> getHomePhoneSearchFields() {
        return this.mapAttributes.get("homePhone");
    }

    @Override
    public void setHomePhoneSearchFields(List<String> list) {
        this.mapAttributes.put("homePhone", list);
    }

    public static String mergeStrings(List<String> lst) {
        StringBuilder bld = new StringBuilder();
        for (String s : lst) {
            bld.append(s).append(" ");
        }
        return bld.toString();
    }

    public static List<String> mergeString(String attrs) {
        StringTokenizer token = new StringTokenizer(attrs, " ");
        ArrayList<String> lst = new ArrayList<String>();
        while (token.hasMoreTokens()) {
            lst.add(token.nextToken());
        }
        return lst;
    }

    @Override
    public void persistentSave() {
        ConfigurationService configService = LdapServiceImpl.getConfigService();
        CredentialsStorageService credentialsService = LdapServiceImpl.getCredentialsService();
        String node = "dir" + Math.abs(this.getName().hashCode());
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node, (Object)this.getName());
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".enabled", (Object)this.isEnabled());
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".hostname", (Object)this.getHostname());
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".encryption", (Object)this.getEncryption().toString());
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".port", (Object)String.valueOf(this.getPort()));
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".auth", (Object)this.getAuth().toString());
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".bindDN", (Object)this.getBindDN());
        credentialsService.storePassword("net.java.sip.communicator.impl.ldap.directories." + node, this.getPassword());
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".scope", (Object)this.getScope());
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".baseDN", (Object)this.getBaseDN());
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overridemail", (Object)LdapDirectorySettingsImpl.mergeStrings(this.getMailSearchFields()));
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overridemailsuffix", (Object)this.mailSuffix);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overrideworkphone", (Object)LdapDirectorySettingsImpl.mergeStrings(this.getWorkPhoneSearchFields()));
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overridemobilephone", (Object)LdapDirectorySettingsImpl.mergeStrings(this.getMobilePhoneSearchFields()));
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overridehomephone", (Object)LdapDirectorySettingsImpl.mergeStrings(this.getHomePhoneSearchFields()));
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".globalPhonePrefix", (Object)this.getGlobalPhonePrefix());
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".querymode", (Object)this.getQueryMode());
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".customquery", (Object)this.getCustomQuery());
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".mangle", (Object)this.isMangleQuery());
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".inlinephoto", (Object)this.isPhotoInline());
    }

    @Override
    public void persistentLoad(String name) {
        Object ret;
        ConfigurationService configService = LdapServiceImpl.getConfigService();
        CredentialsStorageService credentialsService = LdapServiceImpl.getCredentialsService();
        String node = "dir" + Math.abs(name.hashCode());
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node) == null) {
            this.setName("");
        } else {
            this.setName((String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node));
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".enabled") == null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(Boolean.parseBoolean((String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".enabled")));
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".hostname") == null) {
            this.setHostname("");
        } else {
            this.setHostname((String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".hostname"));
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".encryption") == null) {
            this.setEncryption(LdapConstants.Encryption.defaultValue());
        } else {
            this.setEncryption(LdapConstants.Encryption.valueOf((String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".encryption")));
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".port") == null) {
            this.setPort(0);
        } else {
            this.setPort(Integer.parseInt((String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".port")));
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".auth") == null) {
            this.setAuth(LdapConstants.Auth.defaultValue());
        } else {
            this.setAuth(LdapConstants.Auth.valueOf((String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".auth")));
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".bindDN") == null) {
            this.setBindDN("");
        } else {
            this.setBindDN((String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".bindDN"));
        }
        String password = credentialsService.loadPassword("net.java.sip.communicator.impl.ldap.directories." + node);
        if (password == null) {
            this.setPassword("");
        } else {
            this.setPassword(password);
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".scope") == null) {
            this.setScope(LdapConstants.Scope.defaultValue());
        } else {
            this.setScope(LdapConstants.Scope.valueOf((String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".scope")));
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".baseDN") == null) {
            this.setBaseDN("");
        } else {
            this.setBaseDN((String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".baseDN"));
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overridemail") != null) {
            ret = (String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overridemail");
            this.mapAttributes.put("mail", LdapDirectorySettingsImpl.mergeString((String)ret));
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overridemailsuffix") != null) {
            ret = (String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overridemailsuffix");
            this.mailSuffix = ret;
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overrideworkphone") != null) {
            ret = (String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overrideworkphone");
            this.mapAttributes.put("workPhone", LdapDirectorySettingsImpl.mergeString((String)ret));
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overridemobilephone") != null) {
            ret = (String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overridemobilephone");
            this.mapAttributes.put("mobilePhone", LdapDirectorySettingsImpl.mergeString((String)ret));
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overridehomephone") != null) {
            ret = (String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overridehomephone");
            this.mapAttributes.put("homePhone", LdapDirectorySettingsImpl.mergeString((String)ret));
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".globalPhonePrefix") != null && (ret = (String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".globalPhonePrefix")) != null) {
            this.setGlobalPhonePrefix((String)ret);
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".querymode") != null && (ret = (String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".querymode")) != null) {
            this.setQueryMode((String)ret);
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".customquery") != null && (ret = (String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".customquery")) != null) {
            this.setCustomQuery((String)ret);
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".mangle") != null && (ret = Boolean.valueOf(Boolean.parseBoolean((String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".mangle")))) != null) {
            this.setMangleQuery((Boolean)ret);
        }
        if (configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".inlinephoto") != null && (ret = Boolean.valueOf(Boolean.parseBoolean((String)configService.getProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".inlinephoto")))) != null) {
            this.setPhotoInline((Boolean)ret);
        }
    }

    @Override
    public void persistentRemove() {
        ConfigurationService configService = LdapServiceImpl.getConfigService();
        CredentialsStorageService credentialsService = LdapServiceImpl.getCredentialsService();
        String node = "dir" + Math.abs(this.getName().hashCode());
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".enabled", null);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".hostname", null);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".encryption", null);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".port", null);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".auth", null);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".bindDN", null);
        credentialsService.removePassword("net.java.sip.communicator.impl.ldap.directories." + node);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".baseDN", null);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".scope", null);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overridemail", null);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overridemailsuffix", null);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overrideworkphone", null);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overridemobilephone", null);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".overridehomephone", null);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".globalPhonePrefix", null);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node, null);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".querymode", null);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".customquery", null);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".mangle", null);
        configService.setProperty("net.java.sip.communicator.impl.ldap.directories." + node + ".inlinephoto", null);
    }

    public String toString() {
        return "LdapDirectorySettings: {\n " + this.getName() + ", \n" + this.getHostname() + ", \n" + (Object)((Object)this.getEncryption()) + ", \n" + this.getPort() + ", \n" + (Object)((Object)this.getAuth()) + ", \n" + this.getBindDN() + ", \n" + this.getPassword() + ", \n" + this.getBaseDN() + ", \n" + this.getGlobalPhonePrefix() + " \n" + this.queryMode + " \n" + this.customQuery + " \n" + this.mangleQuery + " \n" + this.photoInline + " \n}";
    }

    @Override
    public LdapDirectorySettings clone() {
        return new LdapDirectorySettingsImpl(this);
    }
}

