/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.net.InetAddress;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;

public class DNSQuestion
extends DNSEntry {
    private static Logger logger = Logger.getLogger(DNSQuestion.class.getName());

    DNSQuestion(String string, DNSRecordType dNSRecordType, DNSRecordClass dNSRecordClass, boolean bl) {
        super(string, dNSRecordType, dNSRecordClass, bl);
    }

    public static DNSQuestion newQuestion(String string, DNSRecordType dNSRecordType, DNSRecordClass dNSRecordClass, boolean bl) {
        switch (dNSRecordType) {
            case TYPE_A: {
                return new DNS4Address(string, dNSRecordType, dNSRecordClass, bl);
            }
            case TYPE_A6: {
                return new DNS6Address(string, dNSRecordType, dNSRecordClass, bl);
            }
            case TYPE_AAAA: {
                return new DNS6Address(string, dNSRecordType, dNSRecordClass, bl);
            }
            case TYPE_ANY: {
                return new AllRecords(string, dNSRecordType, dNSRecordClass, bl);
            }
            case TYPE_HINFO: {
                return new HostInformation(string, dNSRecordType, dNSRecordClass, bl);
            }
            case TYPE_PTR: {
                return new Pointer(string, dNSRecordType, dNSRecordClass, bl);
            }
            case TYPE_SRV: {
                return new Service(string, dNSRecordType, dNSRecordClass, bl);
            }
            case TYPE_TXT: {
                return new Text(string, dNSRecordType, dNSRecordClass, bl);
            }
        }
        return new DNSQuestion(string, dNSRecordType, dNSRecordClass, bl);
    }

    boolean answeredBy(DNSEntry dNSEntry) {
        return this.isSameRecordClass(dNSEntry) && this.isSameType(dNSEntry) && this.getName().equals(dNSEntry.getName());
    }

    public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> set) {
    }

    protected void addAnswersForServiceInfo(JmDNSImpl jmDNSImpl, Set<DNSRecord> set, ServiceInfoImpl serviceInfoImpl) {
        if (serviceInfoImpl != null && serviceInfoImpl.isAnnounced()) {
            if (this.getName().equalsIgnoreCase(serviceInfoImpl.getQualifiedName()) || this.getName().equalsIgnoreCase(serviceInfoImpl.getType())) {
                set.addAll(jmDNSImpl.getLocalHost().answers(true, 3600));
                set.addAll(serviceInfoImpl.answers(true, 3600, jmDNSImpl.getLocalHost()));
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(jmDNSImpl.getName() + " DNSQuestion(" + this.getName() + ").addAnswersForServiceInfo(): info: " + serviceInfoImpl + "\n" + set);
            }
        }
    }

    @Override
    public boolean isStale(long l) {
        return false;
    }

    @Override
    public boolean isExpired(long l) {
        return false;
    }

    public boolean iAmTheOnlyOne(JmDNSImpl jmDNSImpl) {
        return false;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
    }

    private static class AllRecords
    extends DNSQuestion {
        AllRecords(String string, DNSRecordType dNSRecordType, DNSRecordClass dNSRecordClass, boolean bl) {
            super(string, dNSRecordType, dNSRecordClass, bl);
        }

        @Override
        public boolean isSameType(DNSEntry dNSEntry) {
            return dNSEntry != null;
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> set) {
            String string = this.getName().toLowerCase();
            if (jmDNSImpl.getLocalHost().getName().equalsIgnoreCase(string)) {
                set.addAll(jmDNSImpl.getLocalHost().answers(this.isUnique(), 3600));
                return;
            }
            if (jmDNSImpl.getServiceTypes().containsKey(string)) {
                Pointer pointer = new Pointer(this.getName(), DNSRecordType.TYPE_PTR, this.getRecordClass(), this.isUnique());
                ((DNSQuestion)pointer).addAnswers(jmDNSImpl, set);
                return;
            }
            this.addAnswersForServiceInfo(jmDNSImpl, set, (ServiceInfoImpl)jmDNSImpl.getServices().get(string));
        }

        @Override
        public boolean iAmTheOnlyOne(JmDNSImpl jmDNSImpl) {
            String string = this.getName().toLowerCase();
            return jmDNSImpl.getLocalHost().getName().equals(string) || jmDNSImpl.getServices().keySet().contains(string);
        }
    }

    private static class Text
    extends DNSQuestion {
        Text(String string, DNSRecordType dNSRecordType, DNSRecordClass dNSRecordClass, boolean bl) {
            super(string, dNSRecordType, dNSRecordClass, bl);
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> set) {
            this.addAnswersForServiceInfo(jmDNSImpl, set, (ServiceInfoImpl)jmDNSImpl.getServices().get(this.getName().toLowerCase()));
        }

        @Override
        public boolean iAmTheOnlyOne(JmDNSImpl jmDNSImpl) {
            String string = this.getName().toLowerCase();
            return jmDNSImpl.getLocalHost().getName().equals(string) || jmDNSImpl.getServices().keySet().contains(string);
        }
    }

    private static class Service
    extends DNSQuestion {
        Service(String string, DNSRecordType dNSRecordType, DNSRecordClass dNSRecordClass, boolean bl) {
            super(string, dNSRecordType, dNSRecordClass, bl);
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> set) {
            String string = this.getName().toLowerCase();
            if (jmDNSImpl.getLocalHost().getName().equalsIgnoreCase(string)) {
                set.addAll(jmDNSImpl.getLocalHost().answers(this.isUnique(), 3600));
                return;
            }
            if (jmDNSImpl.getServiceTypes().containsKey(string)) {
                Pointer pointer = new Pointer(this.getName(), DNSRecordType.TYPE_PTR, this.getRecordClass(), this.isUnique());
                ((DNSQuestion)pointer).addAnswers(jmDNSImpl, set);
                return;
            }
            this.addAnswersForServiceInfo(jmDNSImpl, set, (ServiceInfoImpl)jmDNSImpl.getServices().get(string));
        }

        @Override
        public boolean iAmTheOnlyOne(JmDNSImpl jmDNSImpl) {
            String string = this.getName().toLowerCase();
            return jmDNSImpl.getLocalHost().getName().equals(string) || jmDNSImpl.getServices().keySet().contains(string);
        }
    }

    private static class Pointer
    extends DNSQuestion {
        Pointer(String string, DNSRecordType dNSRecordType, DNSRecordClass dNSRecordClass, boolean bl) {
            super(string, dNSRecordType, dNSRecordClass, bl);
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> set) {
            for (ServiceInfo object : jmDNSImpl.getServices().values()) {
                this.addAnswersForServiceInfo(jmDNSImpl, set, (ServiceInfoImpl)object);
            }
            if (this.isServicesDiscoveryMetaQuery()) {
                for (String string : jmDNSImpl.getServiceTypes().keySet()) {
                    JmDNSImpl.ServiceTypeEntry serviceTypeEntry = jmDNSImpl.getServiceTypes().get(string);
                    set.add(new DNSRecord.Pointer("_services._dns-sd._udp.local.", DNSRecordClass.CLASS_IN, false, 3600, serviceTypeEntry.getType()));
                }
            } else if (this.isReverseLookup()) {
                String string = this.getQualifiedNameMap().get((Object)ServiceInfo.Fields.Instance);
                if (string != null && string.length() > 0) {
                    String string2;
                    InetAddress inetAddress = jmDNSImpl.getLocalHost().getInetAddress();
                    String string3 = string2 = inetAddress != null ? inetAddress.getHostAddress() : "";
                    if (string.equalsIgnoreCase(string2)) {
                        if (this.isV4ReverseLookup()) {
                            set.add(jmDNSImpl.getLocalHost().getDNSReverseAddressRecord(DNSRecordType.TYPE_A, false, 3600));
                        }
                        if (this.isV6ReverseLookup()) {
                            set.add(jmDNSImpl.getLocalHost().getDNSReverseAddressRecord(DNSRecordType.TYPE_AAAA, false, 3600));
                        }
                    }
                }
            } else if (this.isDomainDiscoveryQuery()) {
                // empty if block
            }
        }
    }

    private static class HostInformation
    extends DNSQuestion {
        HostInformation(String string, DNSRecordType dNSRecordType, DNSRecordClass dNSRecordClass, boolean bl) {
            super(string, dNSRecordType, dNSRecordClass, bl);
        }
    }

    private static class DNS6Address
    extends DNSQuestion {
        DNS6Address(String string, DNSRecordType dNSRecordType, DNSRecordClass dNSRecordClass, boolean bl) {
            super(string, dNSRecordType, dNSRecordClass, bl);
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> set) {
            DNSRecord.Address address = jmDNSImpl.getLocalHost().getDNSAddressRecord(this.getRecordType(), true, 3600);
            if (address != null) {
                set.add(address);
            }
        }

        @Override
        public boolean iAmTheOnlyOne(JmDNSImpl jmDNSImpl) {
            String string = this.getName().toLowerCase();
            return jmDNSImpl.getLocalHost().getName().equals(string) || jmDNSImpl.getServices().keySet().contains(string);
        }
    }

    private static class DNS4Address
    extends DNSQuestion {
        DNS4Address(String string, DNSRecordType dNSRecordType, DNSRecordClass dNSRecordClass, boolean bl) {
            super(string, dNSRecordType, dNSRecordClass, bl);
        }

        @Override
        public void addAnswers(JmDNSImpl jmDNSImpl, Set<DNSRecord> set) {
            DNSRecord.Address address = jmDNSImpl.getLocalHost().getDNSAddressRecord(this.getRecordType(), true, 3600);
            if (address != null) {
                set.add(address);
            }
        }

        @Override
        public boolean iAmTheOnlyOne(JmDNSImpl jmDNSImpl) {
            String string = this.getName().toLowerCase();
            return jmDNSImpl.getLocalHost().getName().equals(string) || jmDNSImpl.getServices().keySet().contains(string);
        }
    }
}

