/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.constraint;

import java.lang.reflect.Array;
import org.jmock.core.Constraint;

public class IsArrayContaining
implements Constraint {
    private final Constraint elementConstraint;

    public IsArrayContaining(Constraint constraint) {
        this.elementConstraint = constraint;
    }

    @Override
    public boolean eval(Object object) {
        return object != null && object.getClass().isArray() && this.arrayContainsMatchingElement(object);
    }

    private boolean arrayContainsMatchingElement(Object object) {
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            if (!this.elementConstraint.eval(Array.get(object, i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public StringBuffer describeTo(StringBuffer stringBuffer) {
        stringBuffer.append("an array containing ");
        this.elementConstraint.describeTo(stringBuffer);
        return stringBuffer;
    }
}

