/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.stub;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jmock.core.Formatting;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;

public class ReturnIteratorStub
implements Stub {
    private Collection collection;

    public ReturnIteratorStub(Collection collection) {
        this.collection = collection;
    }

    public ReturnIteratorStub(Object[] objectArray) {
        this.collection = Arrays.asList(objectArray);
    }

    @Override
    public Object invoke(Invocation invocation) throws Throwable {
        return this.collection.iterator();
    }

    @Override
    public StringBuffer describeTo(StringBuffer stringBuffer) {
        stringBuffer.append("return iterator over ");
        boolean bl = false;
        Iterator iterator = this.collection.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(Formatting.toReadableString(iterator.next()));
            bl = true;
        }
        return stringBuffer;
    }
}

