/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.util.MockUtil;

public class SpyAnnotationEngine
implements AnnotationEngine {
    @Override
    public Object createMockFor(Annotation annotation, Field field) {
        return null;
    }

    @Override
    public void process(Class<?> clazz, Object object) {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Spy.class) || field.isAnnotationPresent(InjectMocks.class)) continue;
            this.assertNoIncompatibleAnnotations(Spy.class, field, Mock.class, MockitoAnnotations.Mock.class, Captor.class);
            field.setAccessible(true);
            try {
                Object object2 = field.get(object);
                SpyAnnotationEngine.assertNotInterface(object2, field.getType());
                if (new MockUtil().isMock(object2)) {
                    Mockito.reset(object2);
                    continue;
                }
                if (object2 != null) {
                    field.set(object, Mockito.mock(object2.getClass(), Mockito.withSettings().spiedInstance(object2).defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field.getName())));
                    continue;
                }
                field.set(object, SpyAnnotationEngine.newSpyInstance(object, field));
            }
            catch (Exception exception) {
                throw new MockitoException("Unable to initialize @Spy annotated field '" + field.getName() + "'.\n" + exception.getMessage(), exception);
            }
        }
    }

    private static void assertNotInterface(Object object, Class<?> clazz) {
        Class<?> clazz2 = clazz = object != null ? object.getClass() : clazz;
        if (clazz.isInterface()) {
            throw new MockitoException("Type '" + clazz.getSimpleName() + "' is an interface and it cannot be spied on.");
        }
    }

    private static Object newSpyInstance(Object object, Field field) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        GenericDeclaration genericDeclaration;
        MockSettings mockSettings = Mockito.withSettings().defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field.getName());
        Class<?> clazz = field.getType();
        if (clazz.isInterface()) {
            return Mockito.mock(clazz, mockSettings.useConstructor());
        }
        if (!Modifier.isStatic(clazz.getModifiers()) && (genericDeclaration = clazz.getEnclosingClass()) != null) {
            if (!((Class)genericDeclaration).isInstance(object)) {
                throw new MockitoException("@Spy annotation can only initialize inner classes declared in the test. Inner class: '" + clazz.getSimpleName() + "', " + "outer class: '" + ((Class)genericDeclaration).getSimpleName() + "'.");
            }
            return Mockito.mock(clazz, mockSettings.useConstructor().outerInstance(object));
        }
        try {
            genericDeclaration = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new MockitoException("Please ensure that the type '" + clazz.getSimpleName() + "' has 0-arg constructor.");
        }
        if (Modifier.isPrivate(((Constructor)genericDeclaration).getModifiers())) {
            ((Constructor)genericDeclaration).setAccessible(true);
            return Mockito.mock(clazz, mockSettings.spiedInstance(((Constructor)genericDeclaration).newInstance(new Object[0])));
        }
        return Mockito.mock(clazz, mockSettings.useConstructor());
    }

    void assertNoIncompatibleAnnotations(Class clazz, Field field, Class ... classArray) {
        for (Class clazz2 : classArray) {
            if (!field.isAnnotationPresent(clazz2)) continue;
            new Reporter().unsupportedCombinationOfAnnotations(clazz.getSimpleName(), clazz.getClass().getSimpleName());
        }
    }
}

