/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.listeners;

import org.mockito.internal.matchers.Equality;
import org.mockito.invocation.DescribedInvocation;
import org.mockito.invocation.Invocation;
import org.mockito.listeners.MethodInvocationReport;

public class NotifiedMethodInvocationReport
implements MethodInvocationReport {
    private final Invocation invocation;
    private final Object returnedValue;
    private final Throwable throwable;

    public NotifiedMethodInvocationReport(Invocation invocation, Object object) {
        this.invocation = invocation;
        this.returnedValue = object;
        this.throwable = null;
    }

    public NotifiedMethodInvocationReport(Invocation invocation, Throwable throwable) {
        this.invocation = invocation;
        this.returnedValue = null;
        this.throwable = throwable;
    }

    @Override
    public DescribedInvocation getInvocation() {
        return this.invocation;
    }

    @Override
    public Object getReturnedValue() {
        return this.returnedValue;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public boolean threwException() {
        return this.throwable != null;
    }

    @Override
    public String getLocationOfStubbing() {
        return this.invocation.stubInfo() == null ? null : this.invocation.stubInfo().stubbedAt().toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NotifiedMethodInvocationReport notifiedMethodInvocationReport = (NotifiedMethodInvocationReport)object;
        return Equality.areEqual(this.invocation, notifiedMethodInvocationReport.invocation) && Equality.areEqual(this.returnedValue, notifiedMethodInvocationReport.returnedValue) && Equality.areEqual(this.throwable, notifiedMethodInvocationReport.throwable);
    }

    public int hashCode() {
        int n = this.invocation != null ? this.invocation.hashCode() : 0;
        n = 31 * n + (this.returnedValue != null ? this.returnedValue.hashCode() : 0);
        n = 31 * n + (this.throwable != null ? this.throwable.hashCode() : 0);
        return n;
    }
}

