/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.dmt.security;

import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.service.dmt.security.DmtAlertPermissionCollection;

public class AlertPermission
extends Permission {
    private static final long serialVersionUID = -3206463101788245739L;
    private final boolean isPrefix;
    private final String serverId;

    public AlertPermission(String string) {
        super(string);
        if (string == null) {
            throw new NullPointerException("'target' parameter must not be null.");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("'target' parameter must not be empty.");
        }
        this.isPrefix = string.endsWith("*");
        this.serverId = this.isPrefix ? string.substring(0, string.length() - 1) : string;
    }

    public AlertPermission(String string, String string2) {
        this(string);
        if (string2 == null) {
            throw new NullPointerException("'actions' parameter must not be null.");
        }
        if (!string2.equals("*")) {
            throw new IllegalArgumentException("'actions' parameter must be \"*\".");
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AlertPermission)) {
            return false;
        }
        AlertPermission alertPermission = (AlertPermission)object;
        return this.isPrefix == alertPermission.isPrefix && this.serverId.equals(alertPermission.serverId);
    }

    @Override
    public String getActions() {
        return "*";
    }

    @Override
    public int hashCode() {
        return new Boolean(this.isPrefix).hashCode() ^ this.serverId.hashCode();
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof AlertPermission)) {
            return false;
        }
        AlertPermission alertPermission = (AlertPermission)permission;
        return this.impliesServer(alertPermission);
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new DmtAlertPermissionCollection();
    }

    boolean impliesServer(AlertPermission alertPermission) {
        return this.isPrefix ? alertPermission.serverId.startsWith(this.serverId) : !alertPermission.isPrefix && alertPermission.serverId.equals(this.serverId);
    }
}

