/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.remoteserviceadmin;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Dictionary;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointPermissionCollection;

public final class EndpointPermission
extends Permission {
    static final long serialVersionUID = -7662148639076511574L;
    public static final String READ = "read";
    public static final String IMPORT = "import";
    public static final String EXPORT = "export";
    private static final int ACTION_READ = 1;
    private static final int ACTION_IMPORT = 2;
    private static final int ACTION_EXPORT = 4;
    private static final int ACTION_ALL = 7;
    static final int ACTION_NONE = 0;
    transient int action_mask;
    private volatile String actions = null;
    final transient EndpointDescription endpoint;
    private final transient Dictionary<String, Object> properties;
    transient Filter filter;

    public EndpointPermission(String string, String string2) {
        this(string, EndpointPermission.parseActions(string2));
    }

    public EndpointPermission(EndpointDescription endpointDescription, String string, String string2) {
        super(EndpointPermission.createName(endpointDescription));
        Map<String, Object> map;
        this.setTransients(null, EndpointPermission.parseActions(string2));
        if (string != null && string.equals(endpointDescription.getFrameworkUUID())) {
            map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            map.putAll(endpointDescription.getProperties());
            map.put("endpoint.framework.uuid", new String[]{endpointDescription.getFrameworkUUID(), "<<LOCAL>>"});
        } else {
            map = endpointDescription.getProperties();
        }
        this.endpoint = endpointDescription;
        this.properties = new EndpointDescription.UnmodifiableDictionary<String, Object>(map);
    }

    private static String createName(EndpointDescription endpointDescription) {
        if (endpointDescription == null) {
            throw new IllegalArgumentException("invalid endpoint: null");
        }
        StringBuffer stringBuffer = new StringBuffer("(endpoint.id=");
        stringBuffer.append(endpointDescription.getId());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    EndpointPermission(String string, int n) {
        super(string);
        this.setTransients(EndpointPermission.parseFilter(string), n);
        this.endpoint = null;
        this.properties = null;
    }

    private void setTransients(Filter filter, int n) {
        if (n == 0 || (n & 7) != n) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
        this.filter = filter;
    }

    private static int parseActions(String string) {
        boolean bl = false;
        int n = 0;
        if (string == null) {
            return n;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (!(n2 < 5 || cArray[n2 - 5] != 'i' && cArray[n2 - 5] != 'I' || cArray[n2 - 4] != 'm' && cArray[n2 - 4] != 'M' || cArray[n2 - 3] != 'p' && cArray[n2 - 3] != 'P' || cArray[n2 - 2] != 'o' && cArray[n2 - 2] != 'O' || cArray[n2 - 1] != 'r' && cArray[n2 - 1] != 'R' || cArray[n2] != 't' && cArray[n2] != 'T')) {
                n3 = 6;
                n |= 3;
            } else if (!(n2 < 5 || cArray[n2 - 5] != 'e' && cArray[n2 - 5] != 'E' || cArray[n2 - 4] != 'x' && cArray[n2 - 4] != 'X' || cArray[n2 - 3] != 'p' && cArray[n2 - 3] != 'P' || cArray[n2 - 2] != 'o' && cArray[n2 - 2] != 'O' || cArray[n2 - 1] != 'r' && cArray[n2 - 1] != 'R' || cArray[n2] != 't' && cArray[n2] != 'T')) {
                n3 = 6;
                n |= 5;
            } else if (!(n2 < 3 || cArray[n2 - 3] != 'r' && cArray[n2 - 3] != 'R' || cArray[n2 - 2] != 'e' && cArray[n2 - 2] != 'E' || cArray[n2 - 1] != 'a' && cArray[n2 - 1] != 'A' || cArray[n2] != 'd' && cArray[n2] != 'D')) {
                n3 = 4;
                n |= 1;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        if (bl) {
            throw new IllegalArgumentException("invalid permission: " + string);
        }
        return n;
    }

    private static Filter parseFilter(String string) {
        if (string == null) {
            throw new IllegalArgumentException("invalid filter: null");
        }
        if ((string = string.trim()).equals("*")) {
            return null;
        }
        try {
            return FrameworkUtil.createFilter((String)string);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid filter");
            illegalArgumentException.initCause(invalidSyntaxException);
            throw illegalArgumentException;
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof EndpointPermission)) {
            return false;
        }
        EndpointPermission endpointPermission = (EndpointPermission)permission;
        if (this.endpoint != null) {
            return false;
        }
        if (endpointPermission.filter != null) {
            return false;
        }
        return this.implies0(endpointPermission, 0);
    }

    boolean implies0(EndpointPermission endpointPermission, int n) {
        int n2 = endpointPermission.action_mask;
        if (((n |= this.action_mask) & n2) != n2) {
            return false;
        }
        Filter filter = this.filter;
        if (filter == null) {
            return true;
        }
        return filter.matchCase(endpointPermission.getProperties());
    }

    @Override
    public String getActions() {
        String string = this.actions;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n = this.action_mask;
            if ((n & 1) == 1) {
                stringBuffer.append(READ);
                bl = true;
            }
            if ((n & 2) == 2) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(IMPORT);
            }
            if ((n & 4) == 4) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(EXPORT);
            }
            this.actions = string = stringBuffer.toString();
        }
        return string;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new EndpointPermissionCollection();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EndpointPermission)) {
            return false;
        }
        EndpointPermission endpointPermission = (EndpointPermission)object;
        return this.action_mask == endpointPermission.action_mask && this.getName().equals(endpointPermission.getName()) && (this.endpoint == endpointPermission.endpoint || this.endpoint != null && endpointPermission.endpoint != null && this.endpoint.equals(endpointPermission.endpoint));
    }

    @Override
    public int hashCode() {
        int n = 527 + this.getName().hashCode();
        n = 31 * n + this.getActions().hashCode();
        if (this.endpoint != null) {
            n = 31 * n + this.endpoint.hashCode();
        }
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.endpoint != null) {
            throw new NotSerializableException("cannot serialize");
        }
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setTransients(EndpointPermission.parseFilter(this.getName()), EndpointPermission.parseActions(this.actions));
    }

    private Dictionary<String, Object> getProperties() {
        return this.properties;
    }
}

