/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.KeyDefinition;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.EmptyEnumeration;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.sort.LocalOrderComparer;
import java.util.Hashtable;
import java.util.Vector;

public class KeyManager {
    private Hashtable keyList = new Hashtable();

    public void setKeyDefinition(KeyDefinition keyDefinition) {
        Integer n = new Integer(keyDefinition.getFingerprint());
        Vector<KeyDefinition> vector = (Vector<KeyDefinition>)this.keyList.get(n);
        if (vector == null) {
            vector = new Vector<KeyDefinition>();
            this.keyList.put(n, vector);
        }
        vector.addElement(keyDefinition);
    }

    public Vector getKeyDefinitions(int n) {
        return (Vector)this.keyList.get(new Integer(n));
    }

    private synchronized Hashtable buildIndex(int n, DocumentInfo documentInfo, Controller controller) throws XPathException {
        Vector vector = this.getKeyDefinitions(n);
        if (vector == null) {
            throw new XPathException("Key " + controller.getNamePool().getDisplayName(n) + " has not been defined");
        }
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < vector.size(); ++i) {
            this.constructIndex(documentInfo, hashtable, (KeyDefinition)vector.elementAt(i), controller, i == 0);
        }
        return hashtable;
    }

    private void constructIndex(DocumentInfo documentInfo, Hashtable hashtable, KeyDefinition keyDefinition, Controller controller, boolean bl) throws XPathException {
        Pattern pattern = keyDefinition.getMatch();
        Expression expression = keyDefinition.getUse();
        DocumentInfo documentInfo2 = documentInfo;
        NodeInfo nodeInfo = documentInfo2;
        Context context = controller.makeContext(documentInfo);
        short s = pattern.getNodeType();
        AxisEnumeration axisEnumeration = documentInfo.getEnumeration((byte)4, AnyNodeTest.getInstance());
        if (s == 2 || s == 0) {
            while (axisEnumeration.hasMoreElements()) {
                nodeInfo = axisEnumeration.nextElement();
                if (nodeInfo.getNodeType() == 1) {
                    AxisEnumeration axisEnumeration2 = nodeInfo.getEnumeration((byte)2, AnyNodeTest.getInstance());
                    while (axisEnumeration2.hasMoreElements()) {
                        this.processKeyNode(axisEnumeration2.nextElement(), pattern, expression, hashtable, context, bl);
                    }
                    if (s != 0) continue;
                    this.processKeyNode(nodeInfo, pattern, expression, hashtable, context, bl);
                    continue;
                }
                this.processKeyNode(nodeInfo, pattern, expression, hashtable, context, bl);
            }
        } else {
            while (axisEnumeration.hasMoreElements()) {
                nodeInfo = axisEnumeration.nextElement();
                this.processKeyNode(nodeInfo, pattern, expression, hashtable, context, bl);
            }
        }
    }

    private void processKeyNode(NodeInfo nodeInfo, Pattern pattern, Expression expression, Hashtable hashtable, Context context, boolean bl) throws XPathException {
        if (pattern.matches(nodeInfo, context)) {
            context.setContextNode(nodeInfo);
            context.setCurrentNode(nodeInfo);
            context.setPosition(1);
            context.setLast(1);
            Value value = expression.evaluate(context);
            if (value instanceof NodeSetValue) {
                NodeEnumeration nodeEnumeration = ((NodeSetValue)value).enumerate();
                while (nodeEnumeration.hasMoreElements()) {
                    NodeInfo nodeInfo2 = nodeEnumeration.nextElement();
                    String string = nodeInfo2.getStringValue();
                    NodeSetExtent nodeSetExtent = (NodeSetExtent)hashtable.get(string);
                    if (nodeSetExtent == null) {
                        nodeSetExtent = new NodeSetExtent(LocalOrderComparer.getInstance());
                        nodeSetExtent.setSorted(true);
                        hashtable.put(string, nodeSetExtent);
                    }
                    nodeSetExtent.append(nodeInfo);
                    if (bl) continue;
                    nodeSetExtent.setSorted(false);
                    nodeSetExtent.sort();
                }
            } else {
                String string = value.asString();
                context.setContextNode(nodeInfo);
                NodeSetExtent nodeSetExtent = (NodeSetExtent)hashtable.get(string);
                if (nodeSetExtent == null) {
                    nodeSetExtent = new NodeSetExtent(LocalOrderComparer.getInstance());
                    nodeSetExtent.setSorted(true);
                    hashtable.put(string, nodeSetExtent);
                }
                nodeSetExtent.append(nodeInfo);
                if (!bl) {
                    nodeSetExtent.setSorted(false);
                    nodeSetExtent.sort();
                }
            }
        }
    }

    public NodeEnumeration selectByKey(int n, DocumentInfo documentInfo, String string, Controller controller) throws XPathException {
        NodeSetExtent nodeSetExtent;
        Hashtable hashtable = documentInfo.getKeyIndex(this, n);
        if (hashtable == null) {
            hashtable = this.buildIndex(n, documentInfo, controller);
            documentInfo.setKeyIndex(this, n, hashtable);
        }
        return (nodeSetExtent = (NodeSetExtent)hashtable.get(string)) == null ? EmptyEnumeration.getInstance() : nodeSetExtent.enumerate();
    }
}

