/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

public final class AttributeValueTemplate
extends Expression {
    private Expression[] components = new Expression[10];
    private int numberOfComponents;

    private AttributeValueTemplate(Expression[] expressionArray, int n) {
        this.components = new Expression[n];
        this.numberOfComponents = n;
        System.arraycopy(expressionArray, 0, this.components, 0, n);
    }

    public static Expression make(String string, StaticContext staticContext) throws XPathException {
        if (string.indexOf("{") < 0 && string.indexOf("}") < 0) {
            return new StringValue(string);
        }
        int n = 0;
        Expression[] expressionArray = new Expression[string.length()];
        char c = ' ';
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            int n4 = string.indexOf("{", n2);
            int n5 = string.indexOf("{{", n2);
            int n6 = string.indexOf("}", n2);
            int n7 = string.indexOf("}}", n2);
            if (n6 >= 0 && (n4 < 0 || n6 < n4)) {
                if (n6 != n7) {
                    throw new XPathException("Closing curly brace in attribute value template \"" + string + "\" must be doubled");
                }
                expressionArray[n++] = new StringValue(string.substring(n2, n6 + 1));
                n2 = n6 + 2;
                continue;
            }
            if (n5 >= 0 && n5 == n4) {
                expressionArray[n++] = new StringValue(string.substring(n2, n5 + 1));
                n2 = n5 + 2;
                continue;
            }
            if (n4 >= 0) {
                int n8;
                if (n4 > n2) {
                    expressionArray[n++] = new StringValue(string.substring(n2, n4));
                }
                for (n8 = n4 + 1; n8 < n3; ++n8) {
                    if (string.charAt(n8) == '\"') {
                        c = '\"';
                    }
                    if (string.charAt(n8) == '\'') {
                        c = '\'';
                    }
                    if (c != ' ') {
                        ++n8;
                        while (n8 < n3 && string.charAt(n8) != c) {
                            ++n8;
                        }
                        c = ' ';
                        continue;
                    }
                    if (string.charAt(n8) == '}') break;
                }
                if (n8 >= n3) {
                    throw new XPathException("No closing \"}\" in attribute value template " + string);
                }
                String string2 = string.substring(n4 + 1, n8);
                Expression expression = Expression.make(string2, staticContext);
                expressionArray[n++] = expression;
                n2 = n8 + 1;
                continue;
            }
            expressionArray[n++] = new StringValue(string.substring(n2));
            n2 = n3;
        }
        return new AttributeValueTemplate(expressionArray, n).simplify();
    }

    @Override
    public Expression simplify() throws XPathException {
        if (this.numberOfComponents == 0) {
            return new StringValue("");
        }
        if (this.numberOfComponents == 1) {
            return this.components[0];
        }
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.components[i] = this.components[i].simplify();
        }
        return this;
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        return new StringValue(this.evaluateAsString(context));
    }

    @Override
    public int getDataType() {
        return 3;
    }

    @Override
    public String evaluateAsString(Context context) throws XPathException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.numberOfComponents; ++i) {
            stringBuffer.append(this.components[i].evaluateAsString(context));
        }
        return stringBuffer.toString();
    }

    @Override
    public int getDependencies() {
        int n = 0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            n |= this.components[i].getDependencies();
        }
        return n;
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        throw new XPathException("Cannot reduce expressions in an attribute value template");
    }

    @Override
    public void display(int n) {
        System.err.println(AttributeValueTemplate.indent(n) + "{<AVT>}");
    }
}

