/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

public class SubstringBefore
extends Function {
    @Override
    public String getName() {
        return "substring-before";
    }

    @Override
    public int getDataType() {
        return 3;
    }

    @Override
    public Expression simplify() throws XPathException {
        boolean bl;
        int n = this.checkArgumentCount(2, 2);
        this.argument[0] = this.argument[0].simplify();
        this.argument[1] = this.argument[1].simplify();
        boolean bl2 = bl = this.argument[0] instanceof Value && this.argument[1] instanceof Value;
        if (bl) {
            return this.evaluate(null);
        }
        return this;
    }

    @Override
    public String evaluateAsString(Context context) throws XPathException {
        String string = this.argument[0].evaluateAsString(context);
        String string2 = this.argument[1].evaluateAsString(context);
        return SubstringBefore.before(string, string2);
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        return new StringValue(this.evaluateAsString(context));
    }

    @Override
    public int getDependencies() {
        int n = this.argument[0].getDependencies() | this.argument[1].getDependencies();
        return n;
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        SubstringBefore substringBefore = new SubstringBefore();
        substringBefore.addArgument(this.argument[0].reduce(n, context));
        substringBefore.addArgument(this.argument[1].reduce(n, context));
        substringBefore.setStaticContext(this.getStaticContext());
        return substringBefore.simplify();
    }

    private static String before(String string, String string2) {
        int n = string.indexOf(string2);
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }
}

