/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.DocumentInfo;

public class UnparsedEntityURI
extends Function {
    DocumentInfo boundDocument = null;

    @Override
    public String getName() {
        return "unparsed-entity-uri";
    }

    @Override
    public int getDataType() {
        return 3;
    }

    @Override
    public Expression simplify() throws XPathException {
        this.checkArgumentCount(1, 1);
        return this;
    }

    @Override
    public String evaluateAsString(Context context) throws XPathException {
        String string = this.argument[0].evaluateAsString(context);
        DocumentInfo documentInfo = this.boundDocument;
        if (documentInfo == null) {
            documentInfo = context.getContextNodeInfo().getDocumentRoot();
        }
        return documentInfo.getUnparsedEntity(string);
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        return new StringValue(this.evaluateAsString(context));
    }

    @Override
    public int getDependencies() {
        int n = this.argument[0].getDependencies();
        if (this.boundDocument == null) {
            n |= 8;
        }
        return n;
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        UnparsedEntityURI unparsedEntityURI = new UnparsedEntityURI();
        unparsedEntityURI.addArgument(this.argument[0].reduce(n, context));
        unparsedEntityURI.setStaticContext(this.getStaticContext());
        unparsedEntityURI.boundDocument = this.boundDocument == null && (n & 8) != 0 ? context.getContextNodeInfo().getDocumentRoot() : this.boundDocument;
        return unparsedEntityURI;
    }
}

