/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.output.Emitter;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;

public class DOMEmitter
extends Emitter {
    protected Node currentNode;
    protected Document document;
    private boolean canNormalize = true;

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
        String string = this.namePool.getDisplayName(n);
        try {
            int n3;
            Element element = this.document.createElement(string);
            this.currentNode.appendChild(element);
            this.currentNode = element;
            for (n3 = 0; n3 < n2; ++n3) {
                String string2 = this.namePool.getPrefixFromNamespaceCode(nArray[n3]);
                String string3 = this.namePool.getURIFromNamespaceCode(nArray[n3]);
                if (string3.equals("http://www.w3.org/XML/1998/namespace")) continue;
                if (string2.equals("")) {
                    element.setAttribute("xmlns", string3);
                    continue;
                }
                element.setAttribute("xmlns:" + string2, string3);
            }
            for (n3 = 0; n3 < attributes.getLength(); ++n3) {
                element.setAttribute(attributes.getQName(n3), attributes.getValue(n3));
            }
        }
        catch (DOMException dOMException) {
            throw new TransformerException(dOMException);
        }
    }

    @Override
    public void endElement(int n) throws TransformerException {
        if (this.canNormalize) {
            try {
                this.currentNode.normalize();
            }
            catch (Throwable throwable) {
                this.canNormalize = false;
            }
        }
        this.currentNode = this.currentNode.getParentNode();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws TransformerException {
        try {
            Text text = this.document.createTextNode(new String(cArray, n, n2));
            this.currentNode.appendChild(text);
        }
        catch (DOMException dOMException) {
            throw new TransformerException(dOMException);
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws TransformerException {
        try {
            ProcessingInstruction processingInstruction = this.document.createProcessingInstruction(string, string2);
            this.currentNode.appendChild(processingInstruction);
        }
        catch (DOMException dOMException) {
            throw new TransformerException(dOMException);
        }
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws TransformerException {
        try {
            Comment comment = this.document.createComment(new String(cArray, n, n2));
            this.currentNode.appendChild(comment);
        }
        catch (DOMException dOMException) {
            throw new TransformerException(dOMException);
        }
    }

    public void setNode(Node node) {
        this.currentNode = node;
        this.document = node.getNodeType() == 9 ? (Document)node : this.currentNode.getOwnerDocument();
    }
}

