/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Binding;
import com.icl.saxon.Context;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.style.XSLGeneralVariable;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class SAXONAssign
extends XSLGeneralVariable {
    private Binding binding;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        super.validate();
        try {
            this.binding = this.bindVariable(this.getVariableFingerprint());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException.getMessage());
            return;
        }
        if (!this.binding.isAssignable()) {
            this.compileError("Variable " + this.getVariableName() + " is not marked as assignable");
        }
    }

    @Override
    public boolean isAssignable() {
        return true;
    }

    @Override
    public void process(Context context) throws TransformerException {
        Value value = this.getSelectValue(context);
        context.getController().getBindery().assignVariable(this.binding, value);
    }
}

