/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Loader;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.functions.Round;
import com.icl.saxon.number.NumberFormatter;
import com.icl.saxon.number.Numberer;
import com.icl.saxon.number.Numberer_en;
import com.icl.saxon.om.Navigator;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.tree.AttributeCollection;
import java.util.Vector;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLNumber
extends StyleElement {
    private static final int SINGLE = 0;
    private static final int MULTI = 1;
    private static final int ANY = 2;
    private static final int SIMPLE = 3;
    private int level;
    private Pattern count = null;
    private Pattern from = null;
    private Expression expr = null;
    private Expression format = null;
    private Expression groupSize = null;
    private Expression groupSeparator = null;
    private Expression letterValue = null;
    private Expression lang = null;
    private NumberFormatter formatter = null;
    private Numberer numberer = null;
    private static Numberer defaultNumberer = new Numberer_en();

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            int n2 = n & 0xFFFFF;
            if (n2 == standardNames.VALUE) {
                string = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.COUNT) {
                string2 = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.FROM) {
                string3 = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.LEVEL) {
                string4 = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.FORMAT) {
                string5 = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.LANG) {
                string8 = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.LETTER_VALUE) {
                string9 = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.GROUPING_SIZE) {
                string6 = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.GROUPING_SEPARATOR) {
                string7 = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string != null) {
            this.expr = this.makeExpression(string);
        }
        if (string2 != null) {
            this.count = this.makePattern(string2);
        }
        if (string3 != null) {
            this.from = this.makePattern(string3);
        }
        if (string4 == null) {
            this.level = 0;
        } else if (string4.equals("single")) {
            this.level = 0;
        } else if (string4.equals("multiple")) {
            this.level = 1;
        } else if (string4.equals("any")) {
            this.level = 2;
        } else {
            this.compileError("Invalid value for level attribute");
        }
        if (this.level == 0 && this.from == null && this.count == null) {
            this.level = 3;
        }
        if (string5 != null) {
            this.format = this.makeAttributeValueTemplate(string5);
            if (this.format instanceof StringValue) {
                this.formatter = new NumberFormatter();
                this.formatter.prepare(((StringValue)this.format).asString());
            }
        } else {
            this.formatter = new NumberFormatter();
            this.formatter.prepare("1");
        }
        if (string7 != null && string6 != null) {
            this.groupSize = this.makeAttributeValueTemplate(string6);
            this.groupSeparator = this.makeAttributeValueTemplate(string7);
        }
        if (string8 == null) {
            this.numberer = defaultNumberer;
        } else {
            this.lang = this.makeAttributeValueTemplate(string8);
            if (this.lang instanceof StringValue) {
                this.numberer = XSLNumber.makeNumberer(((StringValue)this.lang).asString());
            }
        }
        if (string9 != null) {
            this.letterValue = this.makeAttributeValueTemplate(string9);
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.checkEmpty();
    }

    @Override
    public void process(Context context) throws TransformerException {
        String string;
        Object object;
        NodeInfo nodeInfo = context.getCurrentNodeInfo();
        int n = -1;
        Vector<Integer> vector = null;
        if (this.expr != null) {
            double d = this.expr.evaluateAsNumber(context);
            if (d < 0.5 || Double.isNaN(d) || Double.isInfinite(d) || d > 2.147483647E9) {
                context.getOutputter().writeContent(new NumericValue(d).asString());
                return;
            }
            n = (int)Round.round(d);
        } else if (this.level == 3) {
            n = Navigator.getNumberSimple(nodeInfo, context);
        } else if (this.level == 0) {
            n = Navigator.getNumberSingle(nodeInfo, this.count, this.from, context);
            if (n == 0) {
                vector = new Vector<Integer>();
            }
        } else if (this.level == 2) {
            n = Navigator.getNumberAny(nodeInfo, this.count, this.from, context);
            if (n == 0) {
                vector = new Vector<Integer>();
            }
        } else if (this.level == 1) {
            vector = Navigator.getNumberMulti(nodeInfo, this.count, this.from, context);
        }
        int n2 = 0;
        String string2 = "";
        if (this.groupSize != null) {
            object = this.groupSize.evaluateAsString(context);
            try {
                n2 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.styleError("group-size must be numeric");
            }
        }
        if (this.groupSeparator != null) {
            string2 = this.groupSeparator.evaluateAsString(context);
        }
        if (vector == null && this.format == null && n2 == 0 && this.lang == null) {
            context.getOutputter().writeContent("" + n);
            return;
        }
        if (this.numberer == null) {
            this.numberer = XSLNumber.makeNumberer(this.lang.evaluateAsString(context));
        }
        if (this.letterValue == null) {
            string = "";
        } else {
            string = this.letterValue.evaluateAsString(context);
            if (!string.equals("alphabetic") && !string.equals("traditional")) {
                throw this.styleError("letter-value must be \"traditional\" or \"alphabetic\"");
            }
        }
        if (vector == null) {
            vector = new Vector();
            vector.addElement(new Integer(n));
        }
        if (this.formatter == null) {
            object = new NumberFormatter();
            ((NumberFormatter)object).prepare(this.format.evaluateAsString(context));
        } else {
            object = this.formatter;
        }
        String string3 = ((NumberFormatter)object).format(vector, n2, string2, string, this.numberer);
        context.getOutputter().writeContent(string3);
    }

    protected static Numberer makeNumberer(String string) {
        Numberer numberer;
        if (string.equals("en")) {
            numberer = defaultNumberer;
        } else {
            String string2 = "com.icl.saxon.number.Numberer_";
            for (int i = 0; i < string.length(); ++i) {
                if (!Character.isLetter(string.charAt(i))) continue;
                string2 = string2 + string.charAt(i);
            }
            try {
                numberer = (Numberer)Loader.getInstance(string2);
            }
            catch (Exception exception) {
                numberer = defaultNumberer;
            }
        }
        return numberer;
    }
}

