/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tinytree;

import com.icl.saxon.Context;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.om.Builder;
import com.icl.saxon.om.Name;
import com.icl.saxon.tinytree.TinyDocumentImpl;
import com.icl.saxon.tinytree.TinyNodeImpl;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;

public class TinyBuilder
extends Builder {
    private int currentDepth = 0;
    private int nodeNr = 0;
    private int attributeNodeNr = 0;
    private int namespaceNodeNr = 0;
    private boolean ended = false;
    private int[] prevAtDepth = new int[100];

    public void createDocument() {
        this.currentDocument = new TinyDocumentImpl();
        if (this.locator == null) {
            this.locator = this;
        }
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        tinyDocumentImpl.setSystemId(this.locator.getSystemId());
        tinyDocumentImpl.setNamePool(this.namePool);
    }

    @Override
    public void startDocument() throws TransformerException {
        this.failed = false;
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.currentDocument == null) {
            this.createDocument();
        } else {
            if (!(this.currentDocument instanceof TinyDocumentImpl)) {
                throw new TransformerException("Root node supplied is of wrong type");
            }
            if (this.currentDocument.hasChildNodes()) {
                throw new TransformerException("Supplied document is not empty");
            }
            this.currentDocument.setNamePool(this.namePool);
        }
        this.currentDepth = 0;
        this.nodeNr = 0;
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        if (this.lineNumbering) {
            tinyDocumentImpl.setLineNumbering();
        }
        tinyDocumentImpl.addNode((short)9, 0, 0, 0, -1);
        this.prevAtDepth[0] = 0;
        tinyDocumentImpl.next[0] = -1;
        ++this.currentDepth;
        ++this.nodeNr;
    }

    @Override
    public void endDocument() throws TransformerException {
        if (this.ended) {
            return;
        }
        this.ended = true;
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        int n = this.prevAtDepth[this.currentDepth];
        if (n > 0) {
            tinyDocumentImpl.next[n] = -1;
        }
        this.prevAtDepth[this.currentDepth] = -1;
    }

    @Override
    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
        int n3;
        int n4;
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        int n5 = n2 == 0 ? -1 : tinyDocumentImpl.numberOfNamespaces;
        for (n4 = 0; n4 < n2; ++n4) {
            tinyDocumentImpl.addNamespace(this.nodeNr, nArray[n4]);
        }
        n2 = 0;
        n4 = attributes.getLength();
        int n6 = n4 == 0 ? -1 : tinyDocumentImpl.numberOfAttributes;
        tinyDocumentImpl.addNode((short)1, this.currentDepth, n6, n5, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n7 = this.namePool.allocate(Name.getPrefix(attributes.getQName(n3)), attributes.getURI(n3), attributes.getLocalName(n3));
            tinyDocumentImpl.addAttribute(this.nodeNr, n7, attributes.getType(n3), attributes.getValue(n3));
        }
        n3 = this.prevAtDepth[this.currentDepth];
        if (n3 > 0) {
            tinyDocumentImpl.next[n3] = this.nodeNr;
        }
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
        ++this.currentDepth;
        if (this.currentDepth == this.prevAtDepth.length) {
            int[] nArray2 = new int[this.currentDepth * 2];
            System.arraycopy(this.prevAtDepth, 0, nArray2, 0, this.currentDepth);
            this.prevAtDepth = nArray2;
        }
        this.prevAtDepth[this.currentDepth] = -1;
        if (this.locator != null) {
            tinyDocumentImpl.setSystemId(this.nodeNr, this.locator.getSystemId());
            if (this.lineNumbering) {
                tinyDocumentImpl.setLineNumber(this.nodeNr, this.locator.getLineNumber());
            }
        }
        ++this.nodeNr;
    }

    @Override
    public void endElement(int n) throws TransformerException {
        int n2;
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        if (this.previewManager != null && this.previewManager.isPreviewElement(n2 = n & 0xFFFFF)) {
            TinyNodeImpl tinyNodeImpl = tinyDocumentImpl.getNode(this.prevAtDepth[this.currentDepth - 1]);
            Context context = this.controller.makeContext(tinyNodeImpl);
            this.controller.applyTemplates(context, new SingletonNodeSet(tinyNodeImpl), this.controller.getRuleManager().getMode(this.previewManager.getPreviewMode()), null);
            this.nodeNr = this.prevAtDepth[this.currentDepth - 1] + 1;
            tinyDocumentImpl.truncate(this.nodeNr);
        }
        if ((n2 = this.prevAtDepth[this.currentDepth]) > 0) {
            tinyDocumentImpl.next[n2] = -1;
        }
        this.prevAtDepth[this.currentDepth] = -1;
        --this.currentDepth;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws TransformerException {
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        if (n2 > 0) {
            int n3 = tinyDocumentImpl.charBufferLength;
            tinyDocumentImpl.appendChars(cArray, n, n2);
            tinyDocumentImpl.addNode((short)3, this.currentDepth, n3, n2, -1);
            int n4 = this.prevAtDepth[this.currentDepth];
            if (n4 > 0) {
                tinyDocumentImpl.next[n4] = this.nodeNr;
            }
            this.prevAtDepth[this.currentDepth] = this.nodeNr++;
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws TransformerException {
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        if (!this.discardComments) {
            int n = tinyDocumentImpl.commentBuffer.length();
            tinyDocumentImpl.commentBuffer.append(string2);
            int n2 = this.namePool.allocate("", "", string);
            tinyDocumentImpl.addNode((short)7, this.currentDepth, n, string2.length(), n2);
            int n3 = this.prevAtDepth[this.currentDepth];
            if (n3 > 0) {
                tinyDocumentImpl.next[n3] = this.nodeNr;
            }
            this.prevAtDepth[this.currentDepth] = this.nodeNr++;
        }
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws TransformerException {
        this.addComment(new String(cArray, n, n2));
    }

    private void addComment(String string) throws TransformerException {
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        if (!this.discardComments && !this.inDTD) {
            int n = tinyDocumentImpl.commentBuffer.length();
            tinyDocumentImpl.commentBuffer.append(string);
            tinyDocumentImpl.addNode((short)8, this.currentDepth, n, string.length(), -1);
            int n2 = this.prevAtDepth[this.currentDepth];
            if (n2 > 0) {
                tinyDocumentImpl.next[n2] = this.nodeNr;
            }
            this.prevAtDepth[this.currentDepth] = this.nodeNr++;
        }
    }

    @Override
    public void setUnparsedEntity(String string, String string2) {
        ((TinyDocumentImpl)this.currentDocument).setUnparsedEntity(string, string2);
    }
}

