/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tinytree;

import com.icl.saxon.KeyManager;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.Navigator;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.sort.LocalOrderComparer;
import com.icl.saxon.tinytree.TinyAttributeImpl;
import com.icl.saxon.tinytree.TinyCommentImpl;
import com.icl.saxon.tinytree.TinyElementImpl;
import com.icl.saxon.tinytree.TinyNamespaceImpl;
import com.icl.saxon.tinytree.TinyNodeImpl;
import com.icl.saxon.tinytree.TinyParentNodeImpl;
import com.icl.saxon.tinytree.TinyProcInstImpl;
import com.icl.saxon.tinytree.TinyTextImpl;
import com.icl.saxon.tree.LineNumberMap;
import com.icl.saxon.tree.SystemIdMap;
import java.util.Hashtable;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class TinyDocumentImpl
extends TinyParentNodeImpl
implements DocumentInfo,
Document {
    private Hashtable idTable = null;
    private NamePool namePool;
    private Hashtable elementList = null;
    private boolean usesNamespaces = false;
    private Hashtable entityTable = null;
    protected char[] charBuffer = new char[4000];
    protected int charBufferLength = 0;
    protected StringBuffer commentBuffer = new StringBuffer(500);
    protected int numberOfNodes = 0;
    protected int lastLevelOneNode = -1;
    protected byte[] nodeType = new byte[4000];
    protected short[] depth = new short[4000];
    protected int[] next = new int[4000];
    protected int[] offset = new int[4000];
    protected int[] length = new int[4000];
    protected int[] nameCode = new int[4000];
    protected int[] prior = null;
    protected int numberOfAttributes = 0;
    protected int[] attParent = new int[100];
    protected int[] attCode = new int[100];
    protected String[] attValue = new String[100];
    protected int numberOfNamespaces = 0;
    protected int[] namespaceParent = new int[20];
    protected int[] namespaceCode = new int[20];
    private LineNumberMap lineNumberMap;
    private SystemIdMap systemIdMap = new SystemIdMap();
    private Object[] index = new Object[30];
    private int indexEntriesUsed = 0;

    public TinyDocumentImpl() {
        this.nodeNr = 0;
        this.document = this;
    }

    @Override
    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
        this.addNamespace(0, namePool.getNamespaceCode("xml", "http://www.w3.org/XML/1998/namespace"));
    }

    @Override
    public NamePool getNamePool() {
        return this.namePool;
    }

    protected void ensureNodeCapacity() {
        if (this.nodeType.length < this.numberOfNodes + 1) {
            int n = this.numberOfNodes * 2;
            byte[] byArray = new byte[n];
            int[] nArray = new int[n];
            short[] sArray = new short[n];
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            System.arraycopy(this.nodeType, 0, byArray, 0, this.numberOfNodes);
            System.arraycopy(this.next, 0, nArray, 0, this.numberOfNodes);
            System.arraycopy(this.depth, 0, sArray, 0, this.numberOfNodes);
            System.arraycopy(this.offset, 0, nArray2, 0, this.numberOfNodes);
            System.arraycopy(this.length, 0, nArray3, 0, this.numberOfNodes);
            System.arraycopy(this.nameCode, 0, nArray4, 0, this.numberOfNodes);
            this.nodeType = byArray;
            this.next = nArray;
            this.depth = sArray;
            this.offset = nArray2;
            this.length = nArray3;
            this.nameCode = nArray4;
        }
    }

    protected void ensureAttributeCapacity() {
        if (this.attParent.length < this.numberOfAttributes + 1) {
            int n = this.numberOfAttributes * 2;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            String[] stringArray = new String[n];
            System.arraycopy(this.attParent, 0, nArray, 0, this.numberOfAttributes);
            System.arraycopy(this.attCode, 0, nArray2, 0, this.numberOfAttributes);
            System.arraycopy(this.attValue, 0, stringArray, 0, this.numberOfAttributes);
            this.attParent = nArray;
            this.attCode = nArray2;
            this.attValue = stringArray;
        }
    }

    protected void ensureNamespaceCapacity() {
        if (this.namespaceParent.length < this.numberOfNamespaces + 1) {
            int n = this.numberOfNamespaces * 2;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            System.arraycopy(this.namespaceParent, 0, nArray, 0, this.numberOfNamespaces);
            System.arraycopy(this.namespaceCode, 0, nArray2, 0, this.numberOfNamespaces);
            this.namespaceParent = nArray;
            this.namespaceCode = nArray2;
        }
    }

    protected void addNode(short s, int n, int n2, int n3, int n4) {
        this.ensureNodeCapacity();
        this.nodeType[this.numberOfNodes] = (byte)s;
        this.depth[this.numberOfNodes] = (short)n;
        this.offset[this.numberOfNodes] = n2;
        this.length[this.numberOfNodes] = n3;
        this.nameCode[this.numberOfNodes] = n4;
        this.next[this.numberOfNodes] = -1;
        if (n == 1) {
            this.lastLevelOneNode = this.numberOfNodes;
        }
        ++this.numberOfNodes;
    }

    protected void appendChars(char[] cArray, int n, int n2) {
        while (this.charBuffer.length < this.charBufferLength + n2) {
            char[] cArray2 = new char[this.charBuffer.length * 2];
            System.arraycopy(this.charBuffer, 0, cArray2, 0, this.charBufferLength);
            this.charBuffer = cArray2;
        }
        System.arraycopy(cArray, n, this.charBuffer, this.charBufferLength, n2);
        this.charBufferLength += n2;
    }

    protected void truncate(int n) {
        int n2;
        if (n == this.numberOfNodes) {
            return;
        }
        for (n2 = n; n2 < this.numberOfNodes; ++n2) {
            if (this.nodeType[n2] != 3) continue;
            this.charBufferLength = this.offset[n2];
            break;
        }
        for (n2 = n; n2 < this.numberOfNodes; ++n2) {
            if (this.nodeType[n2] != 1 || this.offset[n2] < 0) continue;
            this.numberOfAttributes = this.offset[n2];
            break;
        }
        for (n2 = n; n2 < this.numberOfNodes; ++n2) {
            if (this.nodeType[n2] != 1 || this.length[n2] < 0) continue;
            this.numberOfNamespaces = this.length[n2];
            break;
        }
        this.numberOfNodes = n;
        this.prior = null;
        this.nodeType[n] = 9;
        this.depth[n] = 0;
    }

    protected void ensurePriorIndex() {
        if (this.prior == null) {
            this.makePriorIndex();
        }
    }

    private synchronized void makePriorIndex() {
        int n;
        this.prior = new int[this.numberOfNodes];
        for (n = 0; n < this.numberOfNodes; ++n) {
            this.prior[n] = -1;
        }
        for (n = 0; n < this.numberOfNodes; ++n) {
            int n2 = this.next[n];
            if (n2 == -1) continue;
            this.prior[n2] = n;
        }
    }

    protected void addAttribute(int n, int n2, String string, String string2) {
        this.ensureAttributeCapacity();
        this.attParent[this.numberOfAttributes] = n;
        this.attCode[this.numberOfAttributes] = n2;
        this.attValue[this.numberOfAttributes] = string2;
        ++this.numberOfAttributes;
        if (string.equals("ID")) {
            if (this.idTable == null) {
                this.idTable = new Hashtable();
            }
            TinyNodeImpl tinyNodeImpl = this.getNode(n);
            this.registerID(tinyNodeImpl, string2);
        }
    }

    protected void addNamespace(int n, int n2) {
        this.usesNamespaces = true;
        this.ensureNamespaceCapacity();
        this.namespaceParent[this.numberOfNamespaces] = n;
        this.namespaceCode[this.numberOfNamespaces] = n2;
        ++this.numberOfNamespaces;
    }

    public TinyNodeImpl getNode(int n) {
        switch ((short)this.nodeType[n]) {
            case 9: {
                return this;
            }
            case 1: {
                return new TinyElementImpl(this, n);
            }
            case 3: {
                return new TinyTextImpl(this, n);
            }
            case 8: {
                return new TinyCommentImpl(this, n);
            }
            case 7: {
                return new TinyProcInstImpl(this, n);
            }
        }
        return null;
    }

    @Override
    public long getSequenceNumber() {
        return 0L;
    }

    protected TinyAttributeImpl getAttributeNode(int n) {
        return new TinyAttributeImpl(this, n);
    }

    protected boolean isUsingNamespaces() {
        return this.usesNamespaces;
    }

    protected TinyNamespaceImpl getNamespaceNode(int n) {
        return new TinyNamespaceImpl(this, n);
    }

    @Override
    public void setSystemId(String string) {
        if (string == null) {
            string = "";
        }
        this.systemIdMap.setSystemId(this.nodeNr, string);
    }

    @Override
    public String getSystemId() {
        return this.systemIdMap.getSystemId(this.nodeNr);
    }

    @Override
    public String getBaseURI() {
        return this.getSystemId();
    }

    protected void setSystemId(int n, String string) {
        if (string == null) {
            string = "";
        }
        this.systemIdMap.setSystemId(n, string);
    }

    protected String getSystemId(int n) {
        return this.systemIdMap.getSystemId(n);
    }

    public void setLineNumbering() {
        this.lineNumberMap = new LineNumberMap();
        this.lineNumberMap.setLineNumber(0, 0);
    }

    protected void setLineNumber(int n, int n2) {
        if (this.lineNumberMap != null) {
            this.lineNumberMap.setLineNumber(n, n2);
        }
    }

    protected int getLineNumber(int n) {
        if (this.lineNumberMap != null) {
            return this.lineNumberMap.getLineNumber(n);
        }
        return -1;
    }

    @Override
    public int getLineNumber() {
        return 0;
    }

    @Override
    public final short getNodeType() {
        return 9;
    }

    @Override
    public NodeInfo getParent() {
        return null;
    }

    @Override
    public DocumentInfo getDocumentRoot() {
        return this;
    }

    @Override
    public String generateId() {
        return "";
    }

    protected AxisEnumeration getAllElements(int n) {
        NodeSetExtent nodeSetExtent;
        Integer n2 = new Integer(n);
        if (this.elementList == null) {
            this.elementList = new Hashtable();
        }
        if ((nodeSetExtent = (NodeSetExtent)this.elementList.get(n2)) == null) {
            nodeSetExtent = new NodeSetExtent(LocalOrderComparer.getInstance());
            nodeSetExtent.setSorted(true);
            for (int i = 1; i < this.numberOfNodes; ++i) {
                if (this.nodeType[i] != 1 || (this.nameCode[i] & 0xFFFFF) != n) continue;
                nodeSetExtent.append(this.getNode(i));
            }
            this.elementList.put(n2, nodeSetExtent);
        }
        return (AxisEnumeration)nodeSetExtent.enumerate();
    }

    private void registerID(NodeInfo nodeInfo, String string) {
        NodeInfo nodeInfo2 = (NodeInfo)this.idTable.get(string);
        if (nodeInfo2 == null) {
            this.idTable.put(string, nodeInfo);
        }
    }

    @Override
    public NodeInfo selectID(String string) {
        if (this.idTable == null) {
            return null;
        }
        return (NodeInfo)this.idTable.get(string);
    }

    @Override
    public synchronized Hashtable getKeyIndex(KeyManager keyManager, int n) {
        for (int i = 0; i < this.indexEntriesUsed; i += 3) {
            if ((KeyManager)this.index[i] != keyManager || (Integer)this.index[i + 1] != n) continue;
            Object object = this.index[i + 2];
            return (Hashtable)this.index[i + 2];
        }
        return null;
    }

    @Override
    public synchronized void setKeyIndex(KeyManager keyManager, int n, Hashtable hashtable) {
        for (int i = 0; i < this.indexEntriesUsed; i += 3) {
            if ((KeyManager)this.index[i] != keyManager || (Integer)this.index[i + 1] != n) continue;
            this.index[i + 2] = hashtable;
            return;
        }
        if (this.indexEntriesUsed + 3 >= this.index.length) {
            Object[] objectArray = new Object[this.indexEntriesUsed * 2];
            System.arraycopy(this.index, 0, objectArray, 0, this.indexEntriesUsed);
            this.index = objectArray;
        }
        this.index[this.indexEntriesUsed++] = keyManager;
        this.index[this.indexEntriesUsed++] = new Integer(n);
        this.index[this.indexEntriesUsed++] = hashtable;
    }

    protected void setUnparsedEntity(String string, String string2) {
        if (this.entityTable == null) {
            this.entityTable = new Hashtable();
        }
        this.entityTable.put(string, string2);
    }

    @Override
    public String getUnparsedEntity(String string) {
        if (this.entityTable == null) {
            return "";
        }
        String string2 = (String)this.entityTable.get(string);
        return string2 == null ? "" : string2;
    }

    @Override
    public void copy(Outputter outputter) throws TransformerException {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)3, AnyNodeTest.getInstance());
        while (axisEnumeration.hasMoreElements()) {
            axisEnumeration.nextElement().copy(outputter);
        }
    }

    public void diagnosticDump() {
        System.err.println("Node\ttype\tdepth\toffset\tlength");
        for (int i = 0; i < this.numberOfNodes; ++i) {
            System.err.println(i + "\t" + this.nodeType[i] + "\t" + this.depth[i] + "\t" + this.offset[i] + "\t" + this.length[i] + "\t" + Navigator.getPath(this.getNode(i)));
        }
    }

    @Override
    public Node adoptNode(Node node) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    @Override
    public String getDocumentURI() {
        return this.getSystemId();
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return null;
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public boolean getStrictErrorChecking() {
        return true;
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        return false;
    }

    @Override
    public String getXmlVersion() {
        return "1.0";
    }

    @Override
    public void normalizeDocument() {
        this.disallowUpdate();
    }

    @Override
    public Node renameNode(Node node, String string, String string2) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    @Override
    public void setDocumentURI(String string) {
        this.setSystemId(string);
    }

    @Override
    public void setStrictErrorChecking(boolean bl) {
        throw new UnsupportedOperationException("setStrictErrorChecking() is not supported");
    }

    @Override
    public void setXmlStandalone(boolean bl) throws DOMException {
        this.disallowUpdate();
    }

    @Override
    public void setXmlVersion(String string) throws DOMException {
        this.disallowUpdate();
    }
}

