/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.migrator.line;

import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.migrator.line.ConversionRule;
import org.slf4j.migrator.line.RuleSet;

public class LineConverter {
    final RuleSet ruleSet;
    boolean atLeastOneMatchOccured = false;

    public LineConverter(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    public String[] getReplacement(String string) {
        Iterator<ConversionRule> iterator = this.ruleSet.iterator();
        String string2 = null;
        while (iterator.hasNext()) {
            ConversionRule conversionRule = iterator.next();
            Pattern pattern = conversionRule.getPattern();
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            this.atLeastOneMatchOccured = true;
            String string3 = conversionRule.replace(matcher);
            string = matcher.replaceAll(string3);
            if (conversionRule.getAdditionalLine() == null) continue;
            string2 = conversionRule.getAdditionalLine();
        }
        if (string2 == null) {
            return new String[]{string};
        }
        return new String[]{string, string2};
    }

    public String getOneLineReplacement(String string) {
        Object[] objectArray = this.getReplacement(string);
        if (objectArray.length != 1) {
            throw new IllegalStateException("Expecting a single string but got " + Arrays.toString(objectArray));
        }
        return objectArray[0];
    }

    public boolean atLeastOneMatchOccured() {
        return this.atLeastOneMatchOccured;
    }
}

