/* Streams.c generated by valac 0.52.4, the Vala compiler
 * generated from Streams.vala, do not modify */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <gee.h>

#define TOOTLE_TYPE_STREAMS (tootle_streams_get_type ())
#define TOOTLE_STREAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_TYPE_STREAMS, TootleStreams))
#define TOOTLE_STREAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_TYPE_STREAMS, TootleStreamsClass))
#define TOOTLE_IS_STREAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_TYPE_STREAMS))
#define TOOTLE_IS_STREAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_TYPE_STREAMS))
#define TOOTLE_STREAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_TYPE_STREAMS, TootleStreamsClass))

typedef struct _TootleStreams TootleStreams;
typedef struct _TootleStreamsClass TootleStreamsClass;
typedef struct _TootleStreamsPrivate TootleStreamsPrivate;

#define TOOTLE_STREAMS_TYPE_CONNECTION (tootle_streams_connection_get_type ())
#define TOOTLE_STREAMS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_STREAMS_TYPE_CONNECTION, TootleStreamsConnection))
#define TOOTLE_STREAMS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_STREAMS_TYPE_CONNECTION, TootleStreamsConnectionClass))
#define TOOTLE_STREAMS_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_STREAMS_TYPE_CONNECTION))
#define TOOTLE_STREAMS_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_STREAMS_TYPE_CONNECTION))
#define TOOTLE_STREAMS_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_STREAMS_TYPE_CONNECTION, TootleStreamsConnectionClass))

typedef struct _TootleStreamsConnection TootleStreamsConnection;
typedef struct _TootleStreamsConnectionClass TootleStreamsConnectionClass;
enum  {
	TOOTLE_STREAMS_0_PROPERTY,
	TOOTLE_STREAMS_CONNECTIONS_PROPERTY,
	TOOTLE_STREAMS_NUM_PROPERTIES
};
static GParamSpec* tootle_streams_properties[TOOTLE_STREAMS_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TOOTLE_TYPE_ISTREAM_LISTENER (tootle_istream_listener_get_type ())
#define TOOTLE_ISTREAM_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_TYPE_ISTREAM_LISTENER, TootleIStreamListener))
#define TOOTLE_IS_ISTREAM_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_TYPE_ISTREAM_LISTENER))
#define TOOTLE_ISTREAM_LISTENER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TOOTLE_TYPE_ISTREAM_LISTENER, TootleIStreamListenerIface))

typedef struct _TootleIStreamListener TootleIStreamListener;
typedef struct _TootleIStreamListenerIface TootleIStreamListenerIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define TOOTLE_TYPE_SETTINGS (tootle_settings_get_type ())
#define TOOTLE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_TYPE_SETTINGS, TootleSettings))
#define TOOTLE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_TYPE_SETTINGS, TootleSettingsClass))
#define TOOTLE_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_TYPE_SETTINGS))
#define TOOTLE_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_TYPE_SETTINGS))
#define TOOTLE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_TYPE_SETTINGS, TootleSettingsClass))

typedef struct _TootleSettings TootleSettings;
typedef struct _TootleSettingsClass TootleSettingsClass;

#define TOOTLE_TYPE_ENTITY (tootle_entity_get_type ())
#define TOOTLE_ENTITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_TYPE_ENTITY, TootleEntity))
#define TOOTLE_ENTITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_TYPE_ENTITY, TootleEntityClass))
#define TOOTLE_IS_ENTITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_TYPE_ENTITY))
#define TOOTLE_IS_ENTITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_TYPE_ENTITY))
#define TOOTLE_ENTITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_TYPE_ENTITY, TootleEntityClass))

typedef struct _TootleEntity TootleEntity;
typedef struct _TootleEntityClass TootleEntityClass;

#define TOOTLE_API_TYPE_STATUS (tootle_api_status_get_type ())
#define TOOTLE_API_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_API_TYPE_STATUS, TootleAPIStatus))
#define TOOTLE_API_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_API_TYPE_STATUS, TootleAPIStatusClass))
#define TOOTLE_API_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_API_TYPE_STATUS))
#define TOOTLE_API_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_API_TYPE_STATUS))
#define TOOTLE_API_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_API_TYPE_STATUS, TootleAPIStatusClass))

typedef struct _TootleAPIStatus TootleAPIStatus;
typedef struct _TootleAPIStatusClass TootleAPIStatusClass;
typedef struct _Block6Data Block6Data;
typedef struct _TootleStreamsConnectionPrivate TootleStreamsConnectionPrivate;
typedef struct _Block7Data Block7Data;

#define TOOTLE_API_TYPE_NOTIFICATION (tootle_api_notification_get_type ())
#define TOOTLE_API_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_API_TYPE_NOTIFICATION, TootleAPINotification))
#define TOOTLE_API_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_API_TYPE_NOTIFICATION, TootleAPINotificationClass))
#define TOOTLE_API_IS_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_API_TYPE_NOTIFICATION))
#define TOOTLE_API_IS_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_API_TYPE_NOTIFICATION))
#define TOOTLE_API_NOTIFICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_API_TYPE_NOTIFICATION, TootleAPINotificationClass))

typedef struct _TootleAPINotification TootleAPINotification;
typedef struct _TootleAPINotificationClass TootleAPINotificationClass;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
enum  {
	TOOTLE_STREAMS_CONNECTION_0_PROPERTY,
	TOOTLE_STREAMS_CONNECTION_NAME_PROPERTY,
	TOOTLE_STREAMS_CONNECTION_NUM_PROPERTIES
};
static GParamSpec* tootle_streams_connection_properties[TOOTLE_STREAMS_CONNECTION_NUM_PROPERTIES];

#define TOOTLE_TYPE_NETWORK (tootle_network_get_type ())
#define TOOTLE_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_TYPE_NETWORK, TootleNetwork))
#define TOOTLE_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_TYPE_NETWORK, TootleNetworkClass))
#define TOOTLE_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_TYPE_NETWORK))
#define TOOTLE_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_TYPE_NETWORK))
#define TOOTLE_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_TYPE_NETWORK, TootleNetworkClass))

typedef struct _TootleNetwork TootleNetwork;
typedef struct _TootleNetworkClass TootleNetworkClass;
typedef struct _TootleNetworkPrivate TootleNetworkPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _TootleStreams {
	GObject parent_instance;
	TootleStreamsPrivate * priv;
};

struct _TootleStreamsClass {
	GObjectClass parent_class;
};

struct _TootleStreamsPrivate {
	GHashTable* _connections;
};

struct _TootleIStreamListenerIface {
	GTypeInterface parent_iface;
};

struct _Block6Data {
	int _ref_count_;
	TootleAPIStatus* status;
};

typedef enum  {
	TOOTLE_OOPSIE_USER,
	TOOTLE_OOPSIE_PARSING,
	TOOTLE_OOPSIE_INSTANCE,
	TOOTLE_OOPSIE_INTERNAL
} TootleOopsie;
#define TOOTLE_OOPSIE tootle_oopsie_quark ()
struct _TootleStreamsConnection {
	GObject parent_instance;
	TootleStreamsConnectionPrivate * priv;
	GeeArrayList* subscribers;
	SoupWebsocketConnection* socket;
	SoupMessage* msg;
	gboolean closing;
	gint timeout;
};

struct _TootleStreamsConnectionClass {
	GObjectClass parent_class;
};

struct _Block7Data {
	int _ref_count_;
	gchar* id;
};

struct _Block8Data {
	int _ref_count_;
	TootleAPINotification* notif;
};

struct _Block9Data {
	int _ref_count_;
	TootleStreams* self;
	gchar* id;
};

struct _TootleNetwork {
	GObject parent_instance;
	TootleNetworkPrivate * priv;
	SoupSession* session;
};

struct _TootleNetworkClass {
	GObjectClass parent_class;
};

static gint TootleStreams_private_offset;
static gpointer tootle_streams_parent_class = NULL;
extern TootleSettings* tootle_settings;
static gpointer tootle_streams_connection_parent_class = NULL;
extern TootleNetwork* tootle_network;

GType tootle_streams_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleStreams, g_object_unref)
GType tootle_streams_connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleStreamsConnection, g_object_unref)
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
GType tootle_istream_listener_get_type (void) G_GNUC_CONST ;
void tootle_streams_subscribe (TootleStreams* self,
                               const gchar* url,
                               TootleIStreamListener* s,
                               gchar* * cookie);
GHashTable* tootle_streams_get_connections (TootleStreams* self);
void tootle_streams_connection_add (TootleStreamsConnection* self,
                                    TootleIStreamListener* s);
TootleStreamsConnection* tootle_streams_connection_new (const gchar* url);
TootleStreamsConnection* tootle_streams_connection_construct (GType object_type,
                                                              const gchar* url);
gboolean tootle_streams_connection_start (TootleStreamsConnection* self);
void tootle_streams_unsubscribe (TootleStreams* self,
                                 const gchar* cookie,
                                 TootleIStreamListener* s);
void tootle_streams_connection_remove (TootleStreamsConnection* self,
                                       TootleIStreamListener* s);
static gchar* tootle_streams_get_subscriber_name (GObject* s);
static void tootle_streams_decode (GBytes* bytes,
                            JsonNode* * root,
                            JsonObject* * obj,
                            gchar* * event,
                            GError** error);
static void _vala_JsonNode_free (JsonNode* self);
static JsonNode* tootle_streams_payload (JsonObject* obj);
static void tootle_streams_emit (GBytes* bytes,
                          TootleStreamsConnection* c,
                          GError** error);
GType tootle_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleSettings, g_object_unref)
gboolean tootle_settings_get_live_updates (TootleSettings* self);
GType tootle_entity_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleEntity, g_object_unref)
GType tootle_api_status_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleAPIStatus, g_object_unref)
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
GQuark tootle_oopsie_quark (void);
TootleEntity* tootle_entity_from_json (GType type,
                                       JsonNode* node,
                                       GError** error);
static gboolean ___lambda49_ (Block6Data* _data6_,
                       TootleIStreamListener* s);
static gboolean ____lambda49__gee_forall_func (gpointer g,
                                        gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean ___lambda50_ (Block7Data* _data7_,
                       TootleIStreamListener* s);
static gboolean ____lambda50__gee_forall_func (gpointer g,
                                        gpointer self);
GType tootle_api_notification_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleAPINotification, g_object_unref)
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static gboolean ___lambda52_ (Block8Data* _data8_,
                       TootleIStreamListener* s);
static gboolean ____lambda52__gee_forall_func (gpointer g,
                                        gpointer self);
void tootle_streams_force_delete (TootleStreams* self,
                                  const gchar* id);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda53_ (Block9Data* _data9_,
                  TootleStreamsConnection* c);
static gboolean __lambda54_ (Block9Data* _data9_,
                      TootleIStreamListener* s);
static gboolean ___lambda54__gee_forall_func (gpointer g,
                                       gpointer self);
static void ___lambda53__gfunc (gconstpointer data,
                         gpointer self);
TootleStreams* tootle_streams_new (void);
TootleStreams* tootle_streams_construct (GType object_type);
void tootle_streams_set_connections (TootleStreams* self,
                                     GHashTable* value);
gchar* tootle_streams_connection_get_name (TootleStreamsConnection* self);
GType tootle_network_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleNetwork, g_object_unref)
static void __lambda48_ (TootleStreamsConnection* self,
                  GObject* obj,
                  GAsyncResult* res);
static void tootle_streams_connection_on_error (TootleStreamsConnection* self,
                                         GError* e);
static void _tootle_streams_connection_on_error_soup_websocket_connection_error (SoupWebsocketConnection* _sender,
                                                                          GError* _error_,
                                                                          gpointer self);
static void tootle_streams_connection_on_closed (TootleStreamsConnection* self);
static void _tootle_streams_connection_on_closed_soup_websocket_connection_closed (SoupWebsocketConnection* _sender,
                                                                            gpointer self);
static void tootle_streams_connection_on_message (TootleStreamsConnection* self,
                                           gint i,
                                           GBytes* bytes);
static void _tootle_streams_connection_on_message_soup_websocket_connection_message (SoupWebsocketConnection* _sender,
                                                                              gint type,
                                                                              GBytes* message,
                                                                              gpointer self);
static void ___lambda48__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gboolean _tootle_streams_connection_start_gsource_func (gpointer self);
static void tootle_streams_connection_finalize (GObject * obj);
static GType tootle_streams_connection_get_type_once (void);
static void _vala_tootle_streams_connection_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void tootle_streams_finalize (GObject * obj);
static GType tootle_streams_get_type_once (void);
static void _vala_tootle_streams_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_tootle_streams_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
tootle_streams_get_instance_private (TootleStreams* self)
{
	return G_STRUCT_MEMBER_P (self, TootleStreams_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
tootle_streams_subscribe (TootleStreams* self,
                          const gchar* url,
                          TootleIStreamListener* s,
                          gchar* * cookie)
{
	gchar* _vala_cookie = NULL;
	GHashTable* _tmp0_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	if (url == NULL) {
		if (cookie) {
			*cookie = _vala_cookie;
		} else {
			_g_free0 (_vala_cookie);
		}
		return;
	}
	_tmp0_ = self->priv->_connections;
	if (g_hash_table_contains (_tmp0_, url)) {
		GHashTable* _tmp1_;
		gconstpointer _tmp2_;
		_tmp1_ = self->priv->_connections;
		_tmp2_ = g_hash_table_lookup (_tmp1_, url);
		tootle_streams_connection_add ((TootleStreamsConnection*) _tmp2_, s);
	} else {
		TootleStreamsConnection* con = NULL;
		TootleStreamsConnection* _tmp3_;
		GHashTable* _tmp4_;
		gchar* _tmp5_;
		TootleStreamsConnection* _tmp6_;
		TootleStreamsConnection* _tmp7_;
		TootleStreamsConnection* _tmp8_;
		TootleStreamsConnection* _tmp9_;
		_tmp3_ = tootle_streams_connection_new (url);
		con = _tmp3_;
		_tmp4_ = self->priv->_connections;
		_tmp5_ = g_strdup (url);
		_tmp6_ = con;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		g_hash_table_insert (_tmp4_, _tmp5_, _tmp7_);
		_tmp8_ = con;
		tootle_streams_connection_add (_tmp8_, s);
		_tmp9_ = con;
		tootle_streams_connection_start (_tmp9_);
		_g_object_unref0 (con);
	}
	_tmp10_ = g_strdup (url);
	_g_free0 (_vala_cookie);
	_vala_cookie = _tmp10_;
	if (cookie) {
		*cookie = _vala_cookie;
	} else {
		_g_free0 (_vala_cookie);
	}
}

void
tootle_streams_unsubscribe (TootleStreams* self,
                            const gchar* cookie,
                            TootleIStreamListener* s)
{
	gchar* url = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = g_strdup (cookie);
	url = _tmp0_;
	_tmp1_ = url;
	if (_tmp1_ == NULL) {
		_g_free0 (url);
		return;
	}
	_tmp2_ = self->priv->_connections;
	_tmp3_ = url;
	if (g_hash_table_contains (_tmp2_, _tmp3_)) {
		GHashTable* _tmp4_;
		const gchar* _tmp5_;
		gconstpointer _tmp6_;
		_tmp4_ = self->priv->_connections;
		_tmp5_ = url;
		_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
		tootle_streams_connection_remove ((TootleStreamsConnection*) _tmp6_, s);
	}
	_g_free0 (url);
}

static gchar*
tootle_streams_get_subscriber_name (GObject* s)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = g_type_name (G_TYPE_FROM_INSTANCE (s));
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static void
tootle_streams_decode (GBytes* bytes,
                       JsonNode* * root,
                       JsonObject* * obj,
                       gchar* * event,
                       GError** error)
{
	JsonNode* _vala_root = NULL;
	JsonObject* _vala_obj = NULL;
	gchar* _vala_event = NULL;
	gchar* msg = NULL;
	gsize _tmp0_ = 0;
	guint8* _tmp1_;
	gchar* _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonNode* _tmp4_;
	JsonNode* _tmp5_;
	JsonObject* _tmp6_;
	JsonObject* _tmp7_;
	JsonObject* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (bytes != NULL);
	_tmp1_ = g_bytes_get_data (bytes, &_tmp0_);
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	msg = _tmp2_;
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	json_parser_load_from_data (parser, msg, (gssize) -1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (parser);
		_g_free0 (msg);
		__vala_JsonNode_free0 (_vala_root);
		_json_object_unref0 (_vala_obj);
		_g_free0 (_vala_event);
		return;
	}
	_tmp4_ = json_parser_steal_root (parser);
	__vala_JsonNode_free0 (_vala_root);
	_vala_root = _tmp4_;
	_tmp5_ = _vala_root;
	_tmp6_ = json_node_get_object (_tmp5_);
	_tmp7_ = _json_object_ref0 (_tmp6_);
	_json_object_unref0 (_vala_obj);
	_vala_obj = _tmp7_;
	_tmp8_ = _vala_obj;
	_tmp9_ = json_object_get_string_member (_tmp8_, "event");
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (_vala_event);
	_vala_event = _tmp10_;
	_g_object_unref0 (parser);
	_g_free0 (msg);
	if (root) {
		*root = _vala_root;
	} else {
		__vala_JsonNode_free0 (_vala_root);
	}
	if (obj) {
		*obj = _vala_obj;
	} else {
		_json_object_unref0 (_vala_obj);
	}
	if (event) {
		*event = _vala_event;
	} else {
		_g_free0 (_vala_event);
	}
}

static JsonNode*
tootle_streams_payload (JsonObject* obj)
{
	gchar* payload = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* data = NULL;
	gchar* _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp3_;
	JsonNode* _tmp4_;
	GError* _inner_error0_ = NULL;
	JsonNode* result = NULL;
	g_return_val_if_fail (obj != NULL, NULL);
	_tmp0_ = json_object_get_string_member (obj, "payload");
	_tmp1_ = g_strdup (_tmp0_);
	payload = _tmp1_;
	_tmp2_ = soup_uri_decode (payload);
	data = _tmp2_;
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	json_parser_load_from_data (parser, data, (gssize) -1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		_g_free0 (data);
		_g_free0 (payload);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp4_ = json_parser_steal_root (parser);
	result = _tmp4_;
	_g_object_unref0 (parser);
	_g_free0 (data);
	_g_free0 (payload);
	return result;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->status);
		g_slice_free (Block6Data, _data6_);
	}
}

static gboolean
___lambda49_ (Block6Data* _data6_,
              TootleIStreamListener* s)
{
	TootleAPIStatus* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (s != NULL, FALSE);
	_tmp0_ = _data6_->status;
	g_signal_emit_by_name (s, "on-status-added", _tmp0_);
	result = TRUE;
	_g_object_unref0 (s);
	return result;
}

static gboolean
____lambda49__gee_forall_func (gpointer g,
                               gpointer self)
{
	gboolean result;
	result = ___lambda49_ (self, (TootleIStreamListener*) g);
	return result;
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_free0 (_data7_->id);
		g_slice_free (Block7Data, _data7_);
	}
}

static gboolean
___lambda50_ (Block7Data* _data7_,
              TootleIStreamListener* s)
{
	const gchar* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (s != NULL, FALSE);
	_tmp0_ = _data7_->id;
	g_signal_emit_by_name (s, "on-status-removed", _tmp0_);
	result = TRUE;
	_g_object_unref0 (s);
	return result;
}

static gboolean
____lambda50__gee_forall_func (gpointer g,
                               gpointer self)
{
	gboolean result;
	result = ___lambda50_ (self, (TootleIStreamListener*) g);
	return result;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		_g_object_unref0 (_data8_->notif);
		g_slice_free (Block8Data, _data8_);
	}
}

static gboolean
___lambda52_ (Block8Data* _data8_,
              TootleIStreamListener* s)
{
	TootleAPINotification* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (s != NULL, FALSE);
	_tmp0_ = _data8_->notif;
	g_signal_emit_by_name (s, "on-notification", _tmp0_);
	result = TRUE;
	_g_object_unref0 (s);
	return result;
}

static gboolean
____lambda52__gee_forall_func (gpointer g,
                               gpointer self)
{
	gboolean result;
	result = ___lambda52_ (self, (TootleIStreamListener*) g);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
tootle_streams_emit (GBytes* bytes,
                     TootleStreamsConnection* c,
                     GError** error)
{
	TootleSettings* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	JsonNode* root = NULL;
	JsonObject* root_obj = NULL;
	gchar* ev = NULL;
	JsonNode* _tmp3_ = NULL;
	JsonObject* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GQuark _tmp9_ = 0U;
	static GQuark _tmp8_label0 = 0;
	static GQuark _tmp8_label1 = 0;
	static GQuark _tmp8_label2 = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (bytes != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = tootle_settings;
	_tmp1_ = tootle_settings_get_live_updates (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	tootle_streams_decode (bytes, &_tmp3_, &_tmp4_, &_tmp5_, &_inner_error0_);
	__vala_JsonNode_free0 (root);
	root = _tmp3_;
	_json_object_unref0 (root_obj);
	root_obj = _tmp4_;
	_g_free0 (ev);
	ev = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (ev);
		_json_object_unref0 (root_obj);
		__vala_JsonNode_free0 (root);
		return;
	}
	_tmp6_ = ev;
	_tmp7_ = _tmp6_;
	_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
	if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("update")))) {
		switch (0) {
			default:
			{
				Block6Data* _data6_;
				JsonNode* node = NULL;
				JsonObject* _tmp10_;
				JsonNode* _tmp11_;
				TootleEntity* _tmp12_ = NULL;
				JsonNode* _tmp13_;
				TootleEntity* _tmp14_;
				TootleAPIStatus* _tmp15_;
				GeeArrayList* _tmp16_;
				_data6_ = g_slice_new0 (Block6Data);
				_data6_->_ref_count_ = 1;
				_tmp10_ = root_obj;
				_tmp11_ = tootle_streams_payload (_tmp10_);
				node = _tmp11_;
				_tmp13_ = node;
				_tmp14_ = tootle_entity_from_json (TOOTLE_API_TYPE_STATUS, _tmp13_, &_inner_error0_);
				_tmp12_ = _tmp14_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					__vala_JsonNode_free0 (node);
					block6_data_unref (_data6_);
					_data6_ = NULL;
					_g_free0 (ev);
					_json_object_unref0 (root_obj);
					__vala_JsonNode_free0 (root);
					return;
				}
				_tmp15_ = _g_object_ref0 (TOOTLE_API_IS_STATUS (_tmp12_) ? ((TootleAPIStatus*) _tmp12_) : NULL);
				_data6_->status = _tmp15_;
				_tmp16_ = c->subscribers;
				gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp16_, ____lambda49__gee_forall_func, _data6_);
				_g_object_unref0 (_tmp12_);
				__vala_JsonNode_free0 (node);
				block6_data_unref (_data6_);
				_data6_ = NULL;
				break;
			}
		}
	} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("delete")))) {
		switch (0) {
			default:
			{
				Block7Data* _data7_;
				JsonObject* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				GeeArrayList* _tmp20_;
				_data7_ = g_slice_new0 (Block7Data);
				_data7_->_ref_count_ = 1;
				_tmp17_ = root_obj;
				_tmp18_ = json_object_get_string_member (_tmp17_, "payload");
				_tmp19_ = g_strdup (_tmp18_);
				_data7_->id = _tmp19_;
				_tmp20_ = c->subscribers;
				gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp20_, ____lambda50__gee_forall_func, _data7_);
				block7_data_unref (_data7_);
				_data7_ = NULL;
				break;
			}
		}
	} else if (_tmp9_ == ((0 != _tmp8_label2) ? _tmp8_label2 : (_tmp8_label2 = g_quark_from_static_string ("notification")))) {
		switch (0) {
			default:
			{
				Block8Data* _data8_;
				JsonNode* node = NULL;
				JsonObject* _tmp21_;
				JsonNode* _tmp22_;
				TootleEntity* _tmp23_ = NULL;
				JsonNode* _tmp24_;
				TootleEntity* _tmp25_;
				TootleAPINotification* _tmp26_;
				GeeArrayList* _tmp27_;
				_data8_ = g_slice_new0 (Block8Data);
				_data8_->_ref_count_ = 1;
				_tmp21_ = root_obj;
				_tmp22_ = tootle_streams_payload (_tmp21_);
				node = _tmp22_;
				_tmp24_ = node;
				_tmp25_ = tootle_entity_from_json (TOOTLE_API_TYPE_NOTIFICATION, _tmp24_, &_inner_error0_);
				_tmp23_ = _tmp25_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					__vala_JsonNode_free0 (node);
					block8_data_unref (_data8_);
					_data8_ = NULL;
					_g_free0 (ev);
					_json_object_unref0 (root_obj);
					__vala_JsonNode_free0 (root);
					return;
				}
				_tmp26_ = _g_object_ref0 (TOOTLE_API_IS_NOTIFICATION (_tmp23_) ? ((TootleAPINotification*) _tmp23_) : NULL);
				_data8_->notif = _tmp26_;
				_tmp27_ = c->subscribers;
				gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp27_, ____lambda52__gee_forall_func, _data8_);
				_g_object_unref0 (_tmp23_);
				__vala_JsonNode_free0 (node);
				block8_data_unref (_data8_);
				_data8_ = NULL;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp28_ = ev;
				_tmp29_ = string_to_string (_tmp28_);
				_tmp30_ = g_strconcat ("Unknown websocket event: \"", _tmp29_, "\". Ignoring.", NULL);
				_tmp31_ = _tmp30_;
				g_warning ("Streams.vala:170: %s", _tmp31_);
				_g_free0 (_tmp31_);
				break;
			}
		}
	}
	_g_free0 (ev);
	_json_object_unref0 (root_obj);
	__vala_JsonNode_free0 (root);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		TootleStreams* self;
		self = _data9_->self;
		_g_free0 (_data9_->id);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static gboolean
__lambda54_ (Block9Data* _data9_,
             TootleIStreamListener* s)
{
	TootleStreams* self;
	gboolean result = FALSE;
	self = _data9_->self;
	g_return_val_if_fail (s != NULL, FALSE);
	g_signal_emit_by_name (s, "on-status-removed", _data9_->id);
	result = TRUE;
	_g_object_unref0 (s);
	return result;
}

static gboolean
___lambda54__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda54_ (self, (TootleIStreamListener*) g);
	return result;
}

static void
__lambda53_ (Block9Data* _data9_,
             TootleStreamsConnection* c)
{
	TootleStreams* self;
	GeeArrayList* _tmp0_;
	self = _data9_->self;
	g_return_if_fail (c != NULL);
	_tmp0_ = c->subscribers;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp0_, ___lambda54__gee_forall_func, _data9_);
}

static void
___lambda53__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda53_ (self, (TootleStreamsConnection*) data);
}

void
tootle_streams_force_delete (TootleStreams* self,
                             const gchar* id)
{
	Block9Data* _data9_;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = g_strdup (id);
	_g_free0 (_data9_->id);
	_data9_->id = _tmp0_;
	_tmp1_ = self->priv->_connections;
	_tmp2_ = g_hash_table_get_values (_tmp1_);
	_tmp3_ = _tmp2_;
	g_list_foreach (_tmp3_, ___lambda53__gfunc, _data9_);
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (g_list_free (_tmp3_), NULL));
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

TootleStreams*
tootle_streams_construct (GType object_type)
{
	TootleStreams * self = NULL;
	self = (TootleStreams*) g_object_new (object_type, NULL);
	return self;
}

TootleStreams*
tootle_streams_new (void)
{
	return tootle_streams_construct (TOOTLE_TYPE_STREAMS);
}

GHashTable*
tootle_streams_get_connections (TootleStreams* self)
{
	GHashTable* result;
	GHashTable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connections;
	result = _tmp0_;
	return result;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

void
tootle_streams_set_connections (TootleStreams* self,
                                GHashTable* value)
{
	GHashTable* old_value;
	g_return_if_fail (self != NULL);
	old_value = tootle_streams_get_connections (self);
	if (old_value != value) {
		GHashTable* _tmp0_;
		_tmp0_ = _g_hash_table_ref0 (value);
		_g_hash_table_unref0 (self->priv->_connections);
		self->priv->_connections = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tootle_streams_properties[TOOTLE_STREAMS_CONNECTIONS_PROPERTY]);
	}
}

TootleStreamsConnection*
tootle_streams_connection_construct (GType object_type,
                                     const gchar* url)
{
	TootleStreamsConnection * self = NULL;
	GeeArrayList* _tmp0_;
	SoupMessage* _tmp1_;
	g_return_val_if_fail (url != NULL, NULL);
	self = (TootleStreamsConnection*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (TOOTLE_TYPE_ISTREAM_LISTENER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->subscribers);
	self->subscribers = _tmp0_;
	_tmp1_ = soup_message_new ("GET", url);
	_g_object_unref0 (self->msg);
	self->msg = _tmp1_;
	return self;
}

TootleStreamsConnection*
tootle_streams_connection_new (const gchar* url)
{
	return tootle_streams_connection_construct (TOOTLE_STREAMS_TYPE_CONNECTION, url);
}

static void
_tootle_streams_connection_on_error_soup_websocket_connection_error (SoupWebsocketConnection* _sender,
                                                                     GError* _error_,
                                                                     gpointer self)
{
	tootle_streams_connection_on_error ((TootleStreamsConnection*) self, _error_);
}

static void
_tootle_streams_connection_on_closed_soup_websocket_connection_closed (SoupWebsocketConnection* _sender,
                                                                       gpointer self)
{
	tootle_streams_connection_on_closed ((TootleStreamsConnection*) self);
}

static void
_tootle_streams_connection_on_message_soup_websocket_connection_message (SoupWebsocketConnection* _sender,
                                                                         gint type,
                                                                         GBytes* message,
                                                                         gpointer self)
{
	tootle_streams_connection_on_message ((TootleStreamsConnection*) self, type, message);
}

static void
__lambda48_ (TootleStreamsConnection* self,
             GObject* obj,
             GAsyncResult* res)
{
	SoupWebsocketConnection* _tmp0_ = NULL;
	TootleNetwork* _tmp1_;
	SoupSession* _tmp2_;
	SoupWebsocketConnection* _tmp3_;
	SoupWebsocketConnection* _tmp4_;
	SoupWebsocketConnection* _tmp5_;
	SoupWebsocketConnection* _tmp6_;
	SoupWebsocketConnection* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	_tmp1_ = tootle_network;
	_tmp2_ = _tmp1_->session;
	_tmp3_ = soup_session_websocket_connect_finish (_tmp2_, res, &_inner_error0_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->socket);
	self->socket = _tmp4_;
	_tmp5_ = self->socket;
	g_signal_connect_object (_tmp5_, "error", (GCallback) _tootle_streams_connection_on_error_soup_websocket_connection_error, self, 0);
	_tmp6_ = self->socket;
	g_signal_connect_object (_tmp6_, "closed", (GCallback) _tootle_streams_connection_on_closed_soup_websocket_connection_closed, self, 0);
	_tmp7_ = self->socket;
	g_signal_connect_object (_tmp7_, "message", (GCallback) _tootle_streams_connection_on_message_soup_websocket_connection_message, self, 0);
	_g_object_unref0 (_tmp0_);
}

static void
___lambda48__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda48_ ((TootleStreamsConnection*) self, source_object, res);
	g_object_unref (self);
}

gboolean
tootle_streams_connection_start (TootleStreamsConnection* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	TootleNetwork* _tmp6_;
	SoupSession* _tmp7_;
	SoupMessage* _tmp8_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tootle_streams_connection_get_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = g_strconcat ("Opening stream: ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	g_info ("Streams.vala:33: %s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	_tmp6_ = tootle_network;
	_tmp7_ = _tmp6_->session;
	_tmp8_ = self->msg;
	soup_session_websocket_connect_async (_tmp7_, _tmp8_, NULL, NULL, NULL, ___lambda48__gasync_ready_callback, g_object_ref (self));
	result = FALSE;
	return result;
}

void
tootle_streams_connection_add (TootleStreamsConnection* self,
                               TootleIStreamListener* s)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GeeArrayList* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = tootle_streams_get_subscriber_name ((GObject*) s);
	_tmp1_ = _tmp0_;
	_tmp2_ = tootle_streams_connection_get_name (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	g_info ("Streams.vala:44: %s > %s", _tmp1_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
	_tmp5_ = self->subscribers;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, s);
}

void
tootle_streams_connection_remove (TootleStreamsConnection* self,
                                  TootleIStreamListener* s)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = self->subscribers;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, s)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GeeArrayList* _tmp6_;
		_tmp1_ = tootle_streams_get_subscriber_name ((GObject*) s);
		_tmp2_ = _tmp1_;
		_tmp3_ = tootle_streams_connection_get_name (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		g_info ("Streams.vala:50: %s X %s", _tmp2_, _tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp2_);
		_tmp6_ = self->subscribers;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp6_, s);
	}
	_tmp7_ = self->subscribers;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ <= 0) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		SoupWebsocketConnection* _tmp16_;
		_tmp10_ = tootle_streams_connection_get_name (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat ("Closing: ", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		g_info ("Streams.vala:55: %s", _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp12_);
		self->closing = TRUE;
		_tmp16_ = self->socket;
		soup_websocket_connection_close (_tmp16_, (gushort) 0, NULL);
	}
}

static void
tootle_streams_connection_on_error (TootleStreamsConnection* self,
                                    GError* e)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (e != NULL);
	if (!self->closing) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp0_ = tootle_streams_connection_get_name (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = e->message;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("Error in ", _tmp3_, ": ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		g_warning ("Streams.vala:63: %s", _tmp7_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp2_);
	}
}

static gboolean
_tootle_streams_connection_start_gsource_func (gpointer self)
{
	gboolean result;
	result = tootle_streams_connection_start ((TootleStreamsConnection*) self);
	return result;
}

static void
tootle_streams_connection_on_closed (TootleStreamsConnection* self)
{
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	if (!self->closing) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp0_ = tootle_streams_connection_get_name (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strdup_printf ("%i", self->timeout);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat ("DISCONNECTED: ", _tmp3_, ". Reconnecting in ", _tmp5_, " seconds.", NULL);
		_tmp7_ = _tmp6_;
		g_warning ("Streams.vala:68: %s", _tmp7_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp2_);
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) self->timeout, _tootle_streams_connection_start_gsource_func, g_object_ref (self), g_object_unref);
		self->timeout = MIN (self->timeout * 2, 6);
	}
	_tmp8_ = tootle_streams_connection_get_name (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = g_strconcat ("Closing stream: ", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	g_warning ("Streams.vala:72: %s", _tmp13_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp10_);
}

static void
tootle_streams_connection_on_message (TootleStreamsConnection* self,
                                      gint i,
                                      GBytes* bytes)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bytes != NULL);
	{
		tootle_streams_emit (bytes, self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		_tmp2_ = string_to_string (_tmp1_);
		_tmp3_ = g_strconcat ("Couldn't handle websocket event. Reason: ", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		g_warning ("Streams.vala:80: %s", _tmp4_);
		_g_free0 (_tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gchar*
tootle_streams_connection_get_name (TootleStreamsConnection* self)
{
	gchar* result;
	gchar* url = NULL;
	SoupMessage* _tmp0_;
	SoupURI* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->msg;
	_tmp1_ = soup_message_get_uri (_tmp0_);
	_tmp2_ = soup_uri_to_string (_tmp1_, FALSE);
	url = _tmp2_;
	_tmp3_ = string_slice (url, (glong) 0, (glong) string_last_index_of (url, "&access_token", 0));
	result = _tmp3_;
	_g_free0 (url);
	return result;
}

static void
tootle_streams_connection_class_init (TootleStreamsConnectionClass * klass,
                                      gpointer klass_data)
{
	tootle_streams_connection_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_tootle_streams_connection_get_property;
	G_OBJECT_CLASS (klass)->finalize = tootle_streams_connection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TOOTLE_STREAMS_CONNECTION_NAME_PROPERTY, tootle_streams_connection_properties[TOOTLE_STREAMS_CONNECTION_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
tootle_streams_connection_instance_init (TootleStreamsConnection * self,
                                         gpointer klass)
{
	self->closing = FALSE;
	self->timeout = 1;
}

static void
tootle_streams_connection_finalize (GObject * obj)
{
	TootleStreamsConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TOOTLE_STREAMS_TYPE_CONNECTION, TootleStreamsConnection);
	_g_object_unref0 (self->subscribers);
	_g_object_unref0 (self->socket);
	_g_object_unref0 (self->msg);
	G_OBJECT_CLASS (tootle_streams_connection_parent_class)->finalize (obj);
}

static GType
tootle_streams_connection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TootleStreamsConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tootle_streams_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TootleStreamsConnection), 0, (GInstanceInitFunc) tootle_streams_connection_instance_init, NULL };
	GType tootle_streams_connection_type_id;
	tootle_streams_connection_type_id = g_type_register_static (G_TYPE_OBJECT, "TootleStreamsConnection", &g_define_type_info, 0);
	return tootle_streams_connection_type_id;
}

GType
tootle_streams_connection_get_type (void)
{
	static volatile gsize tootle_streams_connection_type_id__volatile = 0;
	if (g_once_init_enter (&tootle_streams_connection_type_id__volatile)) {
		GType tootle_streams_connection_type_id;
		tootle_streams_connection_type_id = tootle_streams_connection_get_type_once ();
		g_once_init_leave (&tootle_streams_connection_type_id__volatile, tootle_streams_connection_type_id);
	}
	return tootle_streams_connection_type_id__volatile;
}

static void
_vala_tootle_streams_connection_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	TootleStreamsConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TOOTLE_STREAMS_TYPE_CONNECTION, TootleStreamsConnection);
	switch (property_id) {
		case TOOTLE_STREAMS_CONNECTION_NAME_PROPERTY:
		g_value_take_string (value, tootle_streams_connection_get_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
tootle_streams_class_init (TootleStreamsClass * klass,
                           gpointer klass_data)
{
	tootle_streams_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TootleStreams_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_tootle_streams_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tootle_streams_set_property;
	G_OBJECT_CLASS (klass)->finalize = tootle_streams_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TOOTLE_STREAMS_CONNECTIONS_PROPERTY, tootle_streams_properties[TOOTLE_STREAMS_CONNECTIONS_PROPERTY] = g_param_spec_boxed ("connections", "connections", "connections", G_TYPE_HASH_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
tootle_streams_instance_init (TootleStreams * self,
                              gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	self->priv = tootle_streams_get_instance_private (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	self->priv->_connections = _tmp2_;
}

static void
tootle_streams_finalize (GObject * obj)
{
	TootleStreams * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TOOTLE_TYPE_STREAMS, TootleStreams);
	_g_hash_table_unref0 (self->priv->_connections);
	G_OBJECT_CLASS (tootle_streams_parent_class)->finalize (obj);
}

static GType
tootle_streams_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TootleStreamsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tootle_streams_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TootleStreams), 0, (GInstanceInitFunc) tootle_streams_instance_init, NULL };
	GType tootle_streams_type_id;
	tootle_streams_type_id = g_type_register_static (G_TYPE_OBJECT, "TootleStreams", &g_define_type_info, 0);
	TootleStreams_private_offset = g_type_add_instance_private (tootle_streams_type_id, sizeof (TootleStreamsPrivate));
	return tootle_streams_type_id;
}

GType
tootle_streams_get_type (void)
{
	static volatile gsize tootle_streams_type_id__volatile = 0;
	if (g_once_init_enter (&tootle_streams_type_id__volatile)) {
		GType tootle_streams_type_id;
		tootle_streams_type_id = tootle_streams_get_type_once ();
		g_once_init_leave (&tootle_streams_type_id__volatile, tootle_streams_type_id);
	}
	return tootle_streams_type_id__volatile;
}

static void
_vala_tootle_streams_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	TootleStreams * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TOOTLE_TYPE_STREAMS, TootleStreams);
	switch (property_id) {
		case TOOTLE_STREAMS_CONNECTIONS_PROPERTY:
		g_value_set_boxed (value, tootle_streams_get_connections (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tootle_streams_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	TootleStreams * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TOOTLE_TYPE_STREAMS, TootleStreams);
	switch (property_id) {
		case TOOTLE_STREAMS_CONNECTIONS_PROPERTY:
		tootle_streams_set_connections (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

