/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.documentation;

import VASSAL.Info;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.i18n.Resources;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.AboutWindow;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AboutScreen
extends AbstractConfigurable {
    protected ImageOp op;
    protected Image image;
    protected String title;
    protected String fileName;
    protected Action launch = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            AboutScreen.this.launch();
        }
    };
    public static final String TITLE = "title";
    public static final String FILE = "fileName";

    public AboutScreen() {
    }

    public AboutScreen(ImageOp imageOp) {
        this();
        if (imageOp == null) {
            throw new IllegalArgumentException();
        }
        this.op = imageOp;
    }

    @Deprecated
    public AboutScreen(Image image) {
        this();
        this.op = Op.load(ImageUtils.toBufferedImage(image));
    }

    public void launch() {
        if (this.op == null) {
            return;
        }
        GameModule gameModule = GameModule.getGameModule();
        if (gameModule == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("<html><center>");
        stringBuilder.append(Resources.getString("AboutScreen.module_version", gameModule.getLocalizedGameName(), gameModule.getGameVersion()));
        for (ModuleExtension moduleExtension : gameModule.getComponentsOf(ModuleExtension.class)) {
            stringBuilder.append("<br/>").append(Resources.getString("AboutScreen.extension_version", moduleExtension.getName(), moduleExtension.getVersion()));
        }
        stringBuilder.append("<br/>").append(Resources.getString("AboutScreen.vassal_version", Info.getVersion()));
        stringBuilder.append("</center></html>");
        AboutWindow aboutWindow = new AboutWindow(gameModule.getFrame(), this.op.getImage(), stringBuilder.toString());
        aboutWindow.setVisible(true);
        aboutWindow.toFront();
    }

    public static String getConfigureTypeName() {
        return "About Screen";
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{TITLE, FILE};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Menu Entry:  ", "Image:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Image.class};
    }

    @Override
    public String getAttributeValueString(String string) {
        if (TITLE.equals(string)) {
            return this.title;
        }
        if (FILE.equals(string)) {
            return this.fileName;
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (TITLE.equals(string)) {
            this.title = (String)object;
            if (this.title != null && this.title.equals(Resources.getString("AboutScreen.about_vassal"))) {
                this.title = Resources.getString("Documentation.about_module");
            }
            this.setConfigureName(this.title);
            this.launch.putValue("Name", this.title);
        } else if (FILE.equals(string)) {
            if (object instanceof File) {
                object = ((File)object).getName();
            }
            this.fileName = (String)object;
            this.op = null;
            if (this.fileName != null) {
                this.fileName = this.fileName.trim();
                if (this.fileName.length() > 0) {
                    this.op = Op.load(this.fileName);
                    BufferedImage bufferedImage = this.op.getImage();
                    if (bufferedImage != null) {
                        GameModule.getGameModule().getWizardSupport().setBackgroundImage(this.op.getImage());
                    } else {
                        this.op = null;
                    }
                }
            }
        }
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void removeFrom(Buildable buildable) {
        MenuManager.getInstance().removeAction("Documentation.about_module");
    }

    @Override
    public void addTo(Buildable buildable) {
        MenuManager.getInstance().addAction("Documentation.about_module", this.launch);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("HelpMenu.htm", "AboutScreen");
    }
}

