/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.documentation;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.menu.MenuItemProxy;
import VASSAL.tools.menu.MenuManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jdesktop.swingworker.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tutorial
extends AbstractConfigurable {
    private static final Logger logger = LoggerFactory.getLogger(Tutorial.class);
    public static final String FILE_NAME = "logfile";
    public static final String NAME = "name";
    public static final String LAUNCH_ON_STARTUP = "launchOnStartup";
    public static final String PROMPT_MESSAGE = "promptMessage";
    public static final String WELCOME_MESSAGE = "welcomeMessage";
    private String fileName;
    private Action launch;
    private boolean launchOnFirstStartup;
    private String welcomeMessage = Resources.getString("Tutorial.instructions");
    private String promptMessage = Resources.getString("Tutorial.load_tutorial");
    protected BooleanConfigurer hasViewedTutorial;
    protected MenuItemProxy launchItem;

    public Tutorial() {
        this.launch = new AbstractAction(Resources.getString("Tutorial.tutorial")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                Tutorial.this.launch();
            }
        };
    }

    public void launch() {
        GameModule.getGameModule().warn(Resources.getString("Tutorial.Tutorial.loading"));
        new SwingWorker<Command, Void>(){

            public Command doInBackground() throws Exception {
                return Tutorial.this.getTutorialCommand();
            }

            protected void done() {
                Command command = null;
                String string = null;
                try {
                    command = (Command)this.get();
                }
                catch (InterruptedException interruptedException) {
                    ErrorDialog.bug(interruptedException);
                }
                catch (ExecutionException executionException) {
                    logger.error("", (Throwable)executionException);
                    String string2 = Resources.getString("Tutorial.unable_to_launch", Tutorial.this.name);
                    if (executionException.getMessage() != null) {
                        string2 = string2 + ":  " + executionException.getMessage();
                    }
                    string = string2;
                }
                if (command != null) {
                    command.execute();
                    if (Tutorial.this.welcomeMessage != null && Tutorial.this.welcomeMessage.length() > 0) {
                        GameModule.getGameModule().warn(Tutorial.this.welcomeMessage);
                    }
                } else {
                    GameModule.getGameModule().warn(string);
                }
            }
        }.execute();
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Menu Text", "Logfile", "Launch automatically on first startup", "Auto-launch confirm message", "Welcome message"};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, File.class, Boolean.class, String.class, String.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, FILE_NAME, LAUNCH_ON_STARTUP, PROMPT_MESSAGE, WELCOME_MESSAGE};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (string.equals(PROMPT_MESSAGE)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return Tutorial.this.launchOnFirstStartup;
                }
            };
        }
        return null;
    }

    @Override
    public String getAttributeValueString(String string) {
        if (FILE_NAME.equals(string)) {
            return this.fileName;
        }
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (LAUNCH_ON_STARTUP.equals(string)) {
            return String.valueOf(this.launchOnFirstStartup);
        }
        if (PROMPT_MESSAGE.equals(string)) {
            return this.promptMessage;
        }
        if (WELCOME_MESSAGE.equals(string)) {
            return this.welcomeMessage;
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (FILE_NAME.equals(string)) {
            if (object instanceof File) {
                object = ((File)object).getName();
            }
            this.fileName = (String)object;
        } else if (NAME.equals(string)) {
            this.launch.putValue("Name", object);
            this.setConfigureName((String)object);
        } else if (LAUNCH_ON_STARTUP.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.launchOnFirstStartup = (Boolean)object;
        } else if (PROMPT_MESSAGE.equals(string)) {
            this.promptMessage = (String)object;
        } else if (WELCOME_MESSAGE.equals(string)) {
            this.welcomeMessage = (String)object;
        }
    }

    @Override
    public void addTo(Buildable buildable) {
        this.launchItem = new MenuItemProxy(this.launch);
        MenuManager.getInstance().addToSection("Documentation.Module", this.launchItem);
        String string = "viewedTutorial" + this.getConfigureName();
        this.hasViewedTutorial = new BooleanConfigurer(string, null, Boolean.FALSE);
        GameModule.getGameModule().getPrefs().addOption(null, this.hasViewedTutorial);
        GameModule.getGameModule().getWizardSupport().setTutorial(this);
    }

    @Override
    public void removeFrom(Buildable buildable) {
        MenuManager.getInstance().removeFromSection("Documentation.Module", this.launchItem);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("HelpMenu.htm", "Tutorial");
    }

    public Command getTutorialCommand() throws IOException {
        return GameModule.getGameModule().getGameState().decodeSavedGame(this.getTutorialContents());
    }

    public InputStream getTutorialContents() throws IOException {
        if (this.fileName == null) {
            throw new FileNotFoundException("Tutorial has null filename");
        }
        return GameModule.getGameModule().getDataArchive().getInputStream(this.fileName);
    }

    public boolean isFirstRun() {
        return this.launchOnFirstStartup && this.hasViewedTutorial.booleanValue() == false;
    }

    public void markAsViewed() {
        this.hasViewedTutorial.setValue(Boolean.TRUE);
    }

    public String getWelcomeMessage() {
        return this.welcomeMessage;
    }
}

