/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.ColorSwatchConfigurer;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class NewColorConfigurer
extends Configurer {
    private JPanel p;
    private Panel cp;
    protected Box colorBox;
    protected Box swatchBox;
    BooleanConfigurer bc;
    ColorSwatchConfigurer csc;

    public NewColorConfigurer(String string, String string2) {
        this(string, string2, Color.black);
    }

    public NewColorConfigurer(String string, String string2, Color color) {
        super(string, string2, color);
    }

    public String getValueString() {
        return this.value == null ? "" : NewColorConfigurer.colorToString(this.colorValue());
    }

    public void setValue(Object object) {
        super.setValue(object);
        if (this.cp != null) {
            this.cp.repaint();
        }
    }

    public void setValue(String string) {
        this.setValue(NewColorConfigurer.stringToColor(string));
    }

    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 1));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Use Named Colors?"));
            this.bc = new BooleanConfigurer(null, "", Boolean.FALSE);
            box.add(this.bc.getControls());
            this.bc.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    NewColorConfigurer.this.colorBox.setVisible(NewColorConfigurer.this.bc.booleanValue() == false);
                    NewColorConfigurer.this.swatchBox.setVisible(NewColorConfigurer.this.bc.booleanValue());
                    SwingUtilities.getWindowAncestor(NewColorConfigurer.this.bc.getControls()).pack();
                }
            });
            this.p.add(box);
            this.colorBox = Box.createHorizontalBox();
            this.colorBox.add(new JLabel(this.getName()));
            this.cp = new Panel();
            this.cp.setMaximumSize(new Dimension(40, 40));
            this.cp.setMinimumSize(new Dimension(40, 40));
            this.cp.setSize(new Dimension(40, 40));
            this.colorBox.add(this.cp);
            JButton jButton = new JButton("Select");
            this.colorBox.add(jButton);
            this.p.add(this.colorBox);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NewColorConfigurer.this.setValue(JColorChooser.showDialog(null, NewColorConfigurer.this.getName(), NewColorConfigurer.this.colorValue()));
                    NewColorConfigurer.this.csc.setValue(new ColorSwatch("", (Color)NewColorConfigurer.this.getValue()));
                }
            });
            this.swatchBox = Box.createHorizontalBox();
            this.csc = new ColorSwatchConfigurer(null, "Select Color:", "WHITE");
            this.csc.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    NewColorConfigurer.this.setValue(NewColorConfigurer.this.csc.getValueColor());
                }
            });
            this.swatchBox.add(this.csc.getControls());
            this.swatchBox.setVisible(false);
            this.p.add(this.swatchBox);
        }
        return this.p;
    }

    private Color colorValue() {
        return (Color)this.value;
    }

    public static String colorToString(Color color) {
        return color == null ? null : color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    public static Color stringToColor(String string) {
        if (string == null || "null".equals(string)) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        try {
            return new Color(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private class Panel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private Panel() {
        }

        public void paint(Graphics graphics) {
            if (NewColorConfigurer.this.colorValue() != null) {
                graphics.setColor(NewColorConfigurer.this.colorValue());
                graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            } else {
                graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
            }
        }
    }
}

