/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.Region;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridContainer;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridNumbering;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.Configurer;
import VASSAL.configure.EditPropertiesAction;
import VASSAL.configure.PropertiesWindow;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.tools.AdjustableSpeedScrollPane;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.ImageUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionGrid
extends AbstractConfigurable
implements MapGrid,
ConfigureTree.Mutable {
    private static final long serialVersionUID = 1L;
    protected Map<Point, Region> regionList = new HashMap<Point, Region>();
    protected GridContainer container;
    protected boolean visible = false;
    protected static boolean inConfig = false;
    protected int fontSize = 9;
    protected boolean snapTo = true;
    protected Config regionConfigurer;
    protected GridNumbering gridNumbering;
    RegionGrid me = this;
    public static final String SNAPTO = "snapto";
    public static final String VISIBLE = "visible";
    public static final String FONT_SIZE = "fontsize";

    public void addRegion(Region region) {
        this.regionList.put(region.getOrigin(), region);
        if (inConfig && this.regionConfigurer != null) {
            this.regionConfigurer.view.repaint();
        }
    }

    public void removeRegion(Region region) {
        this.regionList.remove(region.getOrigin());
    }

    public void removeAllRegions() {
        this.regionList.clear();
        this.buildComponents.clear();
    }

    @Override
    public GridNumbering getGridNumbering() {
        return this.gridNumbering;
    }

    public void setGridNumbering(GridNumbering gridNumbering) {
        this.gridNumbering = gridNumbering;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{SNAPTO, VISIBLE, FONT_SIZE};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.Grid.snap"), Resources.getString("Editor.IrregularGrid.draw"), Resources.getString("Editor.IrregularGrid.fonts")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{Boolean.class, Boolean.class, Integer.class};
    }

    @Override
    public Configurer getConfigurer() {
        boolean bl = this.config != null;
        Configurer configurer = super.getConfigurer();
        if (!bl) {
            JButton jButton = new JButton(Resources.getString("Editor.IrregularGrid.define_regions"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RegionGrid.this.configureRegions();
                }
            });
            ((Container)configurer.getControls()).add(jButton);
        }
        return configurer;
    }

    @Override
    public void addTo(Buildable buildable) {
        this.container = (GridContainer)((Object)buildable);
        this.container.setGrid(this);
    }

    @Override
    public void removeFrom(Buildable buildable) {
        this.container.removeGrid(this);
        this.container = null;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.IrregularGrid.component_type");
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("IrregularGrid.htm");
    }

    @Override
    public String getAttributeValueString(String string) {
        if (VISIBLE.equals(string)) {
            return String.valueOf(this.visible);
        }
        if (FONT_SIZE.equals(string)) {
            return String.valueOf(this.fontSize);
        }
        if (SNAPTO.equals(string)) {
            return String.valueOf(this.snapTo);
        }
        return null;
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (FONT_SIZE.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return RegionGrid.this.visible;
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (object == null) {
            return;
        }
        if (VISIBLE.equals(string)) {
            if (object instanceof Boolean) {
                this.visible = (Boolean)object;
            } else if (object instanceof String) {
                this.visible = "true".equals(object);
            }
        } else if (FONT_SIZE.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.fontSize = (Integer)object;
        } else if (SNAPTO.equals(string)) {
            if (object instanceof Boolean) {
                this.snapTo = (Boolean)object;
            } else if (object instanceof String) {
                this.snapTo = "true".equals(object);
            }
        }
    }

    public void configureRegions() {
        for (Region region : this.regionList.values()) {
            region.setSelected(false);
        }
        this.regionConfigurer = new Config(this);
        this.regionConfigurer.setVisible(true);
        inConfig = true;
    }

    @Override
    public boolean isVisible() {
        return this.visible || inConfig;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public Board getBoard() {
        return this.container.getBoard();
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{Region.class};
    }

    @Override
    public Point getLocation(String string) throws MapGrid.BadCoords {
        Region region = this.findRegion(string);
        if (region == null) {
            throw new MapGrid.BadCoords();
        }
        return new Point(region.getOrigin());
    }

    @Override
    public int range(Point point, Point point2) {
        return (int)Math.round(point.distance(point2));
    }

    @Override
    public Point snapTo(Point point) {
        if (!this.snapTo || this.regionList.isEmpty()) {
            return point;
        }
        return this.doSnap(point);
    }

    @Override
    public boolean isLocationRestricted(Point point) {
        return this.snapTo;
    }

    protected Point doSnap(Point point) {
        double d = Double.MAX_VALUE;
        Point point2 = point;
        for (Point point3 : this.regionList.keySet()) {
            double d2 = (point.x - point3.x) * (point.x - point3.x) + (point.y - point3.y) * (point.y - point3.y);
            if (!(d2 < d)) continue;
            d = d2;
            point2 = point3;
        }
        return new Point(point2);
    }

    @Override
    public String locationName(Point point) {
        if (this.regionList.isEmpty()) {
            return null;
        }
        Region region = this.regionList.get(this.doSnap(point));
        return region != null ? region.getName() : null;
    }

    @Override
    public String localizedLocationName(Point point) {
        if (this.regionList.isEmpty()) {
            return null;
        }
        Region region = this.regionList.get(this.doSnap(point));
        return region != null ? region.getLocalizedName() : null;
    }

    public Region getRegion(Point point) {
        for (Region region : this.regionList.values()) {
            if (!region.contains(point)) continue;
            return region;
        }
        return null;
    }

    public Region findRegion(String string) {
        for (Region region : this.regionList.values()) {
            if (!region.getConfigureName().equals(string)) continue;
            return region;
        }
        return null;
    }

    @Override
    public void draw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl) {
        if (this.visible) {
            this.forceDraw(graphics, rectangle, rectangle2, d, bl);
        }
    }

    public void forceDraw(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, double d, boolean bl) {
        for (Region region : this.regionList.values()) {
            region.draw(graphics, rectangle, rectangle2, d, bl);
        }
    }

    public void unSelectAll() {
        for (Region region : this.regionList.values()) {
            this.unSelect(region);
        }
    }

    public void unSelect(Region region) {
        region.setSelected(false);
    }

    public static class Config
    extends JFrame
    implements MouseListener,
    MouseMotionListener,
    ActionListener,
    KeyListener {
        private static final long serialVersionUID = 1L;
        protected RegionGrid grid;
        protected Board board;
        protected JPanel view;
        protected JScrollPane scroll;
        protected JPopupMenu myPopup;
        protected List<Region> selectedRegions = new ArrayList<Region>();
        protected Region lastClickedRegion = null;
        protected Point lastClick;
        protected Rectangle selectionRect = null;
        protected Point anchor;
        protected List<Region> saveRegions;
        protected boolean dirty = false;
        protected static final String ADD_REGION = Resources.getString("Editor.IrregularGrid.add_region");
        protected static final String DELETE_REGION = Resources.getString("Editor.IrregularGrid.delete_region");
        protected static final String PROPERTIES = Resources.getString("Editor.ModuleEditor.properties");

        public Config(RegionGrid regionGrid) {
            super(Resources.getString("Editor.IrregularGrid.regions_for", regionGrid.container.getBoard().getName()));
            this.board = regionGrid.container.getBoard();
            this.grid = regionGrid;
            this.initComponents();
            this.save();
        }

        protected void initComponents() {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    Config.this.doCancel();
                }
            });
            this.view = new View(this.board, this.grid, this);
            this.view.addMouseListener(this);
            this.view.addMouseMotionListener(this);
            this.view.addKeyListener(this);
            this.view.setFocusable(true);
            this.scroll = new AdjustableSpeedScrollPane(this.view, 22, 32);
            this.scroll.setPreferredSize(new Dimension(800, 600));
            this.add((Component)this.scroll, "Center");
            Box box = Box.createVerticalBox();
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton(Resources.getString("General.ok"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Config.this.close();
                }
            });
            jPanel.add(jButton);
            JButton jButton2 = new JButton(Resources.getString("General.cancel"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Config.this.doCancel();
                }
            });
            jPanel.add(jButton2);
            JLabel jLabel = new JLabel(Resources.getString("Editor.IrregularGrid.drag_and_drop"));
            jLabel.setAlignmentY(0.5f);
            box.add(jLabel);
            box.add(jPanel);
            this.add((Component)box, "South");
            this.scroll.revalidate();
            this.pack();
            this.repaint();
        }

        protected void setDirty(boolean bl) {
            this.dirty = bl;
        }

        protected void doCancel() {
            if (this.dirty) {
                if (0 == JOptionPane.showConfirmDialog(this, Resources.getString("Editor.IrregularGrid.changes_made"), "", 0)) {
                    this.restore();
                    this.close();
                }
            } else {
                this.close();
            }
        }

        protected void close() {
            inConfig = false;
            this.setVisible(false);
        }

        public void init() {
            for (Region region : this.selectedRegions) {
                region.setSelected(false);
            }
        }

        public void save() {
            this.saveRegions = new ArrayList<Region>(this.grid.regionList.size());
            for (Region region : this.grid.regionList.values()) {
                this.saveRegions.add(new Region(region));
            }
        }

        public void restore() {
            this.grid.removeAllRegions();
            for (Region region : this.saveRegions) {
                region.addTo(this.grid);
                this.grid.add(region);
            }
        }

        protected void doScroll(int n, int n2) {
            Rectangle rectangle = new Rectangle(this.scroll.getViewport().getViewRect());
            rectangle.translate(n, n2);
            rectangle = rectangle.intersection(new Rectangle(new Point(0, 0), this.view.getPreferredSize()));
            this.view.scrollRectToVisible(rectangle);
        }

        protected void scrollAtEdge(Point point, int n) {
            Point point2 = new Point(point.x - this.scroll.getViewport().getViewPosition().x, point.y - this.scroll.getViewport().getViewPosition().y);
            int n2 = 0;
            int n3 = 0;
            Dimension dimension = this.scroll.getViewport().getSize();
            if (point2.x < n && point2.x >= 0) {
                n2 = -1;
            }
            if (point2.x >= dimension.width - n && point2.x < dimension.width) {
                n2 = 1;
            }
            if (point2.y < n && point2.y >= 0) {
                n3 = -1;
            }
            if (point2.y >= dimension.height - n && point2.y < dimension.height) {
                n3 = 1;
            }
            if (n2 != 0 || n3 != 0) {
                this.doScroll(2 * n * n2, 2 * n * n3);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            EditPropertiesAction editPropertiesAction;
            Point point;
            this.lastClick = point = mouseEvent.getPoint();
            if (mouseEvent.isMetaDown()) {
                this.doPopupMenu(mouseEvent);
            } else if (this.lastClickedRegion != null && mouseEvent.getClickCount() >= 2 && this.lastClickedRegion.getConfigurer() != null && (editPropertiesAction = new EditPropertiesAction(this.lastClickedRegion, null, this)) != null) {
                editPropertiesAction.actionPerformed(new ActionEvent(mouseEvent.getSource(), 1001, "Edit"));
            }
            this.view.repaint();
        }

        protected void doPopupMenu(MouseEvent mouseEvent) {
            this.myPopup = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem(ADD_REGION);
            jMenuItem.addActionListener(this);
            jMenuItem.setEnabled(this.lastClickedRegion == null);
            this.myPopup.add(jMenuItem);
            jMenuItem = new JMenuItem(DELETE_REGION);
            jMenuItem.addActionListener(this);
            jMenuItem.setEnabled(this.lastClickedRegion != null);
            this.myPopup.add(jMenuItem);
            this.myPopup.addSeparator();
            jMenuItem = new JMenuItem(PROPERTIES);
            jMenuItem.addActionListener(this);
            jMenuItem.setEnabled(this.lastClickedRegion != null);
            this.myPopup.add(jMenuItem);
            Point point = mouseEvent.getPoint();
            this.myPopup.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    Config.this.view.repaint();
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    Config.this.view.repaint();
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }
            });
            this.myPopup.show(mouseEvent.getComponent(), point.x, point.y);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditRegionAction editRegionAction;
            String string = actionEvent.getActionCommand();
            if (string.equals("close")) {
                this.setVisible(false);
            } else if (string.equals("showhide")) {
                this.grid.setVisible(!this.grid.isVisible());
                this.view.repaint();
            } else if (string.equals(ADD_REGION)) {
                Region region = new Region(this.lastClick);
                region.addTo(this.grid);
                this.grid.add(region);
                this.select(region);
                this.lastClickedRegion = region;
                this.setDirty(true);
                EditPropertiesAction editPropertiesAction = new EditPropertiesAction(this.lastClickedRegion, null, this);
                if (editPropertiesAction != null) {
                    editPropertiesAction.actionPerformed(new ActionEvent(actionEvent.getSource(), 1001, "Edit"));
                }
                this.view.repaint();
            } else if (string.equals(DELETE_REGION)) {
                for (Region region : this.selectedRegions) {
                    region.removeFrom(this.grid);
                    this.grid.remove(region);
                    this.lastClickedRegion = null;
                    this.setDirty(true);
                }
                this.selectedRegions.clear();
                this.view.repaint();
            } else if (string.equals(PROPERTIES) && this.lastClickedRegion != null && (editRegionAction = new EditRegionAction(this.lastClickedRegion, null, this)) != null) {
                editRegionAction.actionPerformed(new ActionEvent(actionEvent.getSource(), 1001, "Edit"));
            }
        }

        protected void select(Region region) {
            region.setSelected(true);
            if (!this.selectedRegions.contains(region)) {
                this.selectedRegions.add(region);
            }
            this.view.repaint(region.getSelectionRect());
        }

        protected void unselect(Region region) {
            if (region != null) {
                region.setSelected(false);
                this.selectedRegions.remove(region);
                if (this.lastClickedRegion == region) {
                    this.lastClickedRegion = null;
                }
                this.view.repaint(region.getSelectionRect());
            }
        }

        protected void unSelectAll() {
            for (Region region : this.selectedRegions) {
                region.setSelected(false);
                this.view.repaint(region.getSelectionRect());
            }
            this.selectedRegions.clear();
        }

        public Rectangle getSelectionRect() {
            return this.selectionRect;
        }

        public Rectangle getSelectedBox() {
            Rectangle rectangle = null;
            for (Region region : this.selectedRegions) {
                Rectangle rectangle2 = region.getSelectionRect();
                if (rectangle == null) {
                    rectangle = rectangle2;
                    continue;
                }
                rectangle.add(rectangle2);
            }
            return rectangle;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point;
            this.lastClick = point = mouseEvent.getPoint();
            this.lastClickedRegion = this.grid.getRegion(point);
            if (!(mouseEvent.isShiftDown() || mouseEvent.isControlDown() || this.lastClickedRegion != null && this.lastClickedRegion.isSelected())) {
                this.unSelectAll();
            }
            if (this.lastClickedRegion == null) {
                this.anchor = point;
                this.selectionRect = new Rectangle(this.anchor.x, this.anchor.y, 0, 0);
            } else if (mouseEvent.isControlDown()) {
                this.unselect(this.lastClickedRegion);
            } else {
                this.select(this.lastClickedRegion);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.selectionRect != null) {
                for (Region region : this.grid.regionList.values()) {
                    if (!this.selectionRect.contains(region.getOrigin())) continue;
                    if (mouseEvent.isControlDown()) {
                        this.unselect(region);
                        continue;
                    }
                    this.select(region);
                }
                this.selectionRect = null;
                this.view.repaint();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!mouseEvent.isMetaDown()) {
                this.scrollAtEdge(mouseEvent.getPoint(), 15);
            }
            if (this.selectionRect != null) {
                Rectangle rectangle = new Rectangle(this.selectionRect.x - 1, this.selectionRect.y - 1, this.selectionRect.width + 3, this.selectionRect.height + 3);
                this.selectionRect.x = Math.min(mouseEvent.getX(), this.anchor.x);
                this.selectionRect.y = Math.min(mouseEvent.getY(), this.anchor.y);
                this.selectionRect.width = Math.abs(mouseEvent.getX() - this.anchor.x);
                this.selectionRect.height = Math.abs(mouseEvent.getY() - this.anchor.y);
                rectangle.add(new Rectangle(this.selectionRect.x - 1, this.selectionRect.y - 1, this.selectionRect.width + 3, this.selectionRect.height + 3));
                this.view.repaint(rectangle);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (this.selectedRegions.isEmpty() || !keyEvent.isControlDown()) {
                return;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 1;
            if (keyEvent.isShiftDown()) {
                n3 = 5;
            }
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    n2 = -n3;
                    break;
                }
                case 40: {
                    n2 = n3;
                    break;
                }
                case 37: {
                    n = -n3;
                    break;
                }
                case 39: {
                    n = n3;
                    break;
                }
                default: {
                    return;
                }
            }
            for (Region region : this.selectedRegions) {
                region.move(n, n2, this.view);
            }
            this.view.repaint();
            keyEvent.consume();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        protected static class EditRegionAction
        extends EditPropertiesAction {
            Config owner;
            Region origRegion;
            Region region;
            private static final long serialVersionUID = 1L;

            public EditRegionAction(Region region, HelpWindow helpWindow, Config config) {
                super(region, helpWindow, config);
                this.owner = config;
                this.origRegion = new Region(region);
                this.region = region;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesWindow propertiesWindow = (PropertiesWindow)openWindows.get(this.target);
                if (propertiesWindow == null) {
                    propertiesWindow = new PropertiesWindow(this.dialogOwner, false, this.target, this.helpWindow);
                    propertiesWindow.addWindowListener(new WindowAdapter(){

                        public void windowClosed(WindowEvent windowEvent) {
                            openWindows.remove(EditRegionAction.this.target);
                            EditRegionAction.this.owner.setDirty(!EditRegionAction.this.region.getName().equals(EditRegionAction.this.origRegion.getName()) || !EditRegionAction.this.region.getOrigin().equals(EditRegionAction.this.origRegion.getOrigin()));
                            EditRegionAction.this.owner.repaint();
                        }
                    });
                    openWindows.put(this.target, propertiesWindow);
                    propertiesWindow.setVisible(true);
                }
                propertiesWindow.toFront();
            }
        }

        public static class View
        extends JPanel
        implements DropTargetListener,
        DragGestureListener,
        DragSourceListener,
        DragSourceMotionListener {
            private static final long serialVersionUID = 1L;
            protected Board myBoard;
            protected RegionGrid grid;
            protected Config config;
            protected DragSource ds = DragSource.getDefaultDragSource();
            protected boolean isDragging = false;
            protected JLabel dragCursor;
            protected JLayeredPane drawWin;
            protected Point dragStart;
            protected Point lastDragLocation = new Point();
            protected Point drawOffset = new Point();
            protected Rectangle boundingBox;
            protected int currentPieceOffsetX;
            protected int currentPieceOffsetY;
            protected int originalPieceOffsetX;
            protected int originalPieceOffsetY;

            public View(Board board, RegionGrid regionGrid, Config config) {
                this.myBoard = board;
                this.grid = regionGrid;
                this.config = config;
                new DropTarget(this, 2, this);
                this.ds.createDefaultDragGestureRecognizer(this, 2, this);
                this.setFocusTraversalKeysEnabled(false);
            }

            public void paint(Graphics graphics) {
                Rectangle rectangle = this.getVisibleRect();
                graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.myBoard.draw(graphics, 0, 0, 1.0, this);
                Rectangle rectangle2 = new Rectangle(new Point(), this.myBoard.bounds().getSize());
                this.grid.forceDraw(graphics, rectangle2, rectangle2, 1.0, false);
                Rectangle rectangle3 = this.config.getSelectionRect();
                if (rectangle3 != null) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Stroke stroke = graphics2D.getStroke();
                    graphics2D.setStroke(new BasicStroke(2.0f));
                    graphics2D.setColor(Color.RED);
                    graphics2D.drawRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    graphics2D.setStroke(stroke);
                }
            }

            public void update(Graphics graphics) {
                this.paint(graphics);
            }

            public Dimension getPreferredSize() {
                return new Dimension(this.myBoard.bounds().width, this.myBoard.bounds().height);
            }

            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void dragExit(DropTargetEvent dropTargetEvent) {
            }

            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                this.removeDragCursor();
                Point point = dropTargetDropEvent.getLocation();
                int n = point.x - this.dragStart.x;
                int n2 = point.y - this.dragStart.y;
                for (Region region : this.config.selectedRegions) {
                    region.move(n, n2, this);
                    this.config.setDirty(true);
                }
                this.repaint();
            }

            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                Point point = dragGestureEvent.getDragOrigin();
                this.dragStart = new Point(point);
                Region region = this.grid.getRegion(point);
                if (region == null) {
                    return;
                }
                Point point2 = new Point(region.getOrigin());
                this.originalPieceOffsetX = point2.x - point.x;
                this.originalPieceOffsetY = point2.y - point.y;
                this.drawWin = null;
                this.makeDragCursor();
                this.setDragCursor();
                SwingUtilities.convertPointToScreen(this.drawOffset, this.drawWin);
                SwingUtilities.convertPointToScreen(point, this.drawWin);
                this.moveDragCursor(point.x, point.y);
                try {
                    dragGestureEvent.startDrag(Cursor.getPredefinedCursor(12), new StringSelection(""), this);
                    dragGestureEvent.getDragSource().addDragSourceMotionListener(this);
                }
                catch (InvalidDnDOperationException invalidDnDOperationException) {
                    ErrorDialog.bug(invalidDnDOperationException);
                }
            }

            public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
                this.removeDragCursor();
            }

            public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            }

            public void dragExit(DragSourceEvent dragSourceEvent) {
            }

            public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            }

            public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            }

            public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
                if (!dragSourceDragEvent.getLocation().equals(this.lastDragLocation)) {
                    this.lastDragLocation = dragSourceDragEvent.getLocation();
                    this.moveDragCursor(dragSourceDragEvent.getX(), dragSourceDragEvent.getY());
                    if (this.dragCursor != null && !this.dragCursor.isVisible()) {
                        this.dragCursor.setVisible(true);
                    }
                }
            }

            private void removeDragCursor() {
                if (this.drawWin != null) {
                    if (this.dragCursor != null) {
                        this.dragCursor.setVisible(false);
                        this.drawWin.remove(this.dragCursor);
                    }
                    this.drawWin = null;
                }
            }

            protected void moveDragCursor(int n, int n2) {
                if (this.drawWin != null) {
                    this.dragCursor.setLocation(n - this.drawOffset.x, n2 - this.drawOffset.y);
                }
            }

            protected void setDragCursor() {
                JRootPane jRootPane = SwingUtilities.getRootPane(this);
                if (jRootPane != null) {
                    if (this.dragCursor.getParent() != null) {
                        this.dragCursor.getParent().remove(this.dragCursor);
                    }
                    this.drawWin = jRootPane.getLayeredPane();
                    this.dragCursor.setVisible(true);
                    this.drawWin.add((Component)this.dragCursor, JLayeredPane.DRAG_LAYER);
                }
            }

            private void makeDragCursor() {
                if (this.dragCursor == null) {
                    this.dragCursor = new JLabel();
                    this.dragCursor.setVisible(false);
                }
                this.currentPieceOffsetX = this.originalPieceOffsetX;
                this.currentPieceOffsetY = this.originalPieceOffsetY;
                this.boundingBox = this.config.getSelectedBox();
                this.drawOffset.move(this.dragStart.x - this.boundingBox.x, this.dragStart.y - this.boundingBox.y);
                BufferedImage bufferedImage = ImageUtils.createCompatibleTranslucentImage(this.boundingBox.width, this.boundingBox.height);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                for (Region region : this.config.selectedRegions) {
                    int n = -this.boundingBox.x * 2;
                    int n2 = -this.boundingBox.y * 2;
                    region.draw(graphics2D, this.boundingBox, this.getVisibleRect(), 1.0, false, n, n2);
                }
                graphics2D.dispose();
                this.dragCursor.setSize(this.boundingBox.width, this.boundingBox.height);
                this.dragCursor.setIcon(new ImageIcon(bufferedImage));
            }
        }
    }
}

