/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.Player;
import VASSAL.chat.PlayerEncoder;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.SoundConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.SequenceEncoder;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class SoundEncoder
implements CommandEncoder {
    public static final String COMMAND_PREFIX = "PLAY\t";
    private PlayerEncoder playerEncoder;

    public SoundEncoder(PlayerEncoder playerEncoder) {
        this.playerEncoder = playerEncoder;
    }

    public Command decode(String string) {
        if (string.startsWith(COMMAND_PREFIX)) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '\t');
            decoder.nextToken();
            String string2 = decoder.nextToken();
            Player player = this.playerEncoder.stringToPlayer(decoder.nextToken(""));
            return new Cmd(string2, player);
        }
        return null;
    }

    public String encode(Command command) {
        String string = null;
        if (command instanceof Cmd) {
            Cmd cmd = (Cmd)command;
            SequenceEncoder sequenceEncoder = new SequenceEncoder('\t');
            sequenceEncoder.append(cmd.soundKey);
            sequenceEncoder.append(this.playerEncoder.playerToString(cmd.getSender()));
            string = COMMAND_PREFIX + sequenceEncoder.getValue();
        }
        return string;
    }

    public static class Cmd
    extends Command {
        private static final int TOO_MANY = 4;
        public static final int TOO_SOON = 10000;
        private static long lastTime = System.currentTimeMillis();
        private static Player lastSender;
        private static int sendCount;
        private static ArrayList<Player> banned;
        private static boolean updating;
        private String soundKey;
        private Player sender;

        public Cmd(String string, Player player) {
            this.soundKey = string;
            this.sender = player;
        }

        protected void executeCommand() {
            long l = System.currentTimeMillis();
            if (banned.contains(this.sender) || updating || l - lastTime < 10000L) {
                updating = false;
                return;
            }
            updating = true;
            lastTime = l;
            SoundConfigurer soundConfigurer = (SoundConfigurer)Prefs.getGlobalPrefs().getOption(this.soundKey);
            if (soundConfigurer != null) {
                soundConfigurer.play();
            }
            if (this.sender.equals(lastSender)) {
                if (sendCount++ >= 4) {
                    if (0 == JOptionPane.showConfirmDialog(null, Resources.getString("Chat.ignore_wakeups", this.sender.getName()), null, 0)) {
                        banned.add(this.sender);
                    } else {
                        sendCount = 1;
                    }
                }
            } else {
                lastSender = this.sender;
                sendCount = 1;
            }
            updating = false;
        }

        protected Command myUndoCommand() {
            return null;
        }

        public Player getSender() {
            return this.sender;
        }

        static {
            banned = new ArrayList();
            updating = false;
        }
    }
}

