/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.WelcomeMessageServer;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.chat.peer2peer.P2PClient;
import VASSAL.chat.peer2peer.PeerPool;
import VASSAL.chat.peer2peer.TextClient;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Random;

public class ClientTest
extends P2PClient
implements Runnable,
PropertyChangeListener {
    private static Random rng = new Random();
    private int changeRoom;
    private int numRooms;
    private FileWriter log;

    public ClientTest(PeerPool peerPool, MessageBoard messageBoard, WelcomeMessageServer welcomeMessageServer, int n, int n2, FileWriter fileWriter) {
        super(new TextClient.Encoder(), messageBoard, welcomeMessageServer, peerPool);
        this.changeRoom = n;
        this.numRooms = n2;
        this.log = fileWriter;
        this.addPropertyChangeListener("AvailableRooms", this);
        this.setConnected(true);
        new Thread(this).start();
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.changeRoom * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String string = "Room" + (int)((float)this.numRooms * rng.nextFloat());
            this.setRoom(new SimpleRoom(string));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.log.write("----------" + new Date() + "---------\n");
            this.log.write(ClientTest.report((Room[])propertyChangeEvent.getNewValue()));
            this.log.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String report(Room[] roomArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < roomArray.length; ++i) {
            stringBuilder.append(roomArray[i].getName() + ": ");
            List<Player> list = roomArray[i].getPlayerList();
            for (int j = 0; j < list.size(); ++j) {
                stringBuilder.append(list.get(j));
                if (j >= list.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

