/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.module.properties.PropertyChangerConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.script.expression.ExpressionBuilder;
import VASSAL.tools.FormattedString;
import VASSAL.tools.icon.IconFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class FormattedExpressionConfigurer
extends FormattedStringConfigurer {
    protected ExpressionButton button;
    protected EditablePiece pieceTarget;

    public FormattedExpressionConfigurer(String string, String string2) {
        super(string, string2);
    }

    public FormattedExpressionConfigurer(String string, String string2, String string3) {
        super(string, string2);
        this.setValue(string3);
    }

    public FormattedExpressionConfigurer(String string, String string2, FormattedString formattedString) {
        this(string, string2, formattedString.getFormat());
    }

    public FormattedExpressionConfigurer(String string, String string2, String string3, EditablePiece editablePiece) {
        this(string, string2, string3, (GamePiece)editablePiece);
    }

    public FormattedExpressionConfigurer(String string, String string2, String string3, PropertyChangerConfigurer.Constraints constraints) {
        this(string, string2, string3);
        if (constraints instanceof GamePiece) {
            this.storePiece((GamePiece)((Object)constraints));
        }
    }

    public FormattedExpressionConfigurer(String string, String string2, String string3, GamePiece gamePiece) {
        this(string, string2, string3);
        this.storePiece(gamePiece);
    }

    protected void storePiece(GamePiece gamePiece) {
        GamePiece gamePiece2;
        if (gamePiece instanceof Decorator && (gamePiece2 = Decorator.getOutermost(gamePiece)) instanceof EditablePiece) {
            this.pieceTarget = (EditablePiece)gamePiece2;
        }
    }

    public FormattedExpressionConfigurer(String string, String string2, String[] stringArray) {
        super(string, string2, stringArray);
    }

    public Component getControls() {
        JPanel jPanel = (JPanel)super.getControls();
        if (this.button == null) {
            this.button = this.buildButton();
            jPanel.add(this.button);
        }
        this.button.setSize(this.nameField.getPreferredSize().height);
        return jPanel;
    }

    protected ExpressionButton buildButton() {
        return new ExpressionButton(this, this.nameField.getPreferredSize().height, this.pieceTarget);
    }

    public static class ExpressionButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        protected Configurer config;
        protected EditablePiece piece;

        public ExpressionButton(Configurer configurer, int n) {
            this(configurer, n, null);
        }

        public ExpressionButton(Configurer configurer, int n, EditablePiece editablePiece) {
            this.config = configurer;
            this.piece = editablePiece;
            this.setIcon(IconFactory.getIcon("calculator", 0));
            this.setSize(n);
            this.setToolTipText("Expression Builder");
            this.addActionListener(this);
        }

        public void setSize(int n) {
            this.setPreferredSize(new Dimension(n, n));
            this.setMaximumSize(new Dimension(n, n));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new ExpressionBuilder(this.config, (JDialog)this.getTopLevelAncestor(), this.piece).setVisible(true);
        }
    }
}

