/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.BadDataReport;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.BeanShellExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.BeanShellExpression;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalculatedProperty
extends Decorator
implements EditablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "calcProp;";
    protected static int counter = 0;
    protected String name = "";
    protected Expression expression;

    public CalculatedProperty() {
        this(ID, null);
    }

    public CalculatedProperty(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.name).append(this.getExpression());
        return ID + sequenceEncoder.getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke keyStroke) {
        return null;
    }

    @Override
    public void mySetState(String string) {
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getDescription() {
        String string = "Calculated Property";
        if (this.name != null && this.name.length() > 0) {
            string = string + " - " + this.name;
        }
        return string;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("CalculatedProperty.htm");
    }

    @Override
    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.name = decoder.nextToken("");
        this.expression = BeanShellExpression.createExpression(decoder.nextToken(""));
    }

    protected String getExpression() {
        return this.expression.getExpression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(Object object) {
        String string = "";
        if (this.name.length() > 0 && this.name.equals(object)) {
            try {
                RecursionLimiter.startExecution(this);
                String string2 = string = this.evaluate();
                return string2;
            }
            catch (RecursionLimitException recursionLimitException) {
                RecursionLimiter.infiniteLoop(recursionLimitException);
            }
            finally {
                RecursionLimiter.endExecution();
            }
            return string;
        }
        return super.getProperty(object);
    }

    @Override
    public Object getLocalizedProperty(Object object) {
        if (this.name.length() > 0 && this.name.equals(object)) {
            return this.getProperty(object);
        }
        return super.getLocalizedProperty(object);
    }

    protected String evaluate() {
        try {
            return this.expression.evaluate(Decorator.getOutermost(this));
        }
        catch (ExpressionException expressionException) {
            ErrorDialog.dataError(new BadDataReport(Resources.getString("Error.expression_error"), this.piece.getProperty("BasicName") + "-Calculated Property[" + this.name + "]=" + this.getExpression() + ", Error=" + expressionException.getError(), expressionException));
            return "";
        }
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getComponentName() {
        return this.piece.getName();
    }

    @Override
    public String getComponentTypeName() {
        return this.getDescription();
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.name);
        return arrayList;
    }

    public static class Ed
    implements PieceEditor {
        protected StringConfigurer nameConfig;
        protected BeanShellExpressionConfigurer expressionConfig;
        protected StringConfigurer defaultValueConfig;
        protected JPanel box = new JPanel();

        public Ed(CalculatedProperty calculatedProperty) {
            this.box.setLayout(new BoxLayout(this.box, 1));
            this.nameConfig = new StringConfigurer(null, "Property Name:  ", calculatedProperty.name);
            this.box.add(this.nameConfig.getControls());
            this.expressionConfig = new BeanShellExpressionConfigurer(null, "Expression:  ", calculatedProperty.getExpression(), Decorator.getOutermost(calculatedProperty));
            this.box.add(this.expressionConfig.getControls());
        }

        public Component getControls() {
            return this.box;
        }

        public String getState() {
            return "";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.nameConfig.getValueString()).append(this.expressionConfig.getValueString());
            return CalculatedProperty.ID + sequenceEncoder.getValue();
        }
    }
}

