/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceSorter;
import VASSAL.counters.Stack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyBuffer {
    private static KeyBuffer theBuffer;
    private List<GamePiece> pieces;
    private BoundsTracker bounds;
    private Comparator<GamePiece> pieceSorter = new PieceSorter();

    private KeyBuffer() {
        this.pieces = new ArrayList<GamePiece>();
        this.bounds = new BoundsTracker();
    }

    public static void init(KeyBuffer keyBuffer) {
        if (theBuffer == null) {
            theBuffer = keyBuffer;
        }
    }

    public static KeyBuffer getBuffer() {
        if (theBuffer == null) {
            theBuffer = new KeyBuffer();
        }
        return theBuffer;
    }

    public void add(GamePiece gamePiece) {
        if (gamePiece != null && !this.pieces.contains(gamePiece)) {
            this.pieces.add(gamePiece);
            gamePiece.setProperty("Selected", Boolean.TRUE);
        }
    }

    public void clear() {
        for (GamePiece gamePiece : this.pieces) {
            gamePiece.setProperty("Selected", null);
        }
        this.pieces.clear();
    }

    public void remove(GamePiece gamePiece) {
        if (gamePiece != null) {
            gamePiece.setProperty("Selected", null);
            this.pieces.remove(gamePiece);
        }
    }

    public boolean contains(GamePiece gamePiece) {
        if (gamePiece instanceof Stack) {
            Iterator<GamePiece> iterator = ((Stack)gamePiece).getPiecesIterator();
            while (iterator.hasNext()) {
                if (this.pieces.contains(iterator.next())) continue;
                return false;
            }
            return true;
        }
        return this.pieces.contains(gamePiece);
    }

    public boolean isEmpty() {
        return this.pieces.isEmpty();
    }

    public Command keyCommand(KeyStroke keyStroke) {
        Object object;
        this.sort(this.pieceSorter);
        Command command = new NullCommand();
        this.bounds.clear();
        ArrayList<GamePiece> arrayList = new ArrayList<GamePiece>(this.pieces);
        if (arrayList.size() > 0 && (object = arrayList.get(0)).getMap() != null && (keyStroke.equals(object.getMap().getStackMetrics().getMoveBottomKey()) || keyStroke.equals(object.getMap().getStackMetrics().getMoveUpKey()))) {
            Collections.reverse(arrayList);
        }
        for (GamePiece gamePiece : arrayList) {
            this.bounds.addPiece(gamePiece);
            gamePiece.setProperty("snapshot", PieceCloner.getInstance().clonePiece(gamePiece));
            Command command2 = gamePiece.keyEvent(keyStroke);
            command = command.append(command2);
            this.bounds.addPiece(gamePiece);
        }
        this.bounds.repaint();
        return command;
    }

    public Iterator<GamePiece> getPiecesIterator() {
        return this.pieces.iterator();
    }

    @Deprecated
    public Enumeration<GamePiece> getPieces() {
        return Collections.enumeration(this.pieces);
    }

    public void sort(Comparator<GamePiece> comparator) {
        Collections.sort(this.pieces, comparator);
    }

    public boolean containsChild(Stack stack) {
        Iterator<GamePiece> iterator = stack.getPiecesIterator();
        while (iterator.hasNext()) {
            if (!this.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }
}

