/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.ObscurableOptions;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PieceAccessConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.ImagePicker;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceAccess;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PlayerAccess;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.ArrayUtils;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Obscurable
extends Decorator
implements TranslatablePiece {
    public static final String ID = "obs;";
    protected static final char INSET = 'I';
    protected static final char BACKGROUND = 'B';
    protected static final char PEEK = 'P';
    protected static final char IMAGE = 'G';
    protected static final String DEFAULT_PEEK_COMMAND = "Peek";
    protected char obscureKey;
    protected NamedKeyStroke keyCommand;
    protected NamedKeyStroke peekKey;
    protected String imageName;
    protected String obscuredToOthersImage;
    protected String obscuredBy;
    protected ObscurableOptions obscuredOptions;
    protected String hideCommand = "Mask";
    protected String peekCommand = "Peek";
    protected GamePiece obscuredToMeView;
    protected GamePiece obscuredToOthersView;
    protected boolean peeking;
    protected char displayStyle = (char)73;
    protected String maskName = "?";
    protected PieceAccess access = PlayerAccess.getInstance();
    protected KeyCommand[] commandsWithPeek;
    protected KeyCommand[] commandsWithoutPeek;
    protected KeyCommand hide;
    protected KeyCommand peek;

    public Obscurable() {
        this("obs;M;", null);
    }

    public Obscurable(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    @Override
    public void mySetState(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        String string2 = decoder.nextToken("null");
        this.obscuredBy = "null".equals(string2) ? null : string2;
        string2 = decoder.nextToken("");
        this.obscuredOptions = this.obscuredBy == null ? null : new ObscurableOptions(string2);
    }

    @Override
    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        this.keyCommand = decoder.nextNamedKeyStroke(null);
        this.imageName = decoder.nextToken();
        this.obscuredToMeView = GameModule.getGameModule().createPiece("piece;;;" + this.imageName + ";;");
        this.hideCommand = decoder.nextToken(this.hideCommand);
        if (decoder.hasMoreTokens()) {
            String string2 = decoder.nextToken(String.valueOf('I'));
            this.displayStyle = string2.charAt(0);
            switch (this.displayStyle) {
                case 'P': {
                    if (string2.length() > 1) {
                        this.peekKey = string2.length() == 2 ? NamedKeyStroke.getNamedKeyStroke(string2.charAt(1), 2) : NamedHotKeyConfigurer.decode(string2.substring(1));
                        this.peeking = false;
                        break;
                    }
                    this.peekKey = null;
                    this.peeking = true;
                    break;
                }
                case 'G': {
                    if (string2.length() <= 1) break;
                    this.obscuredToOthersImage = string2.substring(1);
                    this.obscuredToOthersView = GameModule.getGameModule().createPiece("piece;;;" + this.obscuredToOthersImage + ";;");
                    this.obscuredToMeView.setPosition(new Point());
                }
            }
        }
        this.maskName = decoder.nextToken(this.maskName);
        this.access = PieceAccessConfigurer.decode(decoder.nextToken(null));
        this.peekCommand = decoder.nextToken(DEFAULT_PEEK_COMMAND);
        this.commandsWithPeek = null;
        this.hide = null;
        this.peek = null;
    }

    @Override
    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.keyCommand).append(this.imageName).append(this.hideCommand);
        switch (this.displayStyle) {
            case 'P': {
                if (this.peekKey == null) {
                    sequenceEncoder.append(this.displayStyle);
                    break;
                }
                sequenceEncoder.append(this.displayStyle + NamedHotKeyConfigurer.encode(this.peekKey));
                break;
            }
            case 'G': {
                sequenceEncoder.append(this.displayStyle + this.obscuredToOthersImage);
                break;
            }
            default: {
                sequenceEncoder.append(this.displayStyle);
            }
        }
        sequenceEncoder.append(this.maskName);
        sequenceEncoder.append(PieceAccessConfigurer.encode(this.access));
        sequenceEncoder.append(this.peekCommand);
        return ID + sequenceEncoder.getValue();
    }

    @Override
    public String myGetState() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.obscuredBy == null ? "null" : this.obscuredBy);
        sequenceEncoder.append(this.obscuredBy == null || this.obscuredOptions == null ? "" : this.obscuredOptions.encodeOptions());
        return sequenceEncoder.getValue();
    }

    @Override
    public Rectangle boundingBox() {
        if (this.obscuredToMe()) {
            return this.bBoxObscuredToMe();
        }
        if (this.obscuredToOthers()) {
            return this.bBoxObscuredToOthers();
        }
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        if (this.obscuredToMe()) {
            return this.obscuredToMeView.getShape();
        }
        if (this.obscuredToOthers()) {
            switch (this.displayStyle) {
                case 'B': {
                    return this.obscuredToMeView.getShape();
                }
                case 'I': {
                    return this.piece.getShape();
                }
                case 'P': {
                    if (this.peeking && Boolean.TRUE.equals(this.getProperty("Selected"))) {
                        return this.piece.getShape();
                    }
                    return this.obscuredToMeView.getShape();
                }
                case 'G': {
                    Area area = new Area(this.obscuredToOthersView.getShape());
                    Shape shape = this.piece.getShape();
                    if (shape instanceof Area) {
                        area.add((Area)shape);
                    } else {
                        area.add(new Area(shape));
                    }
                    return area;
                }
            }
            return this.piece.getShape();
        }
        return this.piece.getShape();
    }

    public boolean obscuredToMe() {
        return !this.access.currentPlayerHasAccess(this.obscuredBy);
    }

    public boolean obscuredToOthers() {
        return this.obscuredBy != null;
    }

    @Override
    public void setProperty(Object object, Object object2) {
        if (ID.equals(object)) {
            if (object2 instanceof String || object2 == null) {
                this.obscuredBy = (String)object2;
                if ("null".equals(this.obscuredBy)) {
                    this.obscuredBy = null;
                    this.obscuredOptions = null;
                }
            }
        } else if ("Selected".equals(object)) {
            if (!Boolean.TRUE.equals(object2) && this.peekKey != null) {
                this.peeking = false;
            }
            super.setProperty(object, object2);
        } else if ("ObscuredToOthers".equals(object)) {
            String string = null;
            if (Boolean.TRUE.equals(object2)) {
                string = this.access.getCurrentPlayerId();
            }
            this.obscuredBy = string;
            this.obscuredOptions = new ObscurableOptions(ObscurableOptions.getInstance().encodeOptions());
        } else {
            super.setProperty(object, object2);
        }
    }

    @Override
    public Object getProperty(Object object) {
        if ("Obscured".equals(object)) {
            return this.obscuredToMe();
        }
        if ("ObscuredToOthers".equals(object)) {
            return this.obscuredToOthers();
        }
        if (ID.equals(object)) {
            return this.obscuredBy;
        }
        if ("visibleState".equals(object)) {
            return this.myGetState() + this.isPeeking() + this.piece.getProperty(object);
        }
        return super.getProperty(object);
    }

    @Override
    public Object getLocalizedProperty(Object object) {
        if (this.obscuredToMe()) {
            return ((BasicPiece)Decorator.getInnermost(this)).getLocalizedPublicProperty(object);
        }
        if ("Obscured".equals(object)) {
            return this.obscuredToMe();
        }
        if ("ObscuredToOthers".equals(object)) {
            return this.obscuredToOthers();
        }
        if (ID.equals(object)) {
            return this.obscuredBy;
        }
        if ("visibleState".equals(object)) {
            return this.myGetState() + this.isPeeking() + this.piece.getProperty(object);
        }
        return super.getLocalizedProperty(object);
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        if (this.obscuredToMe()) {
            this.drawObscuredToMe(graphics, n, n2, component, d);
        } else if (this.obscuredToOthers()) {
            this.drawObscuredToOthers(graphics, n, n2, component, d);
        } else {
            this.piece.draw(graphics, n, n2, component, d);
        }
    }

    protected void drawObscuredToMe(Graphics graphics, int n, int n2, Component component, double d) {
        this.obscuredToMeView.draw(graphics, n, n2, component, d);
    }

    protected void drawObscuredToOthers(Graphics graphics, int n, int n2, Component component, double d) {
        switch (this.displayStyle) {
            case 'B': {
                this.obscuredToMeView.draw(graphics, n, n2, component, d);
                this.piece.draw(graphics, n, n2, component, d * 0.5);
                break;
            }
            case 'I': {
                this.piece.draw(graphics, n, n2, component, d);
                Rectangle rectangle = this.piece.getShape().getBounds();
                Rectangle rectangle2 = this.obscuredToMeView.getShape().getBounds();
                this.obscuredToMeView.draw(graphics, n - (int)(d * (double)rectangle.width / 2.0 - 0.5 * d * (double)rectangle2.width / 2.0), n2 - (int)(d * (double)rectangle.height / 2.0 - 0.5 * d * (double)rectangle2.height / 2.0), component, d * 0.5);
                break;
            }
            case 'P': {
                if (this.peeking && Boolean.TRUE.equals(this.getProperty("Selected"))) {
                    this.piece.draw(graphics, n, n2, component, d);
                    break;
                }
                this.obscuredToMeView.draw(graphics, n, n2, component, d);
                break;
            }
            case 'G': {
                this.piece.draw(graphics, n, n2, component, d);
                this.obscuredToOthersView.draw(graphics, n, n2, component, d);
            }
        }
    }

    public boolean isPeeking() {
        return this.peeking;
    }

    protected Rectangle bBoxObscuredToMe() {
        return this.obscuredToMeView.boundingBox();
    }

    protected Rectangle bBoxObscuredToOthers() {
        Rectangle rectangle;
        switch (this.displayStyle) {
            case 'B': {
                rectangle = this.bBoxObscuredToMe();
                break;
            }
            case 'G': {
                rectangle = this.piece.boundingBox();
                rectangle.add(this.obscuredToOthersView.boundingBox());
                break;
            }
            default: {
                rectangle = this.piece.boundingBox();
            }
        }
        return rectangle;
    }

    @Override
    public String getLocalizedName() {
        String string = this.maskName == null ? "?" : this.maskName;
        string = this.getTranslation(string);
        return this.getName(string, true);
    }

    @Override
    public String getName() {
        String string = this.maskName == null ? "?" : this.maskName;
        return this.getName(string, false);
    }

    protected String getName(String string, boolean bl) {
        if (this.obscuredToMe()) {
            return string;
        }
        if (this.obscuredToOthers()) {
            return (bl ? this.piece.getLocalizedName() : this.piece.getName()) + "(" + string + ")";
        }
        return bl ? this.piece.getLocalizedName() : this.piece.getName();
    }

    @Override
    public KeyCommand[] getKeyCommands() {
        if (this.obscuredToMe()) {
            KeyCommand[] keyCommandArray = this.myGetKeyCommands();
            KeyCommand[] keyCommandArray2 = (KeyCommand[])Decorator.getInnermost(this).getProperty("KeyCommands");
            if (keyCommandArray2 == null) {
                return keyCommandArray;
            }
            return (KeyCommand[])ArrayUtils.append(KeyCommand[].class, keyCommandArray, keyCommandArray2);
        }
        return super.getKeyCommands();
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        ArrayList<KeyCommand> arrayList = new ArrayList<KeyCommand>();
        GamePiece gamePiece = Decorator.getOutermost(this);
        if (this.keyCommand == null) {
            this.keyCommand = NamedKeyStroke.getNamedKeyStroke(this.obscureKey, 2);
        }
        this.hide = new KeyCommand(this.hideCommand, this.keyCommand, gamePiece, (TranslatablePiece)this);
        if (this.hideCommand.length() > 0 && this.isMaskable()) {
            arrayList.add(this.hide);
            this.commandsWithoutPeek = new KeyCommand[]{this.hide};
        } else {
            this.commandsWithoutPeek = new KeyCommand[0];
        }
        this.peek = new KeyCommand(this.peekCommand, this.peekKey, gamePiece, (TranslatablePiece)this);
        if (this.displayStyle == 'P' && this.peekKey != null && this.peekCommand.length() > 0) {
            arrayList.add(this.peek);
        }
        this.commandsWithPeek = arrayList.toArray(new KeyCommand[arrayList.size()]);
        return this.obscuredToOthers() && this.isMaskable() && this.displayStyle == 'P' && this.peekKey != null ? this.commandsWithPeek : this.commandsWithoutPeek;
    }

    @Deprecated
    public boolean isMaskableBy(String string) {
        return this.isMaskable();
    }

    public boolean isMaskable() {
        if (this.access.currentPlayerCanModify(this.obscuredBy)) {
            return true;
        }
        if (this.obscuredOptions != null) {
            return this.obscuredOptions.isUnmaskable(this.obscuredBy);
        }
        return ObscurableOptions.getInstance().isUnmaskable(this.obscuredBy);
    }

    @Override
    public Command keyEvent(KeyStroke keyStroke) {
        if (!this.obscuredToMe()) {
            return super.keyEvent(keyStroke);
        }
        if (this.isMaskable()) {
            return this.myKeyEvent(keyStroke);
        }
        return null;
    }

    @Override
    public Command myKeyEvent(KeyStroke keyStroke) {
        Object object;
        Command command = null;
        this.myGetKeyCommands();
        if (this.hide.matches(keyStroke)) {
            object = new ChangeTracker(this);
            if (this.obscuredToOthers() || this.obscuredToMe()) {
                this.obscuredBy = null;
                this.obscuredOptions = null;
            } else if (!this.obscuredToMe()) {
                this.obscuredBy = this.access.getCurrentPlayerId();
                this.obscuredOptions = new ObscurableOptions(ObscurableOptions.getInstance().encodeOptions());
            }
            command = ((ChangeTracker)object).getChangeCommand();
        } else if (this.peek.matches(keyStroke) && this.obscuredToOthers() && Boolean.TRUE.equals(this.getProperty("Selected"))) {
            this.peeking = true;
        }
        if (command != null && 'P' == this.displayStyle && this.peekKey == null && this.obscuredToOthers()) {
            object = new Runnable(){

                public void run() {
                    KeyBuffer.getBuffer().remove(Decorator.getOutermost(Obscurable.this));
                }
            };
            SwingUtilities.invokeLater((Runnable)object);
        }
        return command;
    }

    @Override
    public String getDescription() {
        return "Mask";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Mask.htm");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Deprecated
    public static void setAllHidden(boolean bl) {
        if (bl) {
            PieceAccess.GlobalAccess.hideAll();
        } else {
            PieceAccess.GlobalAccess.revertAll();
        }
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(new String[]{this.hideCommand, this.maskName, this.peekCommand}, new String[]{"Mask command", "Name when masked", "Peek command"});
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ObscuredToOthers");
        arrayList.add("Obscured");
        return arrayList;
    }

    private static class Ed
    implements PieceEditor {
        private ImagePicker picker;
        private NamedHotKeyConfigurer obscureKeyInput;
        private StringConfigurer obscureCommandInput;
        private StringConfigurer maskNameInput;
        private StringEnumConfigurer displayOption;
        private NamedHotKeyConfigurer peekKeyInput;
        private StringConfigurer peekCommandInput;
        private JPanel controls = new JPanel();
        private String[] optionNames = new String[]{"Background", "Plain", "Inset", "Use Image"};
        private char[] optionChars = new char[]{'B', 'P', 'I', 'G'};
        private ImagePicker imagePicker;
        private PieceAccessConfigurer accessConfig;

        public Ed(Obscurable obscurable) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            Box box = Box.createHorizontalBox();
            this.obscureCommandInput = new StringConfigurer(null, "Mask Command:  ", obscurable.hideCommand);
            box.add(this.obscureCommandInput.getControls());
            this.obscureKeyInput = new NamedHotKeyConfigurer(null, "  Keyboard Command:  ", obscurable.keyCommand);
            box.add(this.obscureKeyInput.getControls());
            this.controls.add(box);
            this.accessConfig = new PieceAccessConfigurer(null, "Can be masked by:  ", obscurable.access);
            this.controls.add(this.accessConfig.getControls());
            box = Box.createHorizontalBox();
            box.add(new JLabel("View when masked: "));
            this.picker = new ImagePicker();
            this.picker.setImageName(obscurable.imageName);
            box.add(this.picker);
            this.controls.add(box);
            box = Box.createHorizontalBox();
            this.maskNameInput = new StringConfigurer(null, "Name when masked:  ", obscurable.maskName);
            box.add(this.maskNameInput.getControls());
            this.controls.add(box);
            box = Box.createHorizontalBox();
            this.displayOption = new StringEnumConfigurer(null, "Display style:  ", this.optionNames);
            for (int i = 0; i < this.optionNames.length; ++i) {
                if (obscurable.displayStyle != this.optionChars[i]) continue;
                this.displayOption.setValue(this.optionNames[i]);
                break;
            }
            box.add(this.displayOption.getControls());
            final JPanel jPanel = new JPanel(){
                private static final long serialVersionUID = 1L;

                public Dimension getMinimumSize() {
                    return new Dimension(60, 60);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(60, 60);
                }

                public void paint(Graphics graphics) {
                    graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                    switch (Ed.this.displayOption.getValueString().charAt(0)) {
                        case 'B': {
                            graphics.setColor(Color.black);
                            graphics.fillRect(0, 0, 60, 60);
                            graphics.setColor(Color.white);
                            graphics.fillRect(15, 15, 30, 30);
                            break;
                        }
                        case 'I': {
                            graphics.setColor(Color.white);
                            graphics.fillRect(0, 0, 60, 60);
                            graphics.setColor(Color.black);
                            graphics.fillRect(0, 0, 30, 30);
                            break;
                        }
                        case 'P': {
                            graphics.setColor(Color.black);
                            graphics.fillRect(0, 0, 60, 60);
                        }
                    }
                }
            };
            box.add(jPanel);
            this.controls.add(box);
            this.peekKeyInput = new NamedHotKeyConfigurer(null, "Peek Key:  ", obscurable.peekKey);
            this.peekKeyInput.getControls().setVisible(obscurable.displayStyle == 'P');
            this.controls.add(this.peekKeyInput.getControls());
            this.peekCommandInput = new StringConfigurer(null, "Peek Command:  ", obscurable.peekCommand);
            this.peekCommandInput.getControls().setVisible(obscurable.displayStyle == 'P');
            this.controls.add(this.peekCommandInput.getControls());
            this.imagePicker = new ImagePicker();
            this.imagePicker.setImageName(obscurable.obscuredToOthersImage);
            this.imagePicker.setVisible(obscurable.displayStyle == 'G');
            this.controls.add(this.imagePicker);
            this.displayOption.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jPanel.repaint();
                    Ed.this.peekKeyInput.getControls().setVisible(Ed.this.optionNames[1].equals(propertyChangeEvent.getNewValue()));
                    Ed.this.peekCommandInput.getControls().setVisible(Ed.this.optionNames[1].equals(propertyChangeEvent.getNewValue()));
                    Ed.this.imagePicker.setVisible(Ed.this.optionNames[3].equals(propertyChangeEvent.getNewValue()));
                    Window window = SwingUtilities.getWindowAncestor(Ed.this.controls);
                    if (window != null) {
                        window.pack();
                    }
                }
            });
        }

        public String getState() {
            return "null";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.obscureKeyInput.getValueString()).append(this.picker.getImageName()).append(this.obscureCommandInput.getValueString());
            char c = 'I';
            for (int i = 0; i < this.optionNames.length; ++i) {
                if (!this.optionNames[i].equals(this.displayOption.getValueString())) continue;
                c = this.optionChars[i];
                break;
            }
            switch (c) {
                case 'P': {
                    String string = this.peekKeyInput.getValueString();
                    if (string != null) {
                        sequenceEncoder.append(c + string);
                        break;
                    }
                    sequenceEncoder.append(c);
                    break;
                }
                case 'G': {
                    sequenceEncoder.append(c + this.imagePicker.getImageName());
                    break;
                }
                default: {
                    sequenceEncoder.append(c);
                }
            }
            sequenceEncoder.append(this.maskNameInput.getValueString());
            sequenceEncoder.append(this.accessConfig.getValueString());
            sequenceEncoder.append(this.peekCommandInput.getValueString());
            return Obscurable.ID + sequenceEncoder.getValue();
        }

        public Component getControls() {
            return this.controls;
        }
    }
}

