/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.GpIdSupport;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.widget.CardSlot;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.AddPiece;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ChooseComponentPathDialog;
import VASSAL.configure.ConfigurerWindow;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.ComponentPathBuilder;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class PlaceMarker
extends Decorator
implements TranslatablePiece {
    public static final String ID = "placemark;";
    protected KeyCommand command;
    protected NamedKeyStroke key;
    protected String markerSpec;
    protected String markerText = "";
    protected int xOffset = 0;
    protected int yOffset = 0;
    protected boolean matchRotation = false;
    protected KeyCommand[] commands;
    protected NamedKeyStroke afterBurnerKey;
    protected String description = "";
    protected String gpId = "";
    protected String newGpId;
    protected GpIdSupport gpidSupport;
    protected static final int STACK_TOP = 0;
    protected static final int STACK_BOTTOM = 1;
    protected static final int ABOVE = 2;
    protected static final int BELOW = 3;
    protected int placement = 0;
    protected boolean above;

    public PlaceMarker() {
        this("placemark;Place Marker;M;null;null;null", null);
    }

    public PlaceMarker(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    public String getName() {
        return this.piece.getName();
    }

    protected KeyCommand[] myGetKeyCommands() {
        this.command.setEnabled(this.getMap() != null && this.markerSpec != null);
        return this.commands;
    }

    public String myGetState() {
        return "";
    }

    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.command.getName()).append(this.key).append(this.markerSpec == null ? "null" : this.markerSpec).append(this.markerText == null ? "null" : this.markerText).append(this.xOffset).append(this.yOffset).append(this.matchRotation).append(this.afterBurnerKey).append(this.description).append(this.gpId).append(this.placement).append(this.above);
        return ID + sequenceEncoder.getValue();
    }

    public Command myKeyEvent(KeyStroke keyStroke) {
        this.myGetKeyCommands();
        if (this.command.matches(keyStroke)) {
            return this.placeMarker();
        }
        return null;
    }

    protected Command placeMarker() {
        Object object;
        Object object2;
        Object object3;
        Map map = this.getMap();
        if (map == null) {
            return null;
        }
        GamePiece gamePiece = this.createMarker();
        if (gamePiece == null) {
            return null;
        }
        Object object4 = null;
        GamePiece gamePiece2 = PlaceMarker.getOutermost(this);
        Point point = this.getPosition();
        point.translate(this.xOffset, -this.yOffset);
        if (this.matchRotation) {
            object3 = (FreeRotator)Decorator.getDecorator(gamePiece2, FreeRotator.class);
            object2 = (FreeRotator)Decorator.getDecorator(gamePiece, FreeRotator.class);
            if (object3 != null && object2 != null) {
                ((FreeRotator)object2).setAngle(((FreeRotator)object3).getAngle());
                Point point2 = this.getPosition().getLocation();
                object = point.getLocation();
                object = AffineTransform.getRotateInstance(((FreeRotator)object3).getAngleInRadians(), ((Point2D)point2).getX(), ((Point2D)point2).getY()).transform((Point2D)object, null);
                point = new Point((int)((Point2D)object).getX(), (int)((Point2D)object).getY());
            }
        }
        if (!Boolean.TRUE.equals(gamePiece.getProperty("IgnoreGrid"))) {
            point = this.getMap().snapTo(point);
        }
        if (map.getStackMetrics().isStackingEnabled() && !Boolean.TRUE.equals(gamePiece.getProperty("NoStack")) && !Boolean.TRUE.equals(gamePiece2.getProperty("NoStack")) && map.getPieceCollection().canMerge(gamePiece2, gamePiece)) {
            object3 = this.getParent();
            object2 = gamePiece2;
            int n = -1;
            switch (this.placement) {
                case 2: {
                    object2 = gamePiece2;
                    break;
                }
                case 3: {
                    n = object3 == null ? 0 : ((Stack)object3).indexOf(gamePiece2);
                    break;
                }
                case 1: {
                    n = 0;
                    break;
                }
                case 0: {
                    object2 = object3 == null ? gamePiece2 : object3;
                }
            }
            object4 = map.getStackMetrics().merge((GamePiece)object2, gamePiece);
            if (n >= 0) {
                object = new ChangeTracker((GamePiece)object3);
                ((Stack)object3).insert(gamePiece, n);
                object4 = ((Command)object4).append(((ChangeTracker)object).getChangeCommand());
            }
        } else {
            object4 = map.placeAt(gamePiece, point);
        }
        if (this.afterBurnerKey != null && !this.afterBurnerKey.isNull()) {
            gamePiece.setProperty("snapshot", PieceCloner.getInstance().clonePiece(gamePiece));
            ((Command)object4).append(gamePiece.keyEvent(this.afterBurnerKey.getKeyStroke()));
        }
        if (this.getProperty("Selected") == Boolean.TRUE) {
            this.selectMarker(gamePiece);
        }
        if (!(this.markerText == null || Boolean.TRUE.equals(gamePiece2.getProperty("ObscuredToOthers")) || Boolean.TRUE.equals(gamePiece2.getProperty("Obscured")) || Boolean.TRUE.equals(gamePiece2.getProperty("InvisibleToOthers")) || (object3 = map.locationName(this.getPosition())) == null)) {
            object2 = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), " * " + (String)object3 + ":  " + gamePiece2.getName() + " " + this.markerText + " * ");
            ((Command)object2).execute();
            object4 = object4 == null ? object2 : ((Command)object4).append((Command)object2);
        }
        return object4;
    }

    protected void selectMarker(GamePiece gamePiece) {
        if (gamePiece.getProperty("selectEventFilter") == null && gamePiece.getParent() != null && gamePiece.getParent().equals(this.getParent())) {
            KeyBuffer.getBuffer().add(gamePiece);
        }
    }

    public GamePiece createMarker() {
        GamePiece gamePiece = this.createBaseMarker();
        if (gamePiece == null) {
            gamePiece = new BasicPiece();
            this.newGpId = this.getGpId();
        } else {
            gamePiece = PieceCloner.getInstance().clonePiece(gamePiece);
        }
        gamePiece.setProperty("PieceId", this.newGpId);
        return gamePiece;
    }

    public GamePiece createBaseMarker() {
        if (this.markerSpec == null) {
            return null;
        }
        GamePiece gamePiece = null;
        if (this.isMarkerStandalone()) {
            AddPiece addPiece = (AddPiece)GameModule.getGameModule().decode(this.markerSpec);
            gamePiece = addPiece.getTarget();
            gamePiece.setState(addPiece.getState());
            this.newGpId = this.getGpId();
        } else {
            try {
                Configurable[] configurableArray = ComponentPathBuilder.getInstance().getPath(this.markerSpec);
                Configurable configurable = configurableArray[configurableArray.length - 1];
                if (configurable instanceof PieceSlot) {
                    gamePiece = ((PieceSlot)configurable).getPiece();
                    this.newGpId = ((PieceSlot)configurable).getGpId();
                }
            }
            catch (ComponentPathBuilder.PathFormatException pathFormatException) {
                PlaceMarker.reportDataError(this, Resources.getString("Resources.place_error"), pathFormatException.getMessage() + " markerSpec=" + this.markerSpec, pathFormatException);
            }
        }
        return gamePiece;
    }

    public boolean isMarkerStandalone() {
        return this.markerSpec != null && this.markerSpec.startsWith("+/");
    }

    public void mySetState(String string) {
    }

    public Shape getShape() {
        return this.piece.getShape();
    }

    public String getDescription() {
        String string = "Place Marker";
        if (this.description.length() > 0) {
            string = string + " - " + this.description;
        }
        return string;
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Marker.htm");
    }

    public void mySetType(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        decoder.nextToken();
        String string2 = decoder.nextToken();
        this.key = decoder.nextNamedKeyStroke(null);
        this.command = new KeyCommand(string2, this.key, (GamePiece)this, (TranslatablePiece)this);
        this.commands = string2.length() > 0 && this.key != null ? new KeyCommand[]{this.command} : new KeyCommand[0];
        this.markerSpec = decoder.nextToken();
        if ("null".equals(this.markerSpec)) {
            this.markerSpec = null;
        }
        this.markerText = decoder.nextToken("null");
        if ("null".equals(this.markerText)) {
            this.markerText = null;
        }
        this.xOffset = decoder.nextInt(0);
        this.yOffset = decoder.nextInt(0);
        this.matchRotation = decoder.nextBoolean(false);
        this.afterBurnerKey = decoder.nextNamedKeyStroke(null);
        this.description = decoder.nextToken("");
        this.setGpId(decoder.nextToken(""));
        this.placement = decoder.nextInt(0);
        this.above = decoder.nextBoolean(false);
        this.gpidSupport = GameModule.getGameModule().getGpIdSupport();
    }

    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command.getName(), this.getCommandDescription(this.description, "Place Marker command"));
    }

    public String getGpId() {
        return this.gpId;
    }

    public void setGpId(String string) {
        this.gpId = string;
    }

    public void updateGpId(GpIdSupport gpIdSupport) {
        this.gpidSupport = gpIdSupport;
        this.updateGpId();
    }

    public void updateGpId() {
        this.setGpId(this.gpidSupport.generateGpId());
    }

    protected static class Ed
    implements PieceEditor {
        private NamedHotKeyConfigurer keyInput;
        private StringConfigurer commandInput;
        private PieceSlot pieceInput;
        private JPanel p = new JPanel();
        private String markerSlotPath;
        protected JButton defineButton = new JButton("Define Marker");
        protected JButton selectButton = new JButton("Select");
        protected IntConfigurer xOffsetConfig = new IntConfigurer(null, "Horizontal offset:  ");
        protected IntConfigurer yOffsetConfig = new IntConfigurer(null, "Vertical offset:  ");
        protected BooleanConfigurer matchRotationConfig = this.createMatchRotationConfig();
        protected BooleanConfigurer aboveConfig = this.createAboveConfig();
        protected JComboBox placementConfig;
        protected NamedHotKeyConfigurer afterBurner;
        protected StringConfigurer descConfig;
        private String slotId;

        protected Ed(PlaceMarker placeMarker) {
            this.descConfig = new StringConfigurer(null, "Description:  ", placeMarker.description);
            this.keyInput = new NamedHotKeyConfigurer(null, "Keyboard Command:  ", placeMarker.key);
            this.afterBurner = new NamedHotKeyConfigurer(null, "Keystroke to apply after placement:  ", placeMarker.afterBurnerKey);
            this.commandInput = new StringConfigurer(null, "Command:  ", placeMarker.command.getName());
            GamePiece gamePiece = placeMarker.createBaseMarker();
            this.pieceInput = new PieceSlot(gamePiece);
            this.pieceInput.updateGpId(placeMarker.gpidSupport);
            this.pieceInput.setGpId(placeMarker.getGpId());
            this.markerSlotPath = placeMarker.markerSpec;
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 1));
            this.p.add(this.descConfig.getControls());
            this.p.add(this.commandInput.getControls());
            this.p.add(this.keyInput.getControls());
            Box box = Box.createHorizontalBox();
            box.add(this.pieceInput.getComponent());
            this.defineButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Ed.this.markerSlotPath = null;
                    new ConfigurerWindow(Ed.this.pieceInput.getConfigurer()).setVisible(true);
                }
            });
            box.add(this.defineButton);
            this.selectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ChoosePieceDialog choosePieceDialog = new ChoosePieceDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, Ed.this.p), PieceSlot.class);
                    choosePieceDialog.setVisible(true);
                    if (choosePieceDialog.getTarget() instanceof PieceSlot) {
                        Ed.this.pieceInput.setPiece(((PieceSlot)choosePieceDialog.getTarget()).getPiece());
                    }
                    if (choosePieceDialog.getPath() != null) {
                        Ed.this.markerSlotPath = ComponentPathBuilder.getInstance().getId(choosePieceDialog.getPath());
                        Ed.this.slotId = "";
                    } else {
                        Ed.this.markerSlotPath = null;
                    }
                }
            });
            box.add(this.selectButton);
            this.p.add(box);
            this.xOffsetConfig.setValue(placeMarker.xOffset);
            this.p.add(this.xOffsetConfig.getControls());
            this.yOffsetConfig.setValue(placeMarker.yOffset);
            this.p.add(this.yOffsetConfig.getControls());
            this.matchRotationConfig.setValue(placeMarker.matchRotation);
            this.p.add(this.matchRotationConfig.getControls());
            if (this.aboveConfig != null) {
                this.aboveConfig.setValue(placeMarker.above);
                this.p.add(this.aboveConfig.getControls());
                ((JCheckBox)this.matchRotationConfig.getControls()).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Ed.this.aboveConfig.getControls().setVisible(((JCheckBox)Ed.this.matchRotationConfig.getControls()).isSelected());
                    }
                });
                this.aboveConfig.getControls().setVisible(placeMarker.matchRotation);
            }
            this.placementConfig = new JComboBox<String>(new String[]{"On top of stack", "On bottom of stack", "Above this piece", "Below this piece"});
            this.placementConfig.setSelectedIndex(placeMarker.placement);
            Box box2 = Box.createHorizontalBox();
            box2.add(new JLabel("Place marker:  "));
            box2.add(this.placementConfig);
            this.p.add(box2);
            this.p.add(this.afterBurner.getControls());
            this.slotId = placeMarker.getGpId();
        }

        protected BooleanConfigurer createMatchRotationConfig() {
            return new BooleanConfigurer(null, "Match Rotation?");
        }

        protected BooleanConfigurer createAboveConfig() {
            return null;
        }

        public Component getControls() {
            return this.p;
        }

        public String getState() {
            return "";
        }

        public String getType() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
            sequenceEncoder.append(this.commandInput.getValueString());
            sequenceEncoder.append(this.keyInput.getValueString());
            if (this.pieceInput.getPiece() == null) {
                sequenceEncoder.append("null");
            } else if (this.markerSlotPath != null) {
                sequenceEncoder.append(this.markerSlotPath);
            } else {
                String string = GameModule.getGameModule().encode(new AddPiece(this.pieceInput.getPiece()));
                sequenceEncoder.append(string);
            }
            sequenceEncoder.append("null");
            sequenceEncoder.append(this.xOffsetConfig.getValueString());
            sequenceEncoder.append(this.yOffsetConfig.getValueString());
            sequenceEncoder.append(this.matchRotationConfig.getValueString());
            sequenceEncoder.append(this.afterBurner.getValueString());
            sequenceEncoder.append(this.descConfig.getValueString());
            sequenceEncoder.append(this.slotId);
            sequenceEncoder.append(this.placementConfig.getSelectedIndex());
            sequenceEncoder.append(this.aboveConfig == null ? "false" : this.aboveConfig.getValueString());
            return PlaceMarker.ID + sequenceEncoder.getValue();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ChoosePieceDialog
        extends ChooseComponentPathDialog {
            private static final long serialVersionUID = 1L;

            public ChoosePieceDialog(Frame frame, Class<PieceSlot> clazz) {
                super(frame, clazz);
            }

            @Override
            protected boolean isValidTarget(Object object) {
                return super.isValidTarget(object) || CardSlot.class.isInstance(object);
            }
        }
    }
}

