/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.launch.ModuleManagerWindow;
import VASSAL.tools.DataArchive;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.image.tilecache.ImageTileDiskCache;
import VASSAL.tools.image.tilecache.TileUtils;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.io.FileStore;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.io.InputOutputStreamPump;
import VASSAL.tools.io.ProcessLauncher;
import VASSAL.tools.io.ProcessWrapper;
import VASSAL.tools.lang.Pair;
import VASSAL.tools.swing.EDT;
import VASSAL.tools.swing.ProgressDialog;
import VASSAL.tools.swing.Progressor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilingHandler {
    private static final Logger logger = LoggerFactory.getLogger(TilingHandler.class);
    protected final String aname;
    protected final File cdir;
    protected final Dimension tdim;
    protected final int maxheap_limit;
    protected final int pid;

    public TilingHandler(String string, File file, Dimension dimension, int n, int n2) {
        this.aname = string;
        this.cdir = file;
        this.tdim = dimension;
        this.maxheap_limit = n;
        this.pid = n2;
    }

    protected boolean isFresh(FileArchive fileArchive, FileStore fileStore, String string) throws IOException {
        String string2 = TileUtils.tileName(string, 0, 0, 1);
        long l = fileArchive.getMTime(string);
        return l > 0L && l <= fileStore.getMTime(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getImageSize(DataArchive dataArchive, String string) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = dataArchive.getInputStream(string);
            Dimension dimension = ImageUtils.getImageSize(string, inputStream);
            inputStream.close();
            Dimension dimension2 = dimension;
            return dimension2;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    protected Pair<Integer, Integer> findImages(DataArchive dataArchive, FileStore fileStore, List<String> list, List<Pair<String, IOException>> list2) throws IOException {
        SortedSet<String> sortedSet = dataArchive.getImageNameSet();
        int n = 0;
        int n2 = 0;
        FileArchive fileArchive = dataArchive.getArchive();
        for (String string : sortedSet) {
            int n3;
            Dimension dimension;
            String string2 = "images/" + string;
            if (this.isFresh(fileArchive, fileStore, string2)) continue;
            try {
                dimension = this.getImageSize(dataArchive, string2);
            }
            catch (IOException iOException) {
                list2.add(Pair.of(string2, iOException));
                continue;
            }
            int n4 = n3 = TileUtils.tileCountAtScale(dimension, this.tdim, 1) > 1 ? TileUtils.tileCount(dimension, this.tdim) : 0;
            if (n3 == 0) continue;
            n2 += n3;
            list.add(string2);
            if (dimension.width * dimension.height <= n) continue;
            n = dimension.width * dimension.height;
        }
        return new Pair<Integer, Integer>(n2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    protected void runSlicer(List<String> list, int n, int n2) throws CancellationException, IOException {
        Object object2;
        InetAddress inetAddress = InetAddress.getByName(null);
        ServerSocket serverSocket = new ServerSocket(0, 0, inetAddress);
        int n3 = serverSocket.getLocalPort();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(Info.javaBinPath, "-classpath", System.getProperty("java.class.path"), "-Xmx" + n2 + "M", "-DVASSAL.id=" + this.pid, "-Duser.home=" + System.getProperty("user.home"), "-DVASSAL.port=" + n3, "VASSAL.tools.image.tilecache.ZipFileImageTiler", this.aname, this.cdir.getAbsolutePath(), String.valueOf(this.tdim.width), String.valueOf(this.tdim.height)));
        final ProgressDialog progressDialog = ProgressDialog.createOnEDT(ModuleManagerWindow.getInstance(), "Processing Image Tiles", " ");
        InputOutputStreamPump inputOutputStreamPump = new InputOutputStreamPump(null, System.out);
        InputOutputStreamPump inputOutputStreamPump2 = new InputOutputStreamPump(null, System.err);
        final ProcessWrapper processWrapper = new ProcessLauncher().launch(null, inputOutputStreamPump, inputOutputStreamPump2, arrayList.toArray(new String[arrayList.size()]));
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(processWrapper.stdin);
            for (Object object2 : list) {
                printWriter.println((String)object2);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(printWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)printWriter);
        Object object3 = null;
        object2 = null;
        try {
            object3 = serverSocket.accept();
            ((Socket)object3).shutdownOutput();
            object2 = new DataInputStream(((Socket)object3).getInputStream());
            Progressor progressor = new Progressor(0, n){

                @Override
                protected void run(Pair<Integer, Integer> pair) {
                    progressDialog.setProgress(100 * (Integer)pair.second / this.max);
                }
            };
            EDT.execute(new Runnable(){

                public void run() {
                    progressDialog.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            progressDialog.setVisible(false);
                            processWrapper.future.cancel(true);
                        }
                    });
                }
            });
            boolean bl = false;
            block16: while (!bl) {
                byte by = ((DataInputStream)object2).readByte();
                switch (by) {
                    case 1: {
                        final String string = ((DataInputStream)object2).readUTF();
                        EDT.execute(new Runnable(){

                            public void run() {
                                progressDialog.setLabel("Tiling " + string);
                                if (!progressDialog.isVisible()) {
                                    progressDialog.setVisible(true);
                                }
                            }
                        });
                        continue block16;
                    }
                    case 2: {
                        progressor.increment();
                        if (progressor.get() < n) continue block16;
                        progressDialog.setVisible(false);
                        continue block16;
                    }
                    case 3: {
                        bl = true;
                        continue block16;
                    }
                }
                throw new IllegalStateException("bad type: " + by);
            }
            ((FilterInputStream)object2).close();
            ((Socket)object3).close();
            serverSocket.close();
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly((InputStream)object2);
            IOUtils.closeQuietly((Socket)object3);
            IOUtils.closeQuietly((ServerSocket)serverSocket);
        }
        try {
            int n4 = processWrapper.future.get();
            if (n4 != 0) {
                throw new IOException("return value == " + n4);
            }
        }
        catch (ExecutionException executionException) {
            throw new IllegalStateException(executionException);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    protected void makeHashDirs() throws IOException {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                File file = new File(String.format("%s/%1x/%1x%1x", this.cdir, i, i, j));
                FileUtils.forceMkdir((File)file);
            }
        }
    }

    protected void cleanup() throws IOException {
        FileUtils.forceDelete((File)this.cdir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sliceTiles() throws CancellationException, IOException {
        Pair<Integer, Integer> pair;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Pair<String, IOException>> arrayList2 = new ArrayList<Pair<String, IOException>>();
        DataArchive dataArchive = null;
        try {
            dataArchive = new DataArchive(this.aname);
            ImageTileDiskCache imageTileDiskCache = new ImageTileDiskCache(this.cdir.getAbsolutePath());
            pair = this.findImages(dataArchive, imageTileDiskCache, arrayList, arrayList2);
            dataArchive.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(dataArchive);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)dataArchive);
        if (arrayList.isEmpty()) {
            logger.info("No images to tile.");
            return;
        }
        this.makeHashDirs();
        int n = (Integer)pair.first;
        int n2 = 4 * (Integer)pair.second >> 20;
        int n3 = (int)(1.66 * (double)n2 + 150.0);
        int n4 = Math.min(n3, this.maxheap_limit);
        try {
            this.runSlicer(arrayList, (Integer)pair.first, n4);
        }
        catch (CancellationException cancellationException) {
            this.cleanup();
            throw cancellationException;
        }
        catch (IOException iOException) {
            this.cleanup();
            throw iOException;
        }
    }
}

