/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import VASSAL.tools.io.IOUtils;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class JPEGDecoder {
    static final int TEM = 65281;
    static final int SOF0 = 65472;
    static final int SOF1 = 65473;
    static final int SOF2 = 65474;
    static final int SOF3 = 65475;
    static final int SOF4 = 65476;
    static final int SOF5 = 65477;
    static final int SOF6 = 65478;
    static final int SOF7 = 65479;
    static final int SOF8 = 65480;
    static final int SOF9 = 65481;
    static final int SOF10 = 65482;
    static final int SOF11 = 65483;
    static final int SOF12 = 65484;
    static final int SOF13 = 65485;
    static final int SOF14 = 65486;
    static final int SOF15 = 65487;
    static final int RST0 = 65488;
    static final int RST1 = 65489;
    static final int RST2 = 65490;
    static final int RST3 = 65491;
    static final int RST4 = 65492;
    static final int RST5 = 65493;
    static final int RST6 = 65494;
    static final int RST7 = 65495;
    static final int SOI = 65496;
    static final int EOI = 65497;
    static final int SOS = 65498;
    static final int APP0 = 65504;
    static final int APP2 = 65506;
    static final int APP13 = 65517;
    static final int APP14 = 65518;

    protected JPEGDecoder() {
    }

    public static boolean decodeSignature(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readUnsignedShort() == 65496;
    }

    public static Chunk decodeChunk(DataInputStream dataInputStream) throws IOException {
        byte[] byArray;
        int n = dataInputStream.readUnsignedShort();
        if ((n & 0xFF00) != 65280) {
            throw new IOException("initial byte of chunk must be FF");
        }
        if (n == 65281 || 65488 <= n && n <= 65497) {
            byArray = new byte[]{};
        } else {
            int n2 = dataInputStream.readUnsignedShort();
            byArray = new byte[n2 - 2];
            dataInputStream.readFully(byArray);
        }
        return new Chunk(n, byArray);
    }

    public static void main(String[] stringArray) throws IOException {
        DataInputStream dataInputStream = null;
        try {
            Chunk chunk;
            dataInputStream = new DataInputStream(new FileInputStream(stringArray[0]));
            if (!JPEGDecoder.decodeSignature(dataInputStream)) {
                System.out.println("Not a JPEG");
            }
            do {
                chunk = JPEGDecoder.decodeChunk(dataInputStream);
                System.out.println("type == " + Integer.toHexString(chunk.type) + ", length == " + chunk.data.length);
            } while (chunk.type != 65497);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(dataInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)dataInputStream);
    }

    public static class Chunk {
        public final int type;
        public final byte[] data;

        private Chunk(int n, byte[] byArray) {
            this.type = n;
            this.data = byArray;
        }
    }
}

