/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.ipc;

import VASSAL.tools.concurrent.listener.DefaultMultiEventListenerSupport;
import VASSAL.tools.concurrent.listener.EventListener;
import VASSAL.tools.concurrent.listener.MultiEventListenerSupport;
import VASSAL.tools.ipc.Fin;
import VASSAL.tools.ipc.Halt;
import VASSAL.tools.ipc.IPCMessage;
import VASSAL.tools.ipc.IPCMessageDispatcher;
import VASSAL.tools.ipc.IPCMessageReceiver;
import com.google.common.util.concurrent.ValueFuture;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPCMessenger {
    protected final AtomicLong next_id = new AtomicLong(0L);
    protected final Map<Long, ValueFuture<IPCMessage>> waiting = new ConcurrentHashMap<Long, ValueFuture<IPCMessage>>();
    protected final BlockingQueue<IPCMessage> outqueue = new LinkedBlockingQueue<IPCMessage>();
    protected final ObjectInputStream in;
    protected final ObjectOutputStream out;
    protected final MultiEventListenerSupport lsup;

    public IPCMessenger(InputStream inputStream, OutputStream outputStream, MultiEventListenerSupport multiEventListenerSupport) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("out == null");
        }
        if (multiEventListenerSupport == null) {
            throw new IllegalArgumentException("lsup == null");
        }
        this.out = new ObjectOutputStream(outputStream);
        this.in = new ObjectInputStream(inputStream);
        this.lsup = multiEventListenerSupport;
    }

    public IPCMessenger(Socket socket) throws IOException {
        this(socket.getInputStream(), socket.getOutputStream());
    }

    public IPCMessenger(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("out == null");
        }
        this.out = new ObjectOutputStream(outputStream);
        this.in = new ObjectInputStream(inputStream);
        this.lsup = new DefaultMultiEventListenerSupport(this);
        this.lsup.addEventListener(IPCMessage.class, new EventListener<IPCMessage>(){

            @Override
            public void receive(Object object, IPCMessage iPCMessage) {
                if (iPCMessage.isReply()) {
                    ValueFuture<IPCMessage> valueFuture = IPCMessenger.this.waiting.remove(iPCMessage.getInReplyTo());
                    if (valueFuture == null) {
                        throw new IllegalStateException(iPCMessage.toString());
                    }
                    valueFuture.set((Object)iPCMessage);
                }
            }
        });
        this.lsup.addEventListener(Halt.class, new EventListener<Halt>(){

            @Override
            public void receive(Object object, Halt halt) {
                try {
                    IPCMessenger.this.send(new Fin(halt));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public void start() throws IOException {
        IPCMessageReceiver iPCMessageReceiver = new IPCMessageReceiver(this.in, this.lsup);
        new Thread((Runnable)iPCMessageReceiver, "IPC receiver for " + this.hashCode()).start();
        IPCMessageDispatcher iPCMessageDispatcher = new IPCMessageDispatcher(this.outqueue, this.out);
        new Thread((Runnable)iPCMessageDispatcher, "IPC dispatcher for " + this.hashCode()).start();
    }

    public void stop() throws IOException {
        Future<IPCMessage> future = this.send(new Halt());
        try {
            future.get();
        }
        catch (CancellationException cancellationException) {
            throw new IllegalStateException(cancellationException);
        }
        catch (ExecutionException executionException) {
            throw new IllegalStateException(executionException);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    public Future<IPCMessage> send(IPCMessage iPCMessage) throws IOException {
        if (iPCMessage == null) {
            throw new IllegalArgumentException("msg == null");
        }
        iPCMessage.setId(this.next_id.getAndIncrement());
        ValueFuture valueFuture = ValueFuture.create();
        if (iPCMessage.expectsReply()) {
            this.waiting.put(iPCMessage.getId(), (ValueFuture<IPCMessage>)valueFuture);
        } else {
            valueFuture.set(null);
        }
        this.outqueue.offer(iPCMessage);
        return valueFuture;
    }

    public <T> void addEventListener(Class<T> clazz, EventListener<? super T> eventListener) {
        this.lsup.addEventListener(clazz, eventListener);
    }

    public <T> void removeEventListener(Class<T> clazz, EventListener<? super T> eventListener) {
        this.lsup.removeEventListener(clazz, eventListener);
    }

    public boolean hasEventListeners(Class<?> clazz) {
        return this.lsup.hasEventListeners(clazz);
    }

    public <T> List<EventListener<? super T>> getEventListeners(Class<T> clazz) {
        return this.lsup.getEventListeners(clazz);
    }
}

