/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.menu;

import VASSAL.tools.menu.ChildProxy;
import VASSAL.tools.menu.MenuBarProxy;
import VASSAL.tools.menu.MenuItemProxy;
import VASSAL.tools.menu.MenuMarker;
import VASSAL.tools.menu.MenuProxy;
import VASSAL.tools.menu.ParentProxy;
import VASSAL.tools.menu.SeparatorProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenuBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MenuManager {
    protected static MenuManager instance;
    private Map<String, List<MenuItemProxy>> actionLocations = new HashMap<String, List<MenuItemProxy>>();
    private Map<String, MenuMarker> markers = new HashMap<String, MenuMarker>();

    public static MenuManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException();
        }
        return instance;
    }

    public MenuManager() {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
    }

    public abstract JMenuBar getMenuBarFor(JFrame var1);

    public abstract MenuBarProxy getMenuBarProxyFor(JFrame var1);

    public MenuItemProxy addKey(String string) {
        List<MenuItemProxy> list = this.actionLocations.get(string);
        if (list == null) {
            list = new ArrayList<MenuItemProxy>();
            this.actionLocations.put(string, list);
        }
        MenuItemProxy menuItemProxy = new MenuItemProxy();
        list.add(menuItemProxy);
        return menuItemProxy;
    }

    public List<MenuItemProxy> getItems(String string) {
        return this.actionLocations.get(string);
    }

    public void addAction(String string, Action action) {
        List<MenuItemProxy> list = this.actionLocations.get(string);
        if (list != null) {
            for (MenuItemProxy menuItemProxy : list) {
                menuItemProxy.setAction(action);
            }
        }
    }

    public void removeAction(String string) {
        this.addAction(string, null);
    }

    public MenuMarker getMarker(String string) {
        return this.markers.get(string);
    }

    public MenuMarker addMarker(String string) {
        MenuMarker menuMarker = new MenuMarker();
        this.markers.put(string, menuMarker);
        return menuMarker;
    }

    public void addToSection(String string, ChildProxy<?> childProxy) {
        MenuMarker menuMarker = this.getMarker(string + ".start");
        MenuMarker menuMarker2 = this.getMarker(string + ".end");
        ParentProxy parentProxy = menuMarker2.getParent();
        int n = parentProxy.getIndex(menuMarker);
        int n2 = parentProxy.getIndex(menuMarker2);
        if (parentProxy instanceof MenuProxy && n + 1 == n2) {
            if (this.nextVisibleItemNotASeparator(menuMarker2)) {
                ((MenuProxy)parentProxy).insertSeparator(n2 + 1);
            }
            if (this.prevVisibleItemNotASeparator(menuMarker)) {
                ((MenuProxy)parentProxy).insertSeparator(n);
            }
        }
        parentProxy.insert(childProxy, n2);
    }

    public void removeFromSection(String string, ChildProxy<?> childProxy) {
        int n;
        int n2;
        MenuMarker menuMarker = this.getMarker(string + ".start");
        MenuMarker menuMarker2 = this.getMarker(string + ".end");
        ParentProxy parentProxy = menuMarker2.getParent();
        parentProxy.remove(childProxy);
        if (parentProxy instanceof MenuProxy && (n2 = parentProxy.getIndex(menuMarker)) + 1 == (n = parentProxy.getIndex(menuMarker2))) {
            if (this.visibleItemBefore(menuMarker)) {
                parentProxy.remove(n2 - 1);
            } else if (this.visibleItemAfter(menuMarker2)) {
                parentProxy.remove(n + 1);
            }
        }
    }

    private boolean visibleItemAfter(ChildProxy<?> childProxy) {
        ParentProxy parentProxy = childProxy.getParent();
        int n = parentProxy.getChildCount();
        for (int i = parentProxy.getIndex(childProxy) + 1; i < n; ++i) {
            ChildProxy<?> childProxy2 = parentProxy.getChild(i);
            if (childProxy2 instanceof MenuMarker) continue;
            return true;
        }
        return false;
    }

    private boolean visibleItemBefore(ChildProxy<?> childProxy) {
        ParentProxy parentProxy = childProxy.getParent();
        for (int i = parentProxy.getIndex(childProxy) - 1; i >= 0; ++i) {
            ChildProxy<?> childProxy2 = parentProxy.getChild(i);
            if (childProxy2 instanceof MenuMarker) continue;
            return true;
        }
        return false;
    }

    private boolean nextVisibleItemNotASeparator(ChildProxy<?> childProxy) {
        ParentProxy parentProxy = childProxy.getParent();
        int n = parentProxy.getChildCount();
        for (int i = parentProxy.getIndex(childProxy) + 1; i < n; ++i) {
            ChildProxy<?> childProxy2 = parentProxy.getChild(i);
            if (childProxy2 instanceof MenuMarker) continue;
            return !(childProxy2 instanceof SeparatorProxy);
        }
        return false;
    }

    private boolean prevVisibleItemNotASeparator(ChildProxy<?> childProxy) {
        ParentProxy parentProxy = childProxy.getParent();
        for (int i = parentProxy.getIndex(childProxy) - 1; i >= 0; --i) {
            ChildProxy<?> childProxy2 = parentProxy.getChild(i);
            if (childProxy2 instanceof MenuMarker) continue;
            return !(childProxy2 instanceof SeparatorProxy);
        }
        return false;
    }
}

